/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network;

import android.content.SharedPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;

public class TiCookieStore
implements CookieStore {
    private static final String LCAT = "TiCookieStore";
    private static final String COOKIE_PREFERENCES = "TiCookiePreferences";
    private static final String COOKIE_PREFIX = "ti_cookie_";
    private CookieStore cookieStore = new BasicCookieStore();
    private final SharedPreferences pref = TiApplication.getInstance().getSharedPreferences("TiCookiePreferences", 0);
    private static TiCookieStore _instance;

    public static TiCookieStore getInstance() {
        if (_instance == null) {
            _instance = new TiCookieStore();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiCookieStore() {
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            Map allPrefs = this.pref.getAll();
            if (!allPrefs.isEmpty()) {
                Set keys = allPrefs.keySet();
                for (String key : keys) {
                    Cookie cookie;
                    String encodedCookie;
                    if (!key.startsWith(COOKIE_PREFIX) || (encodedCookie = (String)allPrefs.get(key)) == null || (cookie = this.decodeCookie(encodedCookie)) == null) continue;
                    this.cookieStore.addCookie(cookie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        String encodedCookie = this.encodeCookie(cookie);
        SharedPreferences.Editor prefWriter = this.pref.edit();
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            if (encodedCookie == null) {
                return;
            }
            this.cookieStore.addCookie(cookie);
            prefWriter.putString(COOKIE_PREFIX + cookie.getName(), encodedCookie);
            prefWriter.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SharedPreferences.Editor prefWriter = this.pref.edit();
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            for (String name : this.getCookieNames()) {
                prefWriter.remove(COOKIE_PREFIX + name);
            }
            prefWriter.commit();
            this.cookieStore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearExpired(Date date) {
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            List cookies = this.cookieStore.getCookies();
            boolean clearedExpired = this.cookieStore.clearExpired(date);
            if (clearedExpired) {
                SharedPreferences.Editor prefWriter = this.pref.edit();
                for (Cookie cookie : cookies) {
                    if (!cookie.isExpired(date)) continue;
                    prefWriter.remove(COOKIE_PREFIX + cookie.getName());
                }
                prefWriter.commit();
            }
            return clearedExpired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cookie> getCookies() {
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            return this.cookieStore.getCookies();
        }
    }

    private List<String> getCookieNames() {
        List cookies = this.cookieStore.getCookies();
        ArrayList<String> cookieNames = new ArrayList<String>();
        for (Cookie cookie : cookies) {
            cookieNames.add(cookie.getName());
        }
        return cookieNames;
    }

    private Cookie decodeCookie(String cookieString) {
        byte[] cookieBytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(cookieBytes);
        BasicClientCookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            String name = (String)objectInputStream.readObject();
            String value = (String)objectInputStream.readObject();
            cookie = new BasicClientCookie(name, value);
            cookie.setComment((String)objectInputStream.readObject());
            cookie.setDomain((String)objectInputStream.readObject());
            cookie.setVersion(objectInputStream.readInt());
            cookie.setSecure(objectInputStream.readBoolean());
            cookie.setExpiryDate((Date)objectInputStream.readObject());
            cookie.setPath((String)objectInputStream.readObject());
        }
        catch (Exception e) {
            Log.w((String)LCAT, (String)"Failed to decode cookie");
            return null;
        }
        return cookie;
    }

    private String encodeCookie(Cookie cookie) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(cookie.getName());
            objectOutputStream.writeObject(cookie.getValue());
            objectOutputStream.writeObject(cookie.getComment());
            objectOutputStream.writeObject(cookie.getDomain());
            objectOutputStream.writeInt(cookie.getVersion());
            objectOutputStream.writeBoolean(cookie.isSecure());
            objectOutputStream.writeObject(cookie.getExpiryDate());
            objectOutputStream.writeObject(cookie.getPath());
        }
        catch (Exception e) {
            Log.w((String)LCAT, (String)"Failed to encode cookie");
            return null;
        }
        return new String(Hex.encodeHex((byte[])outputStream.toByteArray()));
    }

    protected byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

