/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.appcelerator.titanium.util.Log;
import ti.modules.titanium.network.NonValidatingTrustManager;

public class NonValidatingSSLSocketFactory
implements LayeredSocketFactory {
    private SSLSocketFactory sslFactory;
    private static final String LCAT = "NVSSLSocketFactory";

    public NonValidatingSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] managers = new TrustManager[]{new NonValidatingTrustManager()};
            context.init(null, managers, new SecureRandom());
            this.sslFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            Log.e((String)LCAT, (String)e.getMessage(), (Throwable)e);
        }
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket());
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sslsock.bind(isa);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        sslsock.connect(remoteAddress, connTimeout);
        sslsock.setSoTimeout(soTimeout);
        return sslsock;
    }

    public Socket createSocket() throws IOException {
        return this.sslFactory.createSocket();
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return true;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslFactory.createSocket(socket, host, port, autoClose);
    }
}

