/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network;

import android.app.Activity;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.network.TiNetworkListener;

public class NetworkModule
extends KrollModule {
    private static final String LCAT = "TiNetwork";
    private static final boolean DBG = TiConfig.LOGD;
    public static final String EVENT_CONNECTIVITY = "change";
    public static final String NETWORK_USER_AGENT = System.getProperties().getProperty("http.agent");
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_MOBILE = 2;
    public static final int NETWORK_LAN = 3;
    public static final int NETWORK_UNKNOWN = 4;
    private NetInfo lastNetInfo;
    private boolean isListeningForConnectivity = false;
    private TiNetworkListener networkListener;
    private ConnectivityManager connectivityManager;
    private Handler messageHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Bundle b = msg.getData();
            boolean connected = b.getBoolean("connected");
            int type = b.getInt("networkType");
            String typeName = b.getString("networkTypeName");
            boolean failover = b.getBoolean("failover");
            String reason = b.getString("reason");
            NetInfo netInfo = NetworkModule.this.lastNetInfo;
            synchronized (netInfo) {
                ((NetworkModule)NetworkModule.this).lastNetInfo.state = connected ? State.CONNECTED : State.NOT_CONNECTED;
                ((NetworkModule)NetworkModule.this).lastNetInfo.type = type;
                ((NetworkModule)NetworkModule.this).lastNetInfo.typeName = typeName;
                ((NetworkModule)NetworkModule.this).lastNetInfo.failover = failover;
                ((NetworkModule)NetworkModule.this).lastNetInfo.reason = reason;
            }
            KrollDict data = new KrollDict();
            data.put((Object)"online", (Object)connected);
            int titaniumType = NetworkModule.this.networkTypeToTitanium(connected, type);
            data.put((Object)"networkType", (Object)titaniumType);
            data.put((Object)"networkTypeName", (Object)NetworkModule.this.networkTypeToTypeName(titaniumType));
            data.put((Object)"reason", (Object)reason);
            NetworkModule.this.fireEvent(NetworkModule.EVENT_CONNECTIVITY, data);
        }
    };

    public NetworkModule(TiContext tiContext) {
        super(tiContext);
        this.lastNetInfo = new NetInfo();
        this.setProperty("userAgent", NETWORK_USER_AGENT + " Titanium/" + tiContext.getTiApp().getTiBuildVersion());
        tiContext.addOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
        this.eventManager.addOnEventChangeListener((OnEventListenerChange)this);
    }

    public void listenerAdded(String type, int count, KrollProxy proxy) {
        if (EVENT_CONNECTIVITY.equals(type) && !this.isListeningForConnectivity) {
            this.manageConnectivityListener(true);
        }
    }

    public void listenerRemoved(String type, int count, KrollProxy proxy) {
        if (EVENT_CONNECTIVITY.equals(type) && count == 0) {
            this.manageConnectivityListener(false);
        }
    }

    public boolean getOnline() {
        boolean result = false;
        ConnectivityManager cm = this.getConnectivityManager();
        if (cm != null) {
            NetworkInfo ni = this.getConnectivityManager().getActiveNetworkInfo();
            if (ni != null && ni.isAvailable() && ni.isConnected()) {
                result = true;
            }
        } else if (DBG) {
            Log.w((String)LCAT, (String)"ConnectivityManager was null");
        }
        return result;
    }

    protected int networkTypeToTitanium(boolean online, int androidType) {
        int type = 4;
        if (online) {
            switch (androidType) {
                case 1: {
                    type = 1;
                    break;
                }
                case 0: {
                    type = 2;
                    break;
                }
                default: {
                    type = 4;
                    break;
                }
            }
        } else {
            type = 0;
        }
        return type;
    }

    public int getNetworkType() {
        int type = 4;
        if (this.connectivityManager == null) {
            this.connectivityManager = this.getConnectivityManager();
        }
        try {
            NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
            type = ni != null && ni.isAvailable() && ni.isConnected() ? this.networkTypeToTitanium(true, ni.getType()) : 0;
        }
        catch (SecurityException e) {
            Log.w((String)LCAT, (String)("Permission has been removed. Cannot determine network type: " + e.getMessage()));
        }
        return type;
    }

    public String getNetworkTypeName() {
        return this.networkTypeToTypeName(this.getNetworkType());
    }

    private String networkTypeToTypeName(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE";
            }
            case 3: {
                return "LAN";
            }
        }
        return "UNKNOWN";
    }

    public String encodeURIComponent(String component) {
        return Uri.encode((String)component);
    }

    public String decodeURIComponent(String component) {
        return Uri.decode((String)component);
    }

    protected void manageConnectivityListener(boolean attach) {
        if (attach) {
            if (!this.isListeningForConnectivity && this.hasListeners(EVENT_CONNECTIVITY)) {
                if (this.networkListener == null) {
                    this.networkListener = new TiNetworkListener(this.messageHandler);
                }
                this.networkListener.attach(this.getTiContext().getActivity().getApplicationContext());
                this.isListeningForConnectivity = true;
                if (DBG) {
                    Log.d((String)LCAT, (String)"Resuming: adding connectivity listener");
                }
            }
        } else if (this.isListeningForConnectivity) {
            this.networkListener.detach();
            this.isListeningForConnectivity = false;
            if (DBG) {
                Log.d((String)LCAT, (String)"Pausing: removing connectivity listener.");
            }
        }
    }

    private ConnectivityManager getConnectivityManager() {
        ConnectivityManager cm = null;
        TiApplication a = this.getTiContext().getTiApp();
        if (a != null) {
            cm = (ConnectivityManager)a.getSystemService("connectivity");
        } else if (DBG) {
            Log.w((String)LCAT, (String)"Activity is null when trying to retrieve the connectivity service");
        }
        return cm;
    }

    public void onResume(Activity activity) {
        super.onResume(activity);
        this.connectivityManager = this.getConnectivityManager();
        this.manageConnectivityListener(true);
    }

    public void onPause(Activity activity) {
        this.manageConnectivityListener(false);
        this.connectivityManager = null;
    }

    class NetInfo {
        public State state = State.UNKNOWN;
        public boolean failover = false;
        public String typeName = "NONE";
        public int type = -1;
        public String reason = "";
    }

    public static enum State {
        UNKNOWN,
        CONNECTED,
        NOT_CONNECTED;

    }
}

