/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media.android;

import android.app.Activity;
import android.app.WallpaperManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiDrawableReference;

public class AndroidModule
extends KrollModule {
    private static final String LCAT = "TiMedia.Android";

    public AndroidModule(TiContext context) {
        super(context);
    }

    public void scanMediaFiles(KrollInvocation invocation, Object[] paths, Object[] mimeTypes, KrollCallback callback) {
        new MediaScannerClient(invocation.getTiContext(), paths, mimeTypes, callback).scan();
    }

    public void setSystemWallpaper(KrollInvocation invocation, TiBlob image, boolean scale) {
        Activity ctx = invocation.getActivity();
        WallpaperManager wm = WallpaperManager.getInstance((Context)ctx);
        TiDrawableReference ref = TiDrawableReference.fromBlob((TiContext)invocation.getTiContext(), (TiBlob)image);
        Bitmap b = null;
        b = scale ? ref.getBitmap(wm.getDesiredMinimumWidth()) : ref.getBitmap();
        if (b != null) {
            try {
                wm.setBitmap(b);
            }
            catch (IOException e) {
                Log.e((String)LCAT, (String)"Unable to set wallpaper bitmap", (Throwable)e);
            }
        } else {
            Log.w((String)LCAT, (String)"Unable to get bitmap to set wallpaper");
        }
    }

    public static class MediaScannerClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private TiContext context;
        private Object[] paths;
        private Object[] mimeTypes;
        private KrollCallback callback;
        private MediaScannerConnection connection;
        private AtomicInteger completedScanCount = new AtomicInteger(0);

        MediaScannerClient(TiContext context, Object[] paths, Object[] mimeTypes, KrollCallback callback) {
            this.context = context;
            this.paths = paths;
            this.mimeTypes = mimeTypes;
            this.callback = callback;
        }

        public MediaScannerClient(TiContext context, Object[] paths, Object[] mimeTypes) {
            this.context = context;
            this.paths = paths;
            this.mimeTypes = mimeTypes;
        }

        public void onMediaScannerConnected() {
            if (this.paths == null || this.paths.length == 0) {
                this.connection.disconnect();
                return;
            }
            for (int i = 0; i < this.paths.length; ++i) {
                String path = this.context.resolveUrl(TiConvert.toString((Object)this.paths[i]));
                if (path.startsWith("file://")) {
                    path = path.substring("file://".length());
                }
                String mimeType = null;
                if (this.mimeTypes != null && this.mimeTypes.length > i) {
                    mimeType = TiConvert.toString((Object)this.mimeTypes[i]);
                }
                this.connection.scanFile(path, mimeType);
            }
        }

        public void onScanCompleted(String path, Uri uri) {
            if (this.completedScanCount.incrementAndGet() >= this.paths.length) {
                this.connection.disconnect();
            }
            if (this.callback != null) {
                KrollDict properties = new KrollDict(2);
                properties.put((Object)"path", (Object)path);
                properties.put((Object)"uri", (Object)(uri == null ? null : uri.toString()));
                this.callback.callAsync(properties);
            }
        }

        public void scan() {
            if (this.paths == null || this.paths.length == 0) {
                return;
            }
            this.connection = new MediaScannerConnection((Context)this.context.getAndroidContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.connection.connect();
        }
    }
}

