/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.media.TiVideoActivity;

public class VideoPlayerProxy
extends KrollProxy {
    private static final String LCAT = "VideoPlayerProxy";
    private static final boolean DBG = TiConfig.LOGD;
    protected static final int CONTROL_MSG_LOAD = 100;
    protected static final int CONTROL_MSG_COMPLETE = 101;
    private Handler controlHandler;
    private Messenger activityMessenger;
    private List<TiViewProxy> children = Collections.synchronizedList(new ArrayList());
    private boolean play;
    private int mediaControlStyle = 0;
    private int scalingMode = 2;

    public VideoPlayerProxy(TiContext tiContext) {
        super(tiContext);
    }

    public void handleCreationDict(KrollDict options) {
        TiContext tiContext = this.getTiContext();
        Intent intent = new Intent((Context)tiContext.getActivity(), TiVideoActivity.class);
        String url = null;
        if (options.containsKey((Object)"contentURL")) {
            url = TiConvert.toString((KrollDict)options, (String)"contentURL");
            Log.w((String)LCAT, (String)"contentURL is deprecated, use url instead");
        } else if (options.containsKey((Object)"url")) {
            url = TiConvert.toString((KrollDict)options, (String)"url");
        }
        if (url != null) {
            url = tiContext.resolveUrl(null, url);
            if (DBG) {
                Log.d((String)LCAT, (String)("Video source: " + url));
            }
            intent.putExtra("contentURL", url);
        }
        if (options.containsKey((Object)"backgroundColor")) {
            intent.putExtra("backgroundColor", TiConvert.toColor((KrollDict)options, (String)"backgroundColor"));
        }
        if (options.containsKey((Object)"play")) {
            intent.putExtra("play", TiConvert.toBoolean((KrollDict)options, (String)"play"));
        }
        if (options.containsKey((Object)"mediaControlStyle")) {
            this.mediaControlStyle = TiConvert.toInt((KrollDict)options, (String)"mediaControlStyle");
        }
        intent.putExtra("mediaControlStyle", this.mediaControlStyle);
        if (options.containsKey((Object)"scalingMode")) {
            this.scalingMode = TiConvert.toInt((KrollDict)options, (String)"scalingMode");
        }
        intent.putExtra("scalingMode", this.scalingMode);
        this.controlHandler = this.createControlHandler();
        intent.putExtra("messenger", (Parcelable)new Messenger(this.controlHandler));
        ResultReceiver messengerReceiver = new ResultReceiver(this.controlHandler){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                super.onReceiveResult(resultCode, resultData);
                VideoPlayerProxy.this.setActivityMessenger((Messenger)resultData.getParcelable("messenger"));
                if (DBG) {
                    Log.d((String)VideoPlayerProxy.LCAT, (String)"TiVideoActivity messenger received. Releasing latch");
                }
            }
        };
        intent.putExtra("messengerReceiver", (Parcelable)messengerReceiver);
        tiContext.getActivity().startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActivityMessenger(Messenger messenger) {
        this.activityMessenger = messenger;
        List<TiViewProxy> list = this.children;
        synchronized (list) {
            for (TiViewProxy child : this.children) {
                this.sendAddMessage(child);
            }
        }
        if (this.play) {
            this.sendPlayMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TiViewProxy proxy) {
        if (this.activityMessenger != null) {
            this.sendAddMessage(proxy);
        } else {
            List<TiViewProxy> list = this.children;
            synchronized (list) {
                this.children.add(proxy);
            }
        }
    }

    protected void sendAddMessage(TiViewProxy proxy) {
        Message msg = Message.obtain();
        msg.what = 10001;
        msg.obj = proxy;
        try {
            this.activityMessenger.send(msg);
        }
        catch (RemoteException e) {
            Log.w((String)LCAT, (String)("Unable to add view, Activity is no longer available: " + e.getMessage()));
        }
    }

    public void play() {
        if (this.activityMessenger != null) {
            this.sendPlayMessage();
        } else {
            this.play = true;
        }
    }

    protected void sendPlayMessage() {
        try {
            Message msg = Message.obtain();
            msg.what = 10000;
            this.activityMessenger.send(msg);
        }
        catch (RemoteException e) {
            Log.w((String)LCAT, (String)("Unable to send play message: " + e.getMessage()));
        }
    }

    public void pause() {
        if (this.activityMessenger != null) {
            try {
                Message msg = Message.obtain();
                msg.what = 10005;
                this.activityMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)LCAT, (String)("Unable to send pause message: " + e.getMessage()));
            }
        }
    }

    public void start() {
        if (this.activityMessenger != null) {
            try {
                Message msg = Message.obtain();
                msg.what = 10006;
                this.activityMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)LCAT, (String)("Unable to send start message: " + e.getMessage()));
            }
        }
    }

    public void stop() {
        if (this.activityMessenger != null) {
            try {
                Message msg = Message.obtain();
                msg.what = 10002;
                this.activityMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)LCAT, (String)("Unable to send stop message: " + e.getMessage()));
            }
        } else {
            this.play = false;
        }
    }

    public void hide() {
        if (this.activityMessenger != null) {
            try {
                Message msg = Message.obtain();
                msg.what = 10003;
                this.activityMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)LCAT, (String)("Unable to send hide message: " + e.getMessage()));
            }
        }
    }

    public int getMediaControlStyle() {
        return this.mediaControlStyle;
    }

    public void setMediaControlStyle(int style) {
        if (style != this.mediaControlStyle) {
            this.mediaControlStyle = style;
            if (this.activityMessenger != null) {
                try {
                    Message msg = Message.obtain();
                    msg.what = 10004;
                    msg.arg1 = this.mediaControlStyle;
                    this.activityMessenger.send(msg);
                }
                catch (RemoteException e) {
                    Log.w((String)LCAT, (String)("Unable to send media control style change message: " + e.getMessage()));
                }
            }
        }
    }

    public int getScalingMode() {
        return this.scalingMode;
    }

    public void setScalingMode(int mode) {
        if (mode != this.scalingMode) {
            this.scalingMode = mode;
            if (this.activityMessenger != null) {
                try {
                    Message msg = Message.obtain();
                    msg.what = 10007;
                    msg.arg1 = this.scalingMode;
                    this.activityMessenger.send(msg);
                }
                catch (RemoteException e) {
                    Log.w((String)LCAT, (String)("Unable to send scaling mode message: " + e.getMessage()));
                }
            }
        }
    }

    private Handler createControlHandler() {
        return new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        if (DBG) {
                            Log.i((String)VideoPlayerProxy.LCAT, (String)"Video Loaded message received from TiVideoActivity");
                        }
                        VideoPlayerProxy.this.fireEvent("load", null);
                        return true;
                    }
                    case 101: {
                        if (DBG) {
                            Log.i((String)VideoPlayerProxy.LCAT, (String)"Video playback message received from TiVideoActivity");
                        }
                        VideoPlayerProxy.this.fireEvent("complete", null);
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

