/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.widget.MediaController;
import android.widget.TiVideoView4;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;

public class TiVideoActivity
extends Activity
implements Handler.Callback {
    private static final String LCAT = "TiVideoActivity";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int MSG_PLAY = 10000;
    public static final int MSG_ADD_VIEW = 10001;
    public static final int MSG_STOP_PLAYBACK = 10002;
    public static final int MSG_HIDE = 10003;
    public static final int MSG_MEDIA_CONTROL_STYLE_CHANGE = 10004;
    public static final int MSG_PAUSE_PLAYBACK = 10005;
    public static final int MSG_START_PLAYBACK = 10006;
    public static final int MSG_SCALING_MODE_CHANGE = 10007;
    private Handler handler;
    private String contentUrl;
    private Messenger proxyMessenger;
    private ResultReceiver messengerReceiver;
    private MediaController mediaController;
    private TiCompositeLayout layout;
    private TiVideoView4 videoView;
    private boolean started = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (DBG) {
            Log.i((String)LCAT, (String)"TiVideoActivity onCreate");
        }
        this.handler = new Handler((Handler.Callback)this);
        final Intent intent = this.getIntent();
        this.contentUrl = intent.getStringExtra("contentURL");
        boolean play = intent.getBooleanExtra("play", false);
        this.videoView = new TiVideoView4((Context)this){

            @Override
            protected void measureVideo(int videoWidth, int videoHeight, int widthMeasureSpec, int heightMeasureSpec) {
                Display d;
                String model;
                if (DBG) {
                    Log.e((String)TiVideoActivity.LCAT, (String)("******* mVideoWidth: " + videoWidth + " mVideoHeight: " + videoHeight + " width: " + View.MeasureSpec.getSize((int)widthMeasureSpec) + " height: " + View.MeasureSpec.getSize((int)heightMeasureSpec)));
                }
                int width = 1.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
                int height = 1.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
                if (videoWidth > 0 && videoHeight > 0) {
                    int mode = intent.getIntExtra("scalingMode", 2);
                    switch (mode) {
                        case 0: {
                            width = videoWidth;
                            height = videoHeight;
                            break;
                        }
                        case 1: {
                            if (videoWidth * height > width * videoHeight) {
                                width = height * videoWidth / videoHeight;
                                break;
                            }
                            if (videoWidth * height >= width * videoHeight) break;
                            height = width * videoHeight / videoWidth;
                            break;
                        }
                        case 2: {
                            if (videoWidth * height > width * videoHeight) {
                                height = width * videoHeight / videoWidth;
                                break;
                            }
                            if (videoWidth * height >= width * videoHeight) break;
                            width = height * videoWidth / videoHeight;
                            break;
                        }
                        case 3: {
                            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
                            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                        }
                    }
                }
                if ((model = TiPlatformHelper.getModel()) != null && model.equals("SPH-P100") && (d = TiVideoActivity.this.getWindowManager().getDefaultDisplay()) != null) {
                    DisplayMetrics dm = new DisplayMetrics();
                    d.getMetrics(dm);
                    if (TiPlatformHelper.applicationLogicalDensity != dm.densityDpi) {
                        int maxScaledWidth = (int)Math.floor((float)(d.getWidth() - 1) * TiPlatformHelper.applicationScaleFactor);
                        int maxScaledHeight = (int)Math.floor((float)(d.getHeight() - 1) * TiPlatformHelper.applicationScaleFactor);
                        if ((float)width * TiPlatformHelper.applicationScaleFactor > (float)maxScaledWidth) {
                            int oldWidth = width;
                            width = d.getWidth() - 1;
                            if (DBG) {
                                Log.d((String)TiVideoActivity.LCAT, (String)("TOO WIDE: " + oldWidth + " changed to " + width));
                            }
                        }
                        if ((float)height * TiPlatformHelper.applicationScaleFactor > (float)maxScaledHeight) {
                            int oldHeight = height;
                            height = d.getHeight() - 1;
                            if (DBG) {
                                Log.d((String)TiVideoActivity.LCAT, (String)("TOO HIGH: " + oldHeight + " changed to " + height));
                            }
                        }
                    }
                }
                if (DBG) {
                    Log.i((String)TiVideoActivity.LCAT, (String)("setting size: " + width + 'x' + height));
                }
                this.setMeasuredDimension(width, height);
            }
        };
        if (play) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)TiVideoActivity.LCAT, (String)"Setting URI");
                    TiVideoActivity.this.videoView.setVideoURI(Uri.parse((String)TiVideoActivity.this.contentUrl));
                    TiVideoActivity.this.videoView.start();
                    Log.i((String)TiVideoActivity.LCAT, (String)"URI Set, start called.");
                }
            });
            t.setPriority(9);
            t.start();
        }
        this.proxyMessenger = (Messenger)intent.getParcelableExtra("messenger");
        this.messengerReceiver = (ResultReceiver)intent.getParcelableExtra("messengerReceiver");
        if (intent.hasExtra("backgroundColor")) {
            ColorDrawable d = new ColorDrawable(intent.getIntExtra("backgroundColor", -65536));
            this.getWindow().setBackgroundDrawable((Drawable)d);
        }
        this.layout = new TiCompositeLayout((Context)this);
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                TiVideoActivity.this.sendProxyMessage(100);
            }
        });
        this.videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                TiVideoActivity.this.sendProxyMessage(101);
                TiVideoActivity.this.started = false;
            }
        });
        int style = 0;
        if (intent.hasExtra("mediaControlStyle")) {
            style = intent.getIntExtra("mediaControlStyle", 0);
            this.handleControlVisibility(style);
        }
        this.videoView.requestFocus();
        TiCompositeLayout.LayoutParams params = new TiCompositeLayout.LayoutParams();
        this.layout.addView((View)this.videoView, (ViewGroup.LayoutParams)params);
        this.setContentView((View)this.layout);
        Log.e((String)LCAT, (String)"exiting onCreate");
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 10000: {
                if (!this.started) {
                    Uri uri = Uri.parse((String)this.contentUrl);
                    this.videoView.setVideoURI(uri);
                }
                this.videoView.start();
                this.started = true;
                return true;
            }
            case 10001: {
                TiViewProxy proxy = (TiViewProxy)msg.obj;
                TiUIView tiv = proxy.getView((Activity)this);
                View v = tiv.getNativeView();
                if (v != null) {
                    this.layout.addView(v, (ViewGroup.LayoutParams)tiv.getLayoutParams());
                }
                return true;
            }
            case 10002: {
                if (this.videoView != null && this.started) {
                    this.videoView.stopPlayback();
                    this.started = false;
                    return true;
                }
                return false;
            }
            case 10005: {
                if (this.videoView != null && this.started) {
                    this.videoView.pause();
                    this.started = false;
                    return true;
                }
                return false;
            }
            case 10006: {
                if (this.videoView != null && !this.started) {
                    this.videoView.start();
                    this.started = true;
                    return true;
                }
                return false;
            }
            case 10003: {
                if (this.videoView != null && this.started) {
                    this.videoView.stopPlayback();
                    this.started = false;
                }
                this.finish();
                return true;
            }
            case 10004: {
                int style = msg.arg1;
                this.handleControlVisibility(style);
                return true;
            }
            case 10007: {
                int mode = msg.arg1;
                this.getIntent().putExtra("scalingMode", mode);
                this.layout.requestLayout();
                return true;
            }
        }
        return false;
    }

    private void handleControlVisibility(int style) {
        boolean showController = true;
        switch (style) {
            case 0: 
            case 1: 
            case 2: {
                showController = true;
                break;
            }
            case 3: 
            case 4: {
                showController = false;
            }
        }
        if (showController) {
            if (this.mediaController == null) {
                this.mediaController = new MediaController((Context)this);
            }
            this.videoView.setMediaController(this.mediaController);
        } else {
            this.videoView.setMediaController(null);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mediaController != null && this.mediaController.isShowing()) {
            this.mediaController.hide();
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.messengerReceiver != null) {
            if (DBG) {
                Log.d((String)LCAT, (String)"Sending messenger to VideoPlayerProxy");
            }
            Bundle resultData = new Bundle();
            resultData.putParcelable("messenger", (Parcelable)new Messenger(this.handler));
            this.messengerReceiver.send(0, resultData);
            this.messengerReceiver = null;
        }
    }

    protected void onResume() {
        super.onResume();
        ((TiApplication)this.getApplication()).setCurrentActivity((Activity)this, (Activity)this);
        if (this.started) {
            this.videoView.start();
        }
    }

    protected void onPause() {
        super.onPause();
        ((TiApplication)this.getApplication()).setCurrentActivity((Activity)this, null);
        this.videoView.pause();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.videoView.stopPlayback();
        this.layout.removeAllViews();
        if (this.proxyMessenger != null) {
            this.sendProxyMessage(101);
        }
    }

    private void sendProxyMessage(int messageId) {
        if (this.proxyMessenger != null) {
            Message msg = Message.obtain();
            msg.what = messageId;
            try {
                this.proxyMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)LCAT, (String)("VideoPlayerProxy no longer available: " + e.getMessage()));
            }
        }
    }
}

