/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.IOException;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;

public class TiUICameraPreview
extends TiUIView
implements SurfaceHolder.Callback {
    private static final String LCAT = "TiUICameraPreview";
    private Camera camera;
    private TiCompositeLayout overlayLayout;

    public TiUICameraPreview(TiViewProxy proxy, Camera camera) {
        super(proxy);
        this.camera = camera;
        SurfaceView preview = new SurfaceView((Context)proxy.getTiContext().getActivity());
        SurfaceHolder previewHolder = preview.getHolder();
        previewHolder.addCallback((SurfaceHolder.Callback)this);
        previewHolder.setType(3);
        FrameLayout previewLayout = new FrameLayout((Context)proxy.getTiContext().getActivity());
        previewLayout.addView((View)preview, (ViewGroup.LayoutParams)this.layoutParams);
        this.overlayLayout = new TiCompositeLayout((Context)proxy.getTiContext().getActivity());
        previewLayout.addView((View)this.overlayLayout);
        this.setNativeView((View)previewLayout);
        Log.i((String)"CameraTest", (String)"Camera started");
    }

    public void surfaceChanged(SurfaceHolder previewHolder, int format, int width, int height) {
        Log.i((String)LCAT, (String)"starting preview");
        this.camera.startPreview();
    }

    public void surfaceCreated(SurfaceHolder previewHolder) {
        Log.i((String)LCAT, (String)"opening camera");
        try {
            Log.i((String)LCAT, (String)"setting preview display");
            this.camera.setPreviewDisplay(previewHolder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void surfaceDestroyed(SurfaceHolder previewHolder) {
        this.camera.release();
        this.camera = null;
    }

    public void add(TiUIView overlayItem) {
        View overlayItemView;
        if (overlayItem != null && (overlayItemView = overlayItem.getNativeView()) != null) {
            this.overlayLayout.addView(overlayItemView, (ViewGroup.LayoutParams)overlayItem.getLayoutParams());
        }
    }
}

