/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.webkit.URLUtil;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollPropertyChange;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;

public class TiSound
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
KrollProxyListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnInfoListener {
    private static final String LCAT = "TiSound";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int STATE_BUFFERING = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_PAUSED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_STARTING = 4;
    public static final int STATE_STOPPED = 5;
    public static final int STATE_STOPPING = 6;
    public static final int STATE_WAITING_FOR_DATA = 7;
    public static final int STATE_WAITING_FOR_QUEUE = 8;
    public static final String STATE_BUFFERING_DESC = "buffering";
    public static final String STATE_INITIALIZED_DESC = "initialized";
    public static final String STATE_PAUSED_DESC = "paused";
    public static final String STATE_PLAYING_DESC = "playing";
    public static final String STATE_STARTING_DESC = "starting";
    public static final String STATE_STOPPED_DESC = "stopped";
    public static final String STATE_STOPPING_DESC = "stopping";
    public static final String STATE_WAITING_FOR_DATA_DESC = "waiting for data";
    public static final String STATE_WAITING_FOR_QUEUE_DESC = "waiting for queue";
    public static final String EVENT_COMPLETE = "complete";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_PROGRESS = "progress";
    public static final String EVENT_COMPLETE_JSON = "{ type : 'complete' }";
    private boolean paused = false;
    private boolean looping = false;
    protected KrollProxy proxy;
    protected MediaPlayer mp;
    protected float volume;
    protected boolean playOnResume;
    protected boolean remote;
    protected Timer progressTimer;

    public TiSound(KrollProxy proxy) {
        this.proxy = proxy;
        this.playOnResume = false;
        this.remote = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws IOException {
        try {
            this.mp = new MediaPlayer();
            String url = TiConvert.toString((Object)this.proxy.getProperty("url"));
            if (URLUtil.isAssetUrl((String)url)) {
                TiApplication context = this.proxy.getTiContext().getTiApp();
                String path = url.substring("file:///android_asset/".length());
                AssetFileDescriptor afd = null;
                try {
                    afd = context.getAssets().openFd(path);
                    this.mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                }
                catch (IOException e) {
                    Log.e((String)LCAT, (String)"Error setting file descriptor: ", (Throwable)e);
                }
                finally {
                    if (afd != null) {
                        afd.close();
                    }
                }
            } else {
                Uri uri = Uri.parse((String)url);
                if (uri.getScheme().equals("file")) {
                    this.mp.setDataSource(uri.getPath());
                } else {
                    this.remote = true;
                    this.mp.setDataSource(url);
                }
            }
            this.mp.setLooping(this.looping);
            this.mp.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mp.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mp.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.mp.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mp.prepare();
            this.setState(1);
            this.setVolume(this.volume);
            if (this.proxy.hasProperty("time")) {
                this.setTime(TiSound.secondsToMillis(TiConvert.toDouble((Object)this.proxy.getProperty("time"))));
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while initializing : ", (Throwable)t);
            this.release();
            this.setState(5);
        }
    }

    public boolean isLooping() {
        return this.looping;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPlaying() {
        boolean result = false;
        if (this.mp != null) {
            result = this.mp.isPlaying();
        }
        return result;
    }

    public void pause() {
        try {
            if (this.mp != null && this.mp.isPlaying()) {
                if (DBG) {
                    Log.d((String)LCAT, (String)"audio is playing, pause");
                }
                if (this.remote) {
                    this.stopProgressTimer();
                }
                this.mp.pause();
                this.paused = true;
                this.setState(2);
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while pausing : ", (Throwable)t);
        }
    }

    public void play() {
        try {
            if (this.mp == null) {
                this.setState(4);
                this.initialize();
            }
            if (this.mp != null) {
                if (!this.isPlaying()) {
                    if (DBG) {
                        Log.d((String)LCAT, (String)"audio is not playing, starting.");
                    }
                    this.setVolume(this.volume);
                    if (DBG) {
                        Log.d((String)LCAT, (String)("Play: Volume set to " + this.volume));
                    }
                    this.mp.start();
                    this.setState(3);
                    this.paused = false;
                    if (this.remote) {
                        this.startProgressTimer();
                    }
                }
                this.setState(3);
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while playing : ", (Throwable)t);
            this.reset();
        }
    }

    public void reset() {
        try {
            if (this.mp != null) {
                if (this.remote) {
                    this.stopProgressTimer();
                }
                this.setState(6);
                this.mp.seekTo(0);
                this.looping = false;
                this.paused = false;
                this.setState(5);
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while resetting : ", (Throwable)t);
        }
    }

    public void release() {
        try {
            if (this.mp != null) {
                this.mp.setOnCompletionListener(null);
                this.mp.setOnErrorListener(null);
                this.mp.setOnBufferingUpdateListener(null);
                this.mp.setOnInfoListener(null);
                this.mp.release();
                this.mp = null;
                if (DBG) {
                    Log.d((String)LCAT, (String)"Native resources released.");
                }
                this.remote = false;
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while releasing : ", (Throwable)t);
        }
    }

    public void setLooping(boolean loop) {
        try {
            if (loop != this.looping) {
                if (this.mp != null) {
                    this.mp.setLooping(loop);
                }
                this.looping = loop;
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while configuring looping : ", (Throwable)t);
        }
    }

    public void setVolume(float volume) {
        try {
            if (volume < 0.0f) {
                this.volume = 0.0f;
                Log.w((String)LCAT, (String)"Attempt to set volume less than 0.0. Volume set to 0.0");
            } else if ((double)volume > 1.0) {
                this.volume = 1.0f;
                this.proxy.setProperty("volume", (Object)Float.valueOf(volume));
                Log.w((String)LCAT, (String)"Attempt to set volume greater than 1.0. Volume set to 1.0");
            } else {
                this.volume = volume;
            }
            if (this.mp != null) {
                float scaledVolume = this.volume;
                this.mp.setVolume(scaledVolume, scaledVolume);
            }
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)"Issue while setting volume : ", (Throwable)t);
        }
    }

    public int getDuration() {
        int duration = 0;
        if (this.mp != null) {
            duration = this.mp.getDuration();
        }
        return duration;
    }

    public int getTime() {
        int time = 0;
        time = this.mp != null ? this.mp.getCurrentPosition() : TiSound.secondsToMillis(TiConvert.toDouble((Object)this.proxy.getProperty("time")));
        return time;
    }

    public void setTime(int position) {
        if (position < 0) {
            position = 0;
        }
        if (this.mp != null) {
            int duration = this.mp.getDuration();
            if (position > duration) {
                position = duration;
            }
            this.mp.seekTo(position);
        }
        this.proxy.setProperty("time", (Object)TiSound.millisToSeconds(position));
    }

    private void setState(int state) {
        this.proxy.setProperty("state", (Object)state);
        String stateDescription = "";
        switch (state) {
            case 0: {
                stateDescription = STATE_BUFFERING_DESC;
                break;
            }
            case 1: {
                stateDescription = STATE_INITIALIZED_DESC;
                break;
            }
            case 2: {
                stateDescription = STATE_PAUSED_DESC;
                break;
            }
            case 3: {
                stateDescription = STATE_PLAYING_DESC;
                break;
            }
            case 4: {
                stateDescription = STATE_STARTING_DESC;
                break;
            }
            case 5: {
                stateDescription = STATE_STOPPED_DESC;
                break;
            }
            case 6: {
                stateDescription = STATE_STOPPING_DESC;
                break;
            }
            case 7: {
                stateDescription = STATE_WAITING_FOR_DATA_DESC;
                break;
            }
            case 8: {
                stateDescription = STATE_WAITING_FOR_QUEUE_DESC;
            }
        }
        this.proxy.setProperty("stateDescription", (Object)stateDescription);
        if (DBG) {
            Log.d((String)LCAT, (String)("Audio state changed: " + stateDescription));
        }
        KrollDict data = new KrollDict();
        data.put((Object)"state", (Object)state);
        data.put((Object)"description", (Object)stateDescription);
        this.proxy.fireEvent(EVENT_CHANGE, data);
    }

    public void stop() {
        block9: {
            try {
                if (this.mp == null) break block9;
                if (this.mp.isPlaying() || this.isPaused()) {
                    if (DBG) {
                        Log.d((String)LCAT, (String)"audio is playing, stop()");
                    }
                    this.setState(6);
                    this.mp.stop();
                    this.setState(5);
                    if (this.remote) {
                        this.stopProgressTimer();
                    }
                    try {
                        this.mp.prepare();
                    }
                    catch (IOException e) {
                        Log.e((String)LCAT, (String)"Error while preparing audio after stop(). Ignoring.");
                    }
                    catch (IllegalStateException e) {
                        Log.w((String)LCAT, (String)"Error while preparing audio after stop(). Ignoring.");
                    }
                }
                if (this.isPaused()) {
                    this.paused = false;
                }
            }
            catch (Throwable t) {
                Log.e((String)LCAT, (String)"Error : ", (Throwable)t);
            }
        }
    }

    public void onCompletion(MediaPlayer mp) {
        this.proxy.fireEvent(EVENT_COMPLETE, null);
        this.stop();
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String msg = "Unknown media issue.";
        switch (what) {
            case 800: {
                msg = "Stream not interleaved or interleaved improperly.";
                break;
            }
            case 801: {
                msg = "Stream does not support seeking";
                break;
            }
            case 1: {
                msg = "Unknown media issue";
                break;
            }
            case 700: {
                msg = "Video is too complex for decoder, video lagging.";
            }
        }
        KrollDict data = new KrollDict();
        data.put((Object)"code", (Object)0);
        data.put((Object)"message", (Object)msg);
        this.proxy.fireEvent(EVENT_ERROR, data);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        int code = 0;
        String msg = "Unknown media error.";
        if (what == 100) {
            msg = "Media server died";
        }
        this.release();
        KrollDict data = new KrollDict();
        data.put((Object)"code", (Object)code);
        data.put((Object)"message", (Object)msg);
        this.proxy.fireEvent(EVENT_ERROR, data);
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Buffering: " + percent + "%"));
        }
    }

    private void startProgressTimer() {
        if (this.progressTimer == null) {
            this.progressTimer = new Timer(true);
        } else {
            this.progressTimer.cancel();
            this.progressTimer = new Timer(true);
        }
        this.progressTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (TiSound.this.mp != null && TiSound.this.mp.isPlaying()) {
                    int position = TiSound.this.mp.getCurrentPosition();
                    KrollDict event = new KrollDict();
                    event.put((Object)TiSound.EVENT_PROGRESS, (Object)TiSound.millisToSeconds(position));
                    TiSound.this.proxy.fireEvent(TiSound.EVENT_PROGRESS, event);
                }
            }
        }, 1000L, 1000L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
    }

    public void onDestroy() {
        if (this.mp != null) {
            this.mp.release();
            this.mp = null;
        }
    }

    public void onPause() {
        if (this.mp != null && this.isPlaying()) {
            this.pause();
            this.playOnResume = true;
        }
    }

    public void onResume() {
        if (this.mp != null && this.playOnResume) {
            this.play();
            this.playOnResume = false;
        }
    }

    public void listenerAdded(String type, int count, KrollProxy proxy) {
    }

    public void listenerRemoved(String type, int count, KrollProxy proxy) {
    }

    public void processProperties(KrollDict d) {
        if (d.containsKey((Object)"volume")) {
            this.setVolume(TiConvert.toFloat((KrollDict)d, (String)"volume"));
        } else {
            this.setVolume(0.5f);
        }
        if (d.containsKey((Object)"time")) {
            this.setTime(TiSound.secondsToMillis(TiConvert.toDouble((KrollDict)d, (String)"time")));
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if ("volume".equals(key)) {
            this.setVolume(TiConvert.toFloat((Object)newValue));
        } else if ("time".equals(key)) {
            this.setTime(TiSound.secondsToMillis(TiConvert.toDouble((Object)newValue)));
        }
    }

    public void propertiesChanged(List<KrollPropertyChange> changes, KrollProxy proxy) {
        for (KrollPropertyChange change : changes) {
            this.propertyChanged(change.getName(), change.getOldValue(), change.getNewValue(), proxy);
        }
    }

    public static double millisToSeconds(int millis) {
        return millis <= 0 ? 0.0 : (double)millis / 1000.0;
    }

    public static int secondsToMillis(double seconds) {
        return seconds <= 0.0 ? 0 : (int)(seconds * 1000.0);
    }
}

