/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.proxy.TiViewProxy;

public class TiCameraActivity
extends TiBaseActivity
implements SurfaceHolder.Callback {
    private static final String LCAT = "TiCameraActivity";
    private static Camera camera;
    private TiViewProxy localOverlayProxy = null;
    private Uri storageUri;
    private SurfaceView preview;
    private FrameLayout previewLayout;
    public static TiViewProxy overlayProxy;
    public static TiCameraActivity cameraActivity;
    static Camera.ShutterCallback shutterCallback;
    static Camera.PictureCallback rawCallback;
    static Camera.PictureCallback jpegCallback;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.storageUri = (Uri)this.getIntent().getParcelableExtra("output");
        this.preview = new SurfaceView((Context)this);
        SurfaceHolder previewHolder = this.preview.getHolder();
        previewHolder.addCallback((SurfaceHolder.Callback)this);
        previewHolder.setType(3);
        this.localOverlayProxy = overlayProxy;
        overlayProxy = null;
        this.previewLayout = new FrameLayout((Context)this);
        this.setRequestedOrientation(0);
        this.setContentView((View)this.previewLayout);
    }

    public void surfaceChanged(SurfaceHolder previewHolder, int format, int width, int height) {
        camera.startPreview();
    }

    public void surfaceCreated(SurfaceHolder previewHolder) {
        camera = Camera.open();
        Camera.Parameters cameraParams = camera.getParameters();
        Camera.Size previewSize = (Camera.Size)cameraParams.getSupportedPreviewSizes().get(cameraParams.getSupportedPreviewSizes().size() - 1);
        cameraParams.setPreviewSize(previewSize.width, previewSize.height);
        camera.setParameters(cameraParams);
        try {
            Log.i((String)LCAT, (String)"setting preview display");
            camera.setPreviewDisplay(previewHolder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void surfaceDestroyed(SurfaceHolder previewHolder) {
        camera.release();
        camera = null;
    }

    protected void onResume() {
        super.onResume();
        cameraActivity = this;
        this.previewLayout.addView((View)this.preview);
        this.previewLayout.addView(this.localOverlayProxy.getView((Activity)this).getNativeView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected void onPause() {
        super.onPause();
        this.previewLayout.removeView((View)this.preview);
        this.previewLayout.removeView(this.localOverlayProxy.getView((Activity)this).getNativeView());
        try {
            camera.release();
            camera = null;
        }
        catch (Throwable t) {
            Log.i((String)LCAT, (String)"camera is not open, unable to release");
        }
        cameraActivity = null;
    }

    public static void takePicture() {
        Log.i((String)LCAT, (String)"Taking picture");
        camera.takePicture(shutterCallback, rawCallback, jpegCallback);
    }

    static {
        overlayProxy = null;
        cameraActivity = null;
        shutterCallback = new Camera.ShutterCallback(){

            public void onShutter() {
            }
        };
        rawCallback = new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
            }
        };
        jpegCallback = new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(cameraActivity.storageUri.getPath());
                    outputStream.write(data);
                    outputStream.close();
                    cameraActivity.setResult(-1);
                    cameraActivity.finish();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }
}

