/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Parcelable;
import android.os.Vibrator;
import android.provider.MediaStore;
import android.view.View;
import android.view.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.ContextSpecific;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiIntentWrapper;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.media.TiCameraActivity;
import ti.modules.titanium.media.android.AndroidModule;

@ContextSpecific
public class MediaModule
extends KrollModule {
    private static final String LCAT = "TiMedia";
    private static final boolean DBG = TiConfig.LOGD;
    private static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{100L, 250L};
    private static final String PHOTO_DCIM_CAMERA = "/sdcard/dcim/Camera";
    public static final int UNKNOWN_ERROR = 0;
    public static final int DEVICE_BUSY = 1;
    public static final int NO_CAMERA = 2;
    public static final int NO_VIDEO = 3;
    public static final int VIDEO_SCALING_NONE = 0;
    public static final int VIDEO_SCALING_ASPECT_FILL = 1;
    public static final int VIDEO_SCALING_ASPECT_FIT = 2;
    public static final int VIDEO_SCALING_MODE_FILL = 3;
    public static final int VIDEO_CONTROL_DEFAULT = 0;
    public static final int VIDEO_CONTROL_EMBEDDED = 1;
    public static final int VIDEO_CONTROL_FULLSCREEN = 2;
    public static final int VIDEO_CONTROL_NONE = 3;
    public static final int VIDEO_CONTROL_HIDDEN = 4;
    public static final String MEDIA_TYPE_PHOTO = "public.image";
    public static final String MEDIA_TYPE_VIDEO = "public.video";

    public MediaModule(TiContext tiContext) {
        super(tiContext);
    }

    public void vibrate(@Kroll.argument(optional=true) long[] pattern) {
        Vibrator vibrator;
        if (pattern.length == 0) {
            pattern = DEFAULT_VIBRATE_PATTERN;
        }
        if ((vibrator = (Vibrator)this.getTiContext().getTiApp().getSystemService("vibrator")) != null) {
            vibrator.vibrate(pattern, -1);
        }
    }

    public void showCamera(KrollInvocation invocation, KrollDict options) {
        KrollCallback successCallback = null;
        KrollCallback cancelCallback = null;
        KrollCallback errorCallback = null;
        if (options.containsKey((Object)"success")) {
            successCallback = (KrollCallback)options.get((Object)"success");
        }
        if (options.containsKey((Object)"cancel")) {
            cancelCallback = (KrollCallback)options.get((Object)"cancel");
        }
        if (options.containsKey((Object)"error")) {
            errorCallback = (KrollCallback)options.get((Object)"error");
        }
        if (options.containsKey((Object)"overlay")) {
            TiCameraActivity.overlayProxy = (TiViewProxy)options.get((Object)"overlay");
        }
        if (DBG) {
            Log.d((String)LCAT, (String)"showCamera called");
        }
        Camera camera = null;
        try {
            camera = Camera.open();
            if (camera != null) {
                camera.release();
                camera = null;
            }
        }
        catch (Throwable t) {
            if (camera != null) {
                camera.release();
            }
            if (errorCallback != null) {
                errorCallback.callAsync(this.createErrorResponse(2, "Camera not available."));
            }
            return;
        }
        boolean saveToPhotoGallery = false;
        if (options.containsKey((Object)"saveToPhotoGallery")) {
            saveToPhotoGallery = options.getBoolean("saveToPhotoGallery");
        }
        Activity activity = invocation.getTiContext().getActivity();
        TiActivitySupport activitySupport = (TiActivitySupport)activity;
        TiFileHelper tfh = this.getTiContext().getTiFileHelper();
        File imageDir = null;
        File imageFile = null;
        try {
            if (saveToPhotoGallery) {
                imageDir = new File(PHOTO_DCIM_CAMERA);
                if (!imageDir.exists()) {
                    imageDir.mkdirs();
                }
            } else if (activity.getIntent() != null) {
                String name = this.getTiContext().getTiApp().getAppInfo().getName();
                imageDir = new File(PHOTO_DCIM_CAMERA, name);
                if (!imageDir.exists()) {
                    imageDir.mkdirs();
                    if (!imageDir.exists()) {
                        Log.w((String)LCAT, (String)("Attempt to create '" + imageDir.getAbsolutePath() + "' failed silently."));
                    }
                }
            } else {
                imageDir = tfh.getDataDirectory(false);
            }
            imageFile = tfh.getTempFile(imageDir, ".jpg");
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)"Unable to create temp file", (Throwable)e);
            if (errorCallback != null) {
                errorCallback.callAsync(this.createErrorResponse(0, e.getMessage()));
            }
            return;
        }
        String imageUrl = "file://" + imageFile.getAbsolutePath();
        TiIntentWrapper cameraIntent = new TiIntentWrapper(new Intent());
        if (TiCameraActivity.overlayProxy == null) {
            cameraIntent.getIntent().setAction("android.media.action.IMAGE_CAPTURE");
            cameraIntent.getIntent().addCategory("android.intent.category.DEFAULT");
        } else {
            cameraIntent.getIntent().setClass(invocation.getTiContext().getAndroidContext().getBaseContext(), TiCameraActivity.class);
        }
        cameraIntent.setWindowId(TiIntentWrapper.createActivityName((String)"CAMERA"));
        PackageManager pm = activity.getPackageManager();
        List activities = pm.queryIntentActivities(cameraIntent.getIntent(), 65536);
        boolean isHTCCameraApp = false;
        for (ResolveInfo rs : activities) {
            try {
                if (!rs.activityInfo.applicationInfo.sourceDir.contains("HTC")) continue;
                isHTCCameraApp = true;
                break;
            }
            catch (NullPointerException e) {
            }
        }
        if (!isHTCCameraApp) {
            cameraIntent.getIntent().putExtra("output", (Parcelable)Uri.parse((String)imageUrl));
        }
        CameraResultHandler resultHandler = new CameraResultHandler();
        resultHandler.imageFile = imageFile;
        resultHandler.imageUrl = imageUrl;
        resultHandler.saveToPhotoGallery = saveToPhotoGallery;
        resultHandler.successCallback = successCallback;
        resultHandler.cancelCallback = cancelCallback;
        resultHandler.errorCallback = errorCallback;
        resultHandler.activitySupport = activitySupport;
        resultHandler.cameraIntent = cameraIntent.getIntent();
        activity.runOnUiThread((Runnable)resultHandler);
    }

    public void openPhotoGallery(KrollInvocation invocation, KrollDict options) {
        KrollCallback successCallback = null;
        KrollCallback cancelCallback = null;
        KrollCallback errorCallback = null;
        if (options.containsKey((Object)"success")) {
            successCallback = (KrollCallback)options.get((Object)"success");
        }
        if (options.containsKey((Object)"cancel")) {
            cancelCallback = (KrollCallback)options.get((Object)"cancel");
        }
        if (options.containsKey((Object)"error")) {
            errorCallback = (KrollCallback)options.get((Object)"error");
        }
        final KrollCallback fSuccessCallback = successCallback;
        final KrollCallback fCancelCallback = cancelCallback;
        final KrollCallback fErrorCallback = errorCallback;
        if (DBG) {
            Log.d((String)LCAT, (String)"openPhotoGallery called");
        }
        Activity activity = invocation.getTiContext().getActivity();
        TiActivitySupport activitySupport = (TiActivitySupport)activity;
        TiIntentWrapper galleryIntent = new TiIntentWrapper(new Intent());
        galleryIntent.getIntent().setAction("android.intent.action.PICK");
        galleryIntent.getIntent().setType("image/*");
        galleryIntent.getIntent().addCategory("android.intent.category.DEFAULT");
        galleryIntent.setWindowId(TiIntentWrapper.createActivityName((String)"GALLERY"));
        int code = activitySupport.getUniqueResultCode();
        activitySupport.launchActivityForResult(galleryIntent.getIntent(), code, new TiActivityResultHandler(){

            public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
                block6: {
                    Log.e((String)MediaModule.LCAT, (String)("OnResult called: " + resultCode));
                    if (resultCode == 0) {
                        if (fCancelCallback != null) {
                            fCancelCallback.callAsync();
                        }
                    } else {
                        String path = data.getDataString();
                        try {
                            if (fSuccessCallback != null) {
                                fSuccessCallback.callAsync(MediaModule.this.createDictForImage(path, "image/jpeg"));
                            }
                        }
                        catch (OutOfMemoryError e) {
                            String msg = "Not enough memory to get image: " + e.getMessage();
                            Log.e((String)MediaModule.LCAT, (String)msg);
                            if (fErrorCallback == null) break block6;
                            fErrorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
                        }
                    }
                }
            }

            public void onError(Activity activity, int requestCode, Exception e) {
                String msg = "Gallery problem: " + e.getMessage();
                Log.e((String)MediaModule.LCAT, (String)msg, (Throwable)e);
                if (fErrorCallback != null) {
                    fErrorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
                }
            }
        });
    }

    public void saveToPhotoGallery(Object object) {
        Log.w((String)LCAT, (String)"saveToPhotoGallery not yet implemented in Android");
    }

    KrollDict createDictForImage(String path, String mimeType) {
        KrollDict d = new KrollDict();
        int width = -1;
        int height = -1;
        try {
            String fpath = path;
            if (!fpath.startsWith("file://") && !fpath.startsWith("content://")) {
                fpath = "file://" + path;
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)this.getTiContext().getActivity().getContentResolver().openInputStream(Uri.parse((String)fpath)), null, (BitmapFactory.Options)opts);
            width = opts.outWidth;
            height = opts.outHeight;
        }
        catch (FileNotFoundException e) {
            Log.w((String)LCAT, (String)("bitmap not found: " + path));
        }
        d.put((Object)"x", (Object)0);
        d.put((Object)"y", (Object)0);
        d.put((Object)"width", (Object)width);
        d.put((Object)"height", (Object)height);
        KrollDict cropRect = new KrollDict();
        cropRect.put((Object)"x", (Object)0);
        cropRect.put((Object)"y", (Object)0);
        cropRect.put((Object)"width", (Object)width);
        cropRect.put((Object)"height", (Object)height);
        d.put((Object)"cropRect", (Object)cropRect);
        String[] parts = new String[]{path};
        d.put((Object)"mediaType", (Object)MEDIA_TYPE_PHOTO);
        d.put((Object)"media", (Object)TiBlob.blobFromFile((TiContext)this.getTiContext(), (TiBaseFile)TiFileFactory.createTitaniumFile((TiContext)this.getTiContext(), (String[])parts, (boolean)false), (String)mimeType));
        return d;
    }

    KrollDict createDictForImage(int width, int height, byte[] data) {
        KrollDict d = new KrollDict();
        d.put((Object)"x", (Object)0);
        d.put((Object)"y", (Object)0);
        d.put((Object)"width", (Object)width);
        d.put((Object)"height", (Object)height);
        KrollDict cropRect = new KrollDict();
        cropRect.put((Object)"x", (Object)0);
        cropRect.put((Object)"y", (Object)0);
        cropRect.put((Object)"width", (Object)width);
        cropRect.put((Object)"height", (Object)height);
        d.put((Object)"cropRect", (Object)cropRect);
        d.put((Object)"mediaType", (Object)MEDIA_TYPE_PHOTO);
        d.put((Object)"media", (Object)TiBlob.blobFromData((TiContext)this.getTiContext(), (byte[])data, (String)"image/png"));
        return d;
    }

    public void previewImage(KrollInvocation invocation, KrollDict options) {
        if (DBG) {
            Log.d((String)LCAT, (String)"previewImage");
        }
        KrollCallback successCallback = null;
        KrollCallback errorCallback = null;
        TiBlob image = null;
        if (options.containsKey((Object)"success")) {
            successCallback = (KrollCallback)options.get((Object)"success");
        }
        if (options.containsKey((Object)"error")) {
            errorCallback = (KrollCallback)options.get((Object)"error");
        }
        if (options.containsKey((Object)"image")) {
            image = (TiBlob)options.get((Object)"image");
        }
        if (image == null && errorCallback != null) {
            errorCallback.callAsync(this.createErrorResponse(0, "Missing image property"));
        }
        TiBaseFile f = (TiBaseFile)image.getData();
        final KrollCallback fSuccessCallback = successCallback;
        final KrollCallback fErrorCallback = errorCallback;
        if (DBG) {
            Log.d((String)LCAT, (String)"openPhotoGallery called");
        }
        Activity activity = invocation.getTiContext().getActivity();
        TiActivitySupport activitySupport = (TiActivitySupport)activity;
        TiIntentWrapper previewIntent = new TiIntentWrapper(new Intent());
        previewIntent.getIntent().setAction("android.intent.action.VIEW");
        previewIntent.getIntent().setType(image.getMimeType());
        previewIntent.getIntent().setData(Uri.parse((String)f.nativePath()));
        previewIntent.setWindowId(TiIntentWrapper.createActivityName((String)"PREVIEW"));
        int code = activitySupport.getUniqueResultCode();
        activitySupport.launchActivityForResult(previewIntent.getIntent(), code, new TiActivityResultHandler(){

            public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
                Log.e((String)MediaModule.LCAT, (String)("OnResult called: " + resultCode));
                if (fSuccessCallback != null) {
                    fSuccessCallback.callAsync();
                }
            }

            public void onError(Activity activity, int requestCode, Exception e) {
                String msg = "Gallery problem: " + e.getMessage();
                Log.e((String)MediaModule.LCAT, (String)msg, (Throwable)e);
                if (fErrorCallback != null) {
                    fErrorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
                }
            }
        });
    }

    public void takeScreenshot(KrollCallback callback) {
        Activity a = this.getTiContext().getActivity();
        while (a.getParent() != null) {
            a = a.getParent();
        }
        Window w = a.getWindow();
        while (w.getContainer() != null) {
            w = w.getContainer();
        }
        KrollDict image = TiUIHelper.viewToImage((TiContext)this.getTiContext(), null, (View)w.getDecorView());
        if (callback != null && image != null) {
            callback.callAsync(new Object[]{image});
        }
    }

    public void takePicture() {
        if (TiCameraActivity.cameraActivity != null) {
            TiCameraActivity.takePicture();
        } else {
            Log.e((String)LCAT, (String)"camera preview is not open, unable to take photo");
        }
    }

    protected class CameraResultHandler
    implements TiActivityResultHandler,
    Runnable {
        protected File imageFile;
        protected String imageUrl;
        protected boolean saveToPhotoGallery;
        protected int code;
        protected KrollCallback successCallback;
        protected KrollCallback cancelCallback;
        protected KrollCallback errorCallback;
        protected TiActivitySupport activitySupport;
        protected Intent cameraIntent;

        protected CameraResultHandler() {
        }

        @Override
        public void run() {
            this.code = this.activitySupport.getUniqueResultCode();
            this.activitySupport.launchActivityForResult(this.cameraIntent, this.code, (TiActivityResultHandler)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
            block31: {
                if (resultCode == 0) {
                    if (this.imageFile != null) {
                        this.imageFile.delete();
                    }
                    if (this.cancelCallback != null) {
                        this.cancelCallback.callAsync();
                    }
                } else {
                    if (data == null) {
                        ContentValues values = new ContentValues(7);
                        values.put("title", this.imageFile.getName());
                        values.put("_display_name", this.imageFile.getName());
                        values.put("datetaken", Long.valueOf(new Date().getTime()));
                        values.put("mime_type", "image/jpeg");
                        if (this.saveToPhotoGallery) {
                            values.put("bucket_id", Integer.valueOf(MediaModule.PHOTO_DCIM_CAMERA.toLowerCase().hashCode()));
                            values.put("bucket_display_name", "Camera");
                        } else {
                            values.put("bucket_id", Integer.valueOf(this.imageFile.getPath().toLowerCase().hashCode()));
                            values.put("bucket_display_name", this.imageFile.getName());
                        }
                        values.put("_data", this.imageFile.getAbsolutePath());
                        Uri imageUri = activity.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        AndroidModule.MediaScannerClient mediaScanner = new AndroidModule.MediaScannerClient(MediaModule.this.getTiContext(), new String[]{this.imageUrl}, null);
                        mediaScanner.scan();
                        try {
                            if (this.successCallback != null) {
                                this.successCallback.callAsync(MediaModule.this.createDictForImage(imageUri.toString(), "image/jpeg"));
                            }
                            break block31;
                        }
                        catch (OutOfMemoryError e) {
                            String msg = "Not enough memory to get image: " + e.getMessage();
                            Log.e((String)MediaModule.LCAT, (String)msg);
                            if (this.errorCallback != null) {
                                this.errorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
                            }
                            break block31;
                        }
                    }
                    String[] projection = new String[]{"title", "_display_name", "mime_type", "bucket_id", "bucket_display_name", "_data"};
                    String title = null;
                    String displayName = null;
                    String mimeType = null;
                    String bucketId = null;
                    String bucketDisplayName = null;
                    String dataPath = null;
                    Cursor c = activity.getContentResolver().query(data.getData(), projection, null, null, null);
                    if (c != null) {
                        try {
                            if (c.moveToNext()) {
                                title = c.getString(0);
                                displayName = c.getString(1);
                                mimeType = c.getString(2);
                                bucketId = c.getString(3);
                                bucketDisplayName = c.getString(4);
                                dataPath = c.getString(5);
                                if (DBG) {
                                    Log.d((String)MediaModule.LCAT, (String)("Image { title: " + title + " displayName: " + displayName + " mimeType: " + mimeType + " bucketId: " + bucketId + " bucketDisplayName: " + bucketDisplayName + " path: " + dataPath + " }"));
                                }
                            }
                        }
                        finally {
                            if (c != null) {
                                c.close();
                                c = null;
                            }
                        }
                    }
                    String localImageUrl = dataPath;
                    if (!this.saveToPhotoGallery) {
                        try {
                            URL url = new URL(this.imageUrl);
                            File src = new File(dataPath);
                            File dst = new File(url.getPath());
                            BufferedInputStream bis = null;
                            FilterOutputStream bos = null;
                            try {
                                bis = new BufferedInputStream(new FileInputStream(src), 8096);
                                bos = new BufferedOutputStream(new FileOutputStream(dst), 8096);
                                byte[] buf = new byte[8096];
                                int len = 0;
                                while ((len = bis.read(buf)) != -1) {
                                    ((BufferedOutputStream)bos).write(buf, 0, len);
                                }
                            }
                            finally {
                                if (bis != null) {
                                    bis.close();
                                }
                                if (bos != null) {
                                    bos.close();
                                }
                            }
                            ContentValues values = new ContentValues();
                            values.put("bucket_id", Integer.valueOf(this.imageFile.getPath().toLowerCase().hashCode()));
                            values.put("bucket_display_name", this.imageFile.getName());
                            values.put("_data", this.imageFile.getAbsolutePath());
                            activity.getContentResolver().update(data.getData(), values, null, null);
                            src.delete();
                            localImageUrl = this.imageUrl;
                        }
                        catch (MalformedURLException e) {
                            Log.e((String)MediaModule.LCAT, (String)("Invalid URL not moving image: " + e.getMessage()));
                        }
                        catch (IOException e) {
                            Log.e((String)MediaModule.LCAT, (String)("Unable to move file: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    try {
                        if (this.successCallback != null) {
                            this.successCallback.callAsync(MediaModule.this.createDictForImage(localImageUrl, "image/jpeg"));
                        }
                    }
                    catch (OutOfMemoryError e) {
                        String msg = "Not enough memory to get image: " + e.getMessage();
                        Log.e((String)MediaModule.LCAT, (String)msg);
                        if (this.errorCallback == null) break block31;
                        this.errorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
                    }
                }
            }
        }

        public void onError(Activity activity, int requestCode, Exception e) {
            if (this.imageFile != null) {
                this.imageFile.delete();
            }
            String msg = "Camera problem: " + e.getMessage();
            Log.e((String)MediaModule.LCAT, (String)msg, (Throwable)e);
            if (this.errorCallback != null) {
                this.errorCallback.callAsync(MediaModule.this.createErrorResponse(0, msg));
            }
        }
    }
}

