/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.media;

import android.app.Activity;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.filesystem.FileProxy;
import ti.modules.titanium.media.TiSound;

public class AudioPlayerProxy
extends KrollProxy
implements TiContext.OnLifecycleEvent {
    private static final String LCAT = "AudioPlayerProxy";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int STATE_BUFFERING = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_PAUSED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_STARTING = 4;
    public static final int STATE_STOPPED = 5;
    public static final int STATE_STOPPING = 6;
    public static final int STATE_WAITING_FOR_DATA = 7;
    public static final int STATE_WAITING_FOR_QUEUE = 8;
    protected TiSound snd;

    public AudioPlayerProxy(TiContext tiContext) {
        super(tiContext);
        tiContext.addOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
        this.setProperty("volume", 0.5, true);
    }

    public void handleCreationDict(KrollDict options) {
        FileProxy fp;
        super.handleCreationDict(options);
        if (options.containsKey((Object)"url")) {
            this.setProperty("url", this.getTiContext().resolveUrl(null, TiConvert.toString((KrollDict)options, (String)"url")));
        } else if (options.containsKey((Object)"sound") && (fp = (FileProxy)options.get((Object)"sound")) != null) {
            String url = fp.getNativePath();
            this.setProperty("url", url);
        }
        if (options.containsKey((Object)"allowBackground")) {
            this.setProperty("allowBackground", options.get((Object)"allowBackground"));
        }
        if (DBG) {
            Log.i((String)LCAT, (String)("Creating audio player proxy for url: " + TiConvert.toString((Object)this.getProperty("url"))));
        }
    }

    public String getUrl() {
        return TiConvert.toString((Object)this.getProperty("url"));
    }

    public void setUrl(KrollInvocation kroll, String url) {
        if (url != null) {
            this.setProperty("url", kroll.getTiContext().resolveUrl(null, TiConvert.toString((Object)url)));
        }
    }

    public boolean isPlaying() {
        TiSound s = this.getSound();
        if (s != null) {
            return s.isPlaying();
        }
        return false;
    }

    public boolean isPaused() {
        TiSound s = this.getSound();
        if (s != null) {
            return s.isPaused();
        }
        return false;
    }

    public void start() {
        this.play();
    }

    public void play() {
        TiSound s = this.getSound();
        if (s != null) {
            s.play();
        }
    }

    public void pause() {
        TiSound s = this.getSound();
        if (s != null) {
            s.pause();
        }
    }

    public void release() {
        TiSound s = this.getSound();
        if (s != null) {
            s.release();
            this.snd = null;
        }
    }

    public void destroy() {
        this.release();
    }

    public void stop() {
        TiSound s = this.getSound();
        if (s != null) {
            s.stop();
        }
    }

    protected TiSound getSound() {
        if (this.snd == null) {
            this.snd = new TiSound(this);
            this.setModelListener(this.snd);
        }
        return this.snd;
    }

    private boolean allowBackground() {
        boolean allow = false;
        if (this.hasProperty("allowBackground")) {
            allow = TiConvert.toBoolean((Object)this.getProperty("allowBackground"));
        }
        return allow;
    }

    public void onStart(Activity activity) {
    }

    public void onResume(Activity activity) {
        if (!this.allowBackground() && this.snd != null) {
            this.snd.onResume();
        }
    }

    public void onPause(Activity activity) {
        if (!this.allowBackground() && this.snd != null) {
            this.snd.onPause();
        }
    }

    public void onStop(Activity activity) {
    }

    public void onDestroy(Activity activity) {
        if (this.snd != null) {
            this.snd.onDestroy();
        }
        this.snd = null;
    }
}

