/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.URLUtil;
import android.widget.MediaController;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.http.client.ClientProtocolException;

public class TiVideoView4
extends SurfaceView
implements MediaController.MediaPlayerControl {
    private String TAG = "VideoView";
    private Uri mUri;
    private int mDuration;
    private SurfaceHolder mSurfaceHolder = null;
    private MediaPlayer mMediaPlayer = null;
    private boolean mIsPrepared;
    private boolean mIsPlaybackCompleted;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private MediaController mMediaController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private boolean mStartWhenPrepared;
    private int mSeekWhenPrepared;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            TiVideoView4.this.mVideoWidth = mp.getVideoWidth();
            TiVideoView4.this.mVideoHeight = mp.getVideoHeight();
            if (TiVideoView4.this.mVideoWidth != 0 && TiVideoView4.this.mVideoHeight != 0) {
                TiVideoView4.this.getHolder().setFixedSize(TiVideoView4.this.mVideoWidth, TiVideoView4.this.mVideoHeight);
            }
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            TiVideoView4.this.mIsPrepared = true;
            if (TiVideoView4.this.mOnPreparedListener != null) {
                TiVideoView4.this.mOnPreparedListener.onPrepared(TiVideoView4.this.mMediaPlayer);
            }
            if (TiVideoView4.this.mMediaController != null) {
                TiVideoView4.this.mMediaController.setEnabled(true);
            }
            TiVideoView4.this.mVideoWidth = mp.getVideoWidth();
            TiVideoView4.this.mVideoHeight = mp.getVideoHeight();
            if (TiVideoView4.this.mVideoWidth != 0 && TiVideoView4.this.mVideoHeight != 0) {
                TiVideoView4.this.getHolder().setFixedSize(TiVideoView4.this.mVideoWidth, TiVideoView4.this.mVideoHeight);
                if (TiVideoView4.this.mSurfaceWidth == TiVideoView4.this.mVideoWidth && TiVideoView4.this.mSurfaceHeight == TiVideoView4.this.mVideoHeight) {
                    if (TiVideoView4.this.mSeekWhenPrepared != 0) {
                        TiVideoView4.this.mMediaPlayer.seekTo(TiVideoView4.this.mSeekWhenPrepared);
                        TiVideoView4.this.mSeekWhenPrepared = 0;
                    }
                    if (TiVideoView4.this.mStartWhenPrepared) {
                        TiVideoView4.this.start();
                        TiVideoView4.this.mStartWhenPrepared = false;
                        if (TiVideoView4.this.mMediaController != null) {
                            TiVideoView4.this.mMediaController.show();
                        }
                    } else if (!(TiVideoView4.this.isPlaying() || TiVideoView4.this.mSeekWhenPrepared == 0 && TiVideoView4.this.getCurrentPosition() <= 0 || TiVideoView4.this.mMediaController == null)) {
                        TiVideoView4.this.mMediaController.show(0);
                    }
                }
            } else {
                if (TiVideoView4.this.mSeekWhenPrepared != 0) {
                    TiVideoView4.this.mMediaPlayer.seekTo(TiVideoView4.this.mSeekWhenPrepared);
                    TiVideoView4.this.mSeekWhenPrepared = 0;
                }
                if (TiVideoView4.this.mStartWhenPrepared) {
                    TiVideoView4.this.start();
                    TiVideoView4.this.mStartWhenPrepared = false;
                }
            }
        }
    };
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            TiVideoView4.this.mIsPlaybackCompleted = true;
            if (TiVideoView4.this.mMediaController != null) {
                TiVideoView4.this.mMediaController.hide();
            }
            if (TiVideoView4.this.mOnCompletionListener != null) {
                TiVideoView4.this.mOnCompletionListener.onCompletion(TiVideoView4.this.mMediaPlayer);
            }
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)TiVideoView4.this.TAG, (String)("Error: " + framework_err + "," + impl_err));
            if (TiVideoView4.this.mMediaController != null) {
                TiVideoView4.this.mMediaController.hide();
            }
            if (TiVideoView4.this.mOnErrorListener != null && TiVideoView4.this.mOnErrorListener.onError(TiVideoView4.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            if (TiVideoView4.this.getWindowToken() != null) {
                Resources r = TiVideoView4.this.getContext().getResources();
                String message = framework_err == 200 ? "Invalid Progressive Playback" : "Unknown error";
                new AlertDialog.Builder(TiVideoView4.this.getContext()).setTitle((CharSequence)"Video View").setMessage((CharSequence)message).setPositiveButton((CharSequence)"Error", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (TiVideoView4.this.mOnCompletionListener != null) {
                            TiVideoView4.this.mOnCompletionListener.onCompletion(TiVideoView4.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            TiVideoView4.this.mCurrentBufferPercentage = percent;
        }
    };
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            TiVideoView4.this.mSurfaceWidth = w;
            TiVideoView4.this.mSurfaceHeight = h;
            if (TiVideoView4.this.mMediaPlayer != null && TiVideoView4.this.mIsPrepared && TiVideoView4.this.mVideoWidth == w && TiVideoView4.this.mVideoHeight == h) {
                if (TiVideoView4.this.mSeekWhenPrepared != 0) {
                    TiVideoView4.this.mMediaPlayer.seekTo(TiVideoView4.this.mSeekWhenPrepared);
                    TiVideoView4.this.mSeekWhenPrepared = 0;
                }
                if (!TiVideoView4.this.mIsPlaybackCompleted) {
                    TiVideoView4.this.start();
                }
                if (TiVideoView4.this.mMediaController != null) {
                    TiVideoView4.this.mMediaController.show();
                }
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            TiVideoView4.this.mSurfaceHolder = holder;
            TiVideoView4.this.openVideo();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            TiVideoView4.this.mSurfaceHolder = null;
            if (TiVideoView4.this.mMediaController != null) {
                TiVideoView4.this.mMediaController.hide();
            }
            if (TiVideoView4.this.mMediaPlayer != null) {
                TiVideoView4.this.mMediaPlayer.reset();
                TiVideoView4.this.mMediaPlayer.release();
                TiVideoView4.this.mMediaPlayer = null;
            }
        }
    };

    public TiVideoView4(Context context) {
        super(context);
        this.initVideoView();
    }

    public TiVideoView4(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.initVideoView();
    }

    public TiVideoView4(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initVideoView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureVideo(this.mVideoWidth, this.mVideoHeight, widthMeasureSpec, heightMeasureSpec);
        if (this.mSurfaceHolder != null && this.mMediaPlayer != null && this.mMediaPlayer.getCurrentPosition() > 0) {
            this.mSurfaceHolder.setFixedSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    protected void measureVideo(int videoWidth, int videoHeight, int widthMeasureSpec, int heightMeasureSpec) {
        int width = TiVideoView4.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = TiVideoView4.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (videoWidth > 0 && videoHeight > 0) {
            if (videoWidth * height > width * videoHeight) {
                height = width * videoHeight / videoWidth;
            } else if (videoWidth * height < width * videoHeight) {
                width = height * videoWidth / videoHeight;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public int resolveAdjustedSize(int desiredSize, int measureSpec) {
        int result = desiredSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = desiredSize;
                break;
            }
            case -2147483648: {
                result = Math.min(desiredSize, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.mUri = uri;
        this.mStartWhenPrepared = false;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    private void setDataSource() {
        try {
            if (this.mUri.getScheme().equals("http") || this.mUri.getScheme().equals("https")) {
                while (this.mUri.getScheme() == null || !this.mUri.getScheme().equals("rtsp")) {
                    URL url = new URL(this.mUri.toString());
                    HttpURLConnection cn = (HttpURLConnection)url.openConnection();
                    cn.setInstanceFollowRedirects(false);
                    String location = cn.getHeaderField("Location");
                    if (location == null) break;
                    String host = this.mUri.getHost();
                    int port = this.mUri.getPort();
                    String scheme = this.mUri.getScheme();
                    this.mUri = Uri.parse((String)location);
                    if (this.mUri.getScheme() != null) continue;
                    if (scheme == null) {
                        scheme = "http";
                    }
                    String authority = port == -1 ? host : host + ":" + port;
                    this.mUri = this.mUri.buildUpon().scheme(scheme).encodedAuthority(authority).build();
                }
            }
            this.mMediaPlayer.setDataSource(this.getContext(), this.mUri);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        Intent i = new Intent("com.android.music.musicservicecommand");
        i.putExtra("command", "pause");
        this.getContext().sendBroadcast(i);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        try {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mIsPrepared = false;
            Log.v((String)this.TAG, (String)"reset duration to -1 in openVideo");
            this.mDuration = -1;
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            if (URLUtil.isAssetUrl((String)this.mUri.toString())) {
                AssetFileDescriptor afd = null;
                try {
                    String path = this.mUri.toString().substring("file:///android_asset/".length());
                    afd = this.getContext().getAssets().openFd(path);
                    this.mMediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                }
                finally {
                    if (afd != null) {
                        afd.close();
                    }
                }
            } else {
                this.setDataSource();
            }
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            return;
        }
    }

    public void setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer((MediaController.MediaPlayerControl)this);
            TiVideoView4 anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.mIsPrepared);
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mIsPrepared && this.mMediaPlayer != null && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.mIsPrepared && this.mMediaPlayer != null && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mIsPrepared && keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 5 && keyCode != 6 && this.mMediaPlayer != null && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 && this.mMediaPlayer.isPlaying()) {
                this.pause();
                this.mMediaController.show();
            } else {
                this.toggleMediaControlsVisiblity();
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        this.mIsPlaybackCompleted = false;
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            this.mMediaPlayer.start();
            this.mStartWhenPrepared = false;
        } else {
            this.mStartWhenPrepared = true;
        }
    }

    public void pause() {
        if (this.mMediaPlayer != null && this.mIsPrepared && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
        }
        this.mStartWhenPrepared = false;
    }

    public int getDuration() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mMediaPlayer.getDuration();
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    public int getCurrentPosition() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            this.mMediaPlayer.seekTo(msec);
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }
}

