/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.map;

import android.app.Activity;
import android.app.LocalActivityManager;
import android.content.Context;
import android.content.Intent;
import android.view.Window;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.map.AnnotationProxy;
import ti.modules.titanium.map.TiMapActivity;
import ti.modules.titanium.map.TiMapView;

public class ViewProxy
extends TiViewProxy
implements TiContext.OnLifecycleEvent {
    private static LocalActivityManager lam;
    private static Window mapWindow;
    private static final String LCAT = "TiMapViewProxy";
    private boolean destroyed = false;
    private TiMapView mapView;
    private ArrayList<AnnotationProxy> annotations;
    private ArrayList<TiMapView.SelectedAnnotation> selectedAnnotations;
    private KrollDict location;

    public ViewProxy(TiContext tiContext) {
        super(tiContext);
        this.eventManager.addOnEventChangeListener((OnEventListenerChange)this);
        tiContext.addOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
        this.annotations = new ArrayList();
        this.selectedAnnotations = new ArrayList();
    }

    public TiUIView createView(Activity activity) {
        this.destroyed = false;
        if (lam == null) {
            lam = new LocalActivityManager((Activity)this.getTiContext().getRootActivity(), true);
            lam.dispatchCreate(null);
        }
        if (mapWindow != null) {
            throw new IllegalStateException("MapView already created. Android can support one MapView per Application.");
        }
        TiApplication tiApp = this.getTiContext().getTiApp();
        Intent intent = new Intent((Context)tiApp, TiMapActivity.class);
        mapWindow = lam.startActivity("TIMAP", intent);
        lam.dispatchResume();
        this.mapView = new TiMapView(this, mapWindow, this.annotations, this.selectedAnnotations);
        if (this.location != null) {
            this.mapView.doSetLocation(this.location);
        }
        this.mapView.updateAnnotations();
        return this.mapView;
    }

    public void zoom(int delta) {
        if (this.mapView != null) {
            this.mapView.changeZoomLevel(delta);
        }
    }

    public void removeAllAnnotations() {
        this.annotations.clear();
        if (this.mapView != null) {
            this.mapView.updateAnnotations();
        }
    }

    public void addAnnotation(AnnotationProxy annotation) {
        this.annotations.add(annotation);
        if (this.mapView != null) {
            this.mapView.updateAnnotations();
        }
    }

    protected int findAnnotation(String title) {
        int existsIndex = -1;
        int len = this.annotations.size();
        for (int i = 0; i < len; ++i) {
            AnnotationProxy a = this.annotations.get(i);
            String t = (String)a.getProperty("title");
            if (t == null || !title.equals(t)) continue;
            existsIndex = i;
            break;
        }
        return existsIndex;
    }

    public void removeAnnotation(Object arg) {
        String title = null;
        if (arg != null && (title = arg instanceof AnnotationProxy ? TiConvert.toString((Object)((AnnotationProxy)((Object)arg)).getProperty("title")) : TiConvert.toString((Object)arg)) != null) {
            int existsIndex = this.findAnnotation(title);
            if (existsIndex > -1) {
                this.annotations.remove(existsIndex);
            }
            if (this.mapView != null) {
                this.mapView.updateAnnotations();
            }
        }
    }

    public void selectAnnotation(Object[] args) {
        String title = null;
        boolean animate = false;
        boolean center = true;
        if (args != null && args.length > 0) {
            if (args[0] instanceof KrollDict) {
                KrollDict params = (KrollDict)args[0];
                Object selectedAnnotation = params.get((Object)"annotation");
                title = selectedAnnotation instanceof AnnotationProxy ? TiConvert.toString((Object)((AnnotationProxy)((Object)selectedAnnotation)).getProperty("title")) : params.getString("title");
                if (params.containsKeyAndNotNull("animate")) {
                    animate = params.getBoolean("animate");
                }
                if (params.containsKeyAndNotNull("center")) {
                    center = params.getBoolean("center");
                }
            } else {
                if (args[0] instanceof AnnotationProxy) {
                    title = TiConvert.toString((Object)((AnnotationProxy)((Object)args[0])).getProperty("title"));
                } else if (args[0] instanceof String) {
                    title = TiConvert.toString((Object)args[0]);
                }
                if (args.length > 1) {
                    animate = TiConvert.toBoolean((Object)args[1]);
                }
            }
        }
        if (title != null) {
            if (this.mapView == null) {
                Log.e((String)LCAT, (String)"calling selectedAnnotations.add");
                this.selectedAnnotations.add(new TiMapView.SelectedAnnotation(title, animate, center));
            } else {
                Log.e((String)LCAT, (String)"calling selectedAnnotations.add2");
                this.mapView.selectAnnotation(true, title, animate, center);
            }
        }
    }

    public void deselectAnnotation(Object[] args) {
        String title = null;
        if (args.length > 0) {
            if (args[0] instanceof AnnotationProxy) {
                title = TiConvert.toString((Object)((AnnotationProxy)((Object)args[0])).getProperty("title"));
            } else if (args[0] instanceof String) {
                title = TiConvert.toString((Object)args[0]);
            }
        }
        if (title != null) {
            boolean animate = false;
            if (args.length > 1) {
                animate = TiConvert.toBoolean((Object)args[1]);
            }
            if (this.mapView == null) {
                int numSelectedAnnotations = this.selectedAnnotations.size();
                for (int i = 0; i < numSelectedAnnotations; ++i) {
                    if (!this.selectedAnnotations.get((int)i).title.equals(title)) continue;
                    this.selectedAnnotations.remove(i);
                }
            } else {
                this.mapView.selectAnnotation(false, title, animate, false);
            }
        }
    }

    public void setLocation(KrollDict location) {
        if (this.mapView == null) {
            this.location = location;
        } else {
            this.mapView.doSetLocation(location);
        }
    }

    public void setMapType(int mapType) {
        this.setProperty("mapType", mapType, true);
    }

    public void onDestroy(Activity activity) {
        if (lam != null && !this.destroyed) {
            this.destroyed = true;
            lam.dispatchDestroy(true);
            lam.destroyActivity("TIMAP", true);
        }
        mapWindow = null;
    }

    public void onPause(Activity activity) {
        if (lam != null) {
            lam.dispatchPause(false);
        }
    }

    public void onResume(Activity activity) {
        if (lam != null) {
            lam.dispatchResume();
        }
    }

    public void onStart(Activity activity) {
    }

    public void onStop(Activity activity) {
        if (lam != null) {
            lam.dispatchStop();
        }
    }

    public void releaseViews() {
        super.releaseViews();
        this.onDestroy(null);
    }
}

