/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.map;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.map.TiOverlayItem;

public class TiOverlayItemView
extends FrameLayout {
    private static final String LCAT = "TitaniumOverlayItemView";
    private RelativeLayout layout;
    private ImageView leftImage;
    private ImageView rightImage;
    private TextView title;
    private TextView snippet;
    private int lastIndex;
    private View[] hitTestList;
    private WeakReference<TiContext> weakTiContext;
    private OnOverlayClicked overlayClickedListener;

    public TiOverlayItemView(Context context, TiContext tiContext) {
        super(context);
        this.weakTiContext = new WeakReference<TiContext>(tiContext);
        this.lastIndex = -1;
        this.setPadding(0, 0, 0, 10);
        this.layout = new RelativeLayout(context);
        this.layout.setBackgroundColor(Color.argb((int)200, (int)0, (int)0, (int)0));
        this.layout.setGravity(0);
        this.layout.setPadding(4, 2, 4, 2);
        RelativeLayout.LayoutParams params = null;
        this.leftImage = new ImageView(context);
        this.leftImage.setId(100);
        this.leftImage.setTag((Object)"leftButton");
        params = this.createBaseParams();
        params.addRule(9);
        if (Integer.parseInt(Build.VERSION.SDK) > 3) {
            params.addRule(15);
        }
        params.setMargins(0, 0, 5, 0);
        this.layout.addView((View)this.leftImage, (ViewGroup.LayoutParams)params);
        RelativeLayout textLayout = new RelativeLayout(this.getContext());
        textLayout.setGravity(0);
        textLayout.setId(101);
        this.title = new TextView(context){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (this.getMeasuredWidth() > 230) {
                    this.setMeasuredDimension(200, this.getMeasuredHeight());
                }
            }
        };
        this.title.setId(200);
        this.title.setTextColor(Color.argb((int)255, (int)216, (int)216, (int)216));
        this.title.setTag((Object)"title");
        TiUIHelper.styleText((TextView)this.title, (String)"sans-serif", (String)"15sip", (String)"bold");
        params = this.createBaseParams();
        params.addRule(6);
        textLayout.addView((View)this.title, (ViewGroup.LayoutParams)params);
        this.snippet = new TextView(context);
        this.snippet.setId(201);
        this.snippet.setTextColor(Color.argb((int)255, (int)192, (int)192, (int)192));
        this.snippet.setTag((Object)"subtitle");
        TiUIHelper.styleText((TextView)this.snippet, (String)"sans-serif", (String)"10sip", (String)"bold");
        params = this.createBaseParams();
        params.addRule(3, 200);
        textLayout.addView((View)this.snippet, (ViewGroup.LayoutParams)params);
        params = this.createBaseParams();
        params.addRule(1, 100);
        params.addRule(6);
        this.layout.addView((View)textLayout, (ViewGroup.LayoutParams)params);
        this.rightImage = new ImageView(context);
        this.rightImage.setId(103);
        this.rightImage.setTag((Object)"rightButton");
        params = this.createBaseParams();
        if (Integer.parseInt(Build.VERSION.SDK) > 3) {
            params.addRule(15);
        }
        params.addRule(1, 101);
        params.setMargins(5, 0, 0, 0);
        this.layout.addView((View)this.rightImage, (ViewGroup.LayoutParams)params);
        FrameLayout.LayoutParams fparams = new FrameLayout.LayoutParams(-2, -2);
        fparams.gravity = 0;
        this.addView((View)this.layout, (ViewGroup.LayoutParams)fparams);
        this.hitTestList = new View[]{this.leftImage, this.title, this.snippet, this.rightImage};
    }

    private RelativeLayout.LayoutParams createBaseParams() {
        return new RelativeLayout.LayoutParams(-2, -2);
    }

    public void setItem(int index, TiOverlayItem item) {
        TiFileHelper tfh = new TiFileHelper(this.getContext());
        Drawable d = null;
        this.lastIndex = index;
        if (item.getLeftButton() != null) {
            try {
                d = tfh.loadDrawable((TiContext)this.weakTiContext.get(), item.getLeftButton(), false);
                this.leftImage.setImageDrawable(d);
                this.leftImage.setVisibility(0);
            }
            catch (Exception e) {
                this.leftImage.setVisibility(8);
                Log.e((String)LCAT, (String)("Error loading left button - " + item.getLeftButton() + ": " + e.getMessage()));
            }
        } else {
            this.leftImage.setVisibility(8);
        }
        if (item.getRightButton() != null) {
            try {
                d = tfh.loadDrawable((TiContext)this.weakTiContext.get(), item.getRightButton(), false);
                this.rightImage.setImageDrawable(d);
                this.rightImage.setVisibility(0);
            }
            catch (Exception e) {
                this.rightImage.setVisibility(8);
                Log.e((String)LCAT, (String)("Error loading right button - " + item.getRightButton() + ": " + e.getMessage()));
            }
        } else {
            this.rightImage.setVisibility(8);
        }
        if (item.getTitle() != null) {
            this.title.setVisibility(0);
            this.title.setText((CharSequence)item.getTitle());
        } else {
            this.title.setVisibility(8);
        }
        if (item.getSnippet() != null) {
            this.snippet.setVisibility(0);
            this.snippet.setText((CharSequence)item.getSnippet());
        } else {
            this.snippet.setVisibility(8);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            Rect hitRect = new Rect();
            for (View v : this.hitTestList) {
                String tag = (String)v.getTag();
                if (v.getVisibility() != 0 || tag == null) continue;
                v.getHitRect(hitRect);
                if (!hitRect.contains(x, y)) continue;
                if (this.overlayClickedListener == null) break;
                this.overlayClickedListener.onClick(this.lastIndex, tag);
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setOnOverlayClickedListener(OnOverlayClicked listener) {
        this.overlayClickedListener = listener;
    }

    public void clearLastIndex() {
        this.lastIndex = -1;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public static interface OnOverlayClicked {
        public void onClick(int var1, String var2);
    }
}

