/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.map;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Toast;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiProperties;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.map.AnnotationProxy;
import ti.modules.titanium.map.TiMapActivity;
import ti.modules.titanium.map.TiOverlayItem;
import ti.modules.titanium.map.TiOverlayItemView;
import ti.modules.titanium.map.TitaniumOverlayListener;
import ti.modules.titanium.map.ViewProxy;

public class TiMapView
extends TiUIView
implements Handler.Callback,
TitaniumOverlayListener {
    private static final String LCAT = "TiMapView";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String TI_DEVELOPMENT_KEY = "0ZnKXkWA2dIAu2EM-OV4ZD2lJY3sEWE5TSgjJNg";
    private static final String OLD_API_KEY = "ti.android.google.map.api.key";
    private static final String DEVELOPMENT_API_KEY = "ti.android.google.map.api.key.development";
    private static final String PRODUCTION_API_KEY = "ti.android.google.map.api.key.production";
    public static final int MAP_VIEW_STANDARD = 1;
    public static final int MAP_VIEW_SATELLITE = 2;
    public static final int MAP_VIEW_HYBRID = 3;
    private static final int MSG_SET_LOCATION = 300;
    private static final int MSG_SET_MAPTYPE = 301;
    private static final int MSG_SET_REGIONFIT = 302;
    private static final int MSG_SET_ANIMATE = 303;
    private static final int MSG_SET_USERLOCATION = 304;
    private static final int MSG_SET_SCROLLENABLED = 305;
    private static final int MSG_CHANGE_ZOOM = 306;
    private static final int MSG_ADD_ANNOTATION = 307;
    private static final int MSG_REMOVE_ANNOTATION = 308;
    private static final int MSG_SELECT_ANNOTATION = 309;
    private static final int MSG_REMOVE_ALL_ANNOTATIONS = 310;
    private static final int MSG_UPDATE_ANNOTATIONS = 311;
    private boolean scrollEnabled;
    private boolean regionFit;
    private boolean animate;
    private boolean userLocation;
    private LocalMapView view;
    private Window mapWindow;
    private TitaniumOverlay overlay;
    private MyLocationOverlay myLocation;
    private TiOverlayItemView itemView;
    private ArrayList<AnnotationProxy> annotations;
    private ArrayList<SelectedAnnotation> selectedAnnotations;
    private Handler handler;

    public TiMapView(TiViewProxy proxy, Window mapWindow, ArrayList<AnnotationProxy> annotations, ArrayList<SelectedAnnotation> selectedAnnotations) {
        super(proxy);
        this.mapWindow = mapWindow;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.annotations = annotations;
        this.selectedAnnotations = selectedAnnotations;
        TiApplication app = proxy.getTiContext().getTiApp();
        TiProperties systemProperties = app.getSystemProperties();
        String oldKey = systemProperties.getString(OLD_API_KEY, "");
        String developmentKey = systemProperties.getString(DEVELOPMENT_API_KEY, "");
        String productionKey = systemProperties.getString(PRODUCTION_API_KEY, "");
        String devKeySourceInfo = "";
        String prodKeySourceInfo = "";
        if (developmentKey.length() > 0) {
            devKeySourceInfo = "application property 'ti.android.google.map.api.key.development'";
        } else if (oldKey.length() > 0) {
            developmentKey = oldKey;
            devKeySourceInfo = "application property 'ti.android.google.map.api.key'";
        } else {
            developmentKey = TI_DEVELOPMENT_KEY;
            devKeySourceInfo = "(Source Code)";
        }
        if (productionKey.length() > 0) {
            prodKeySourceInfo = "application property 'ti.android.google.map.api.key.production'";
        } else {
            productionKey = developmentKey;
            prodKeySourceInfo = devKeySourceInfo + " (fallback)";
        }
        String apiKey = developmentKey;
        if (app.getDeployType().equals("production")) {
            apiKey = productionKey;
            Log.d((String)LCAT, (String)("Production mode using map api key ending with '" + productionKey.substring(productionKey.length() - 10, productionKey.length()) + "' retrieved from " + prodKeySourceInfo));
        } else {
            Log.d((String)LCAT, (String)("Development mode using map api key ending with '" + developmentKey.substring(developmentKey.length() - 10, developmentKey.length()) + "' retrieved from " + devKeySourceInfo));
        }
        this.view = new LocalMapView(mapWindow.getContext(), apiKey);
        TiMapActivity ma = (TiMapActivity)mapWindow.getContext();
        ma.setLifecycleListener(new TiContext.OnLifecycleEvent(){

            public void onPause(Activity activity) {
                if (TiMapView.this.myLocation != null) {
                    if (DBG) {
                        Log.d((String)TiMapView.LCAT, (String)"onPause: Disabling My Location");
                    }
                    TiMapView.this.myLocation.disableMyLocation();
                }
            }

            public void onResume(Activity activity) {
                if (TiMapView.this.myLocation != null && TiMapView.this.userLocation) {
                    if (DBG) {
                        Log.d((String)TiMapView.LCAT, (String)"onResume: Enabling My Location");
                    }
                    TiMapView.this.myLocation.enableMyLocation();
                }
            }

            public void onDestroy(Activity activity) {
            }

            public void onStart(Activity activity) {
            }

            public void onStop(Activity activity) {
            }
        });
        this.view.setBuiltInZoomControls(true);
        this.view.setScrollable(true);
        this.view.setClickable(true);
        this.setNativeView((View)this.view);
        this.regionFit = true;
        this.animate = false;
        final TiViewProxy fproxy = proxy;
        this.itemView = new TiOverlayItemView(proxy.getContext(), proxy.getTiContext());
        this.itemView.setOnOverlayClickedListener(new TiOverlayItemView.OnOverlayClicked(){

            @Override
            public void onClick(int lastIndex, String clickedItem) {
                TiOverlayItem item = (TiOverlayItem)TiMapView.this.overlay.getItem(lastIndex);
                if (item != null) {
                    KrollDict d = new KrollDict();
                    d.put((Object)"title", (Object)item.getTitle());
                    d.put((Object)"subtitle", (Object)item.getSnippet());
                    d.put((Object)"latitude", (Object)TiMapView.this.scaleFromGoogle(item.getPoint().getLatitudeE6()));
                    d.put((Object)"longitude", (Object)TiMapView.this.scaleFromGoogle(item.getPoint().getLongitudeE6()));
                    d.put((Object)"annotation", (Object)item.getProxy());
                    d.put((Object)"clicksource", (Object)clickedItem);
                    fproxy.fireEvent("click", d);
                }
            }
        });
    }

    private LocalMapView getView() {
        return this.view;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 300: {
                this.doSetLocation((KrollDict)msg.obj);
                return true;
            }
            case 301: {
                this.doSetMapType(msg.arg1);
                return true;
            }
            case 302: {
                this.regionFit = msg.arg1 == 1;
                return true;
            }
            case 303: {
                this.animate = msg.arg1 == 1;
                return true;
            }
            case 305: {
                boolean bl = this.animate = msg.arg1 == 1;
                if (this.view != null) {
                    this.view.setScrollable(this.scrollEnabled);
                }
                return true;
            }
            case 304: {
                this.userLocation = msg.arg1 == 1;
                this.doUserLocation(this.userLocation);
                return true;
            }
            case 306: {
                MapController mc = this.view.getController();
                if (mc != null) {
                    mc.setZoom(this.view.getZoomLevel() + msg.arg1);
                }
                return true;
            }
            case 309: {
                Bundle args = msg.getData();
                boolean select = args.getBoolean("select", false);
                String title = args.getString("title");
                boolean animate = args.getBoolean("animate", false);
                boolean center = args.getBoolean("center", true);
                this.doSelectAnnotation(select, title, animate, center);
                return true;
            }
            case 311: {
                this.doUpdateAnnotations();
                return true;
            }
        }
        return false;
    }

    private void hideAnnotation() {
        if (this.view != null && this.itemView != null) {
            this.view.removeView((View)this.itemView);
            this.itemView.clearLastIndex();
        }
    }

    private void showAnnotation(int index, TiOverlayItem item) {
        Log.e((String)LCAT, (String)("B:" + (Object)((Object)this.view) + ":" + (Object)((Object)this.itemView) + ":" + (Object)((Object)item)));
        if (this.view != null && this.itemView != null && item != null) {
            Log.e((String)LCAT, (String)"B2");
            this.itemView.setItem(index, item);
            int y = -1 * item.getMarker(4).getIntrinsicHeight();
            MapView.LayoutParams params = new MapView.LayoutParams(-2, -2, item.getPoint(), 0, y, 81);
            params.mode = 0;
            this.view.addView((View)this.itemView, (ViewGroup.LayoutParams)params);
        }
    }

    public void updateAnnotations() {
        this.handler.obtainMessage(311).sendToTarget();
    }

    public void doUpdateAnnotations() {
        if (this.itemView != null && this.view != null && this.view.indexOfChild((View)this.itemView) != -1) {
            this.hideAnnotation();
        }
        this.doSetAnnotations(this.annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTap(int index) {
        if (this.overlay != null) {
            TitaniumOverlay titaniumOverlay = this.overlay;
            synchronized (titaniumOverlay) {
                TiOverlayItem item = (TiOverlayItem)this.overlay.getItem(index);
                if (this.itemView != null && index == this.itemView.getLastIndex() && this.itemView.getVisibility() == 0) {
                    this.hideAnnotation();
                    return;
                }
                if (item.hasData()) {
                    this.hideAnnotation();
                    this.showAnnotation(index, item);
                } else {
                    Toast.makeText((Context)this.proxy.getContext(), (CharSequence)"No information for location", (int)0).show();
                }
            }
        }
    }

    public void processProperties(KrollDict d) {
        LocalMapView view = this.getView();
        if (d.containsKey((Object)"mapType")) {
            this.doSetMapType(TiConvert.toInt((KrollDict)d, (String)"mapType"));
        }
        if (d.containsKey((Object)"zoomEnabled")) {
            view.setBuiltInZoomControls(TiConvert.toBoolean((KrollDict)d, (String)"zoomEnabled"));
        }
        if (d.containsKey((Object)"scrollEnabled")) {
            view.setScrollable(TiConvert.toBoolean((KrollDict)d, (String)"scrollEnabled"));
        }
        if (d.containsKey((Object)"region")) {
            this.doSetLocation(d.getKrollDict("region"));
        }
        if (d.containsKey((Object)"regionFit")) {
            this.regionFit = d.getBoolean("regionFit");
        }
        if (d.containsKey((Object)"animate")) {
            this.animate = d.getBoolean("animate");
        }
        if (d.containsKey((Object)"userLocation")) {
            this.doUserLocation(d.getBoolean("userLocation"));
        }
        if (d.containsKey((Object)"annotations")) {
            this.proxy.setProperty("annotations", d.get((Object)"annotations"));
            Object[] annotations = (Object[])d.get((Object)"annotations");
            for (int i = 0; i < annotations.length; ++i) {
                AnnotationProxy ap = (AnnotationProxy)((Object)annotations[i]);
                this.annotations.add(ap);
            }
            this.doSetAnnotations(this.annotations);
        }
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("location")) {
            if (newValue != null) {
                if (newValue instanceof AnnotationProxy) {
                    AnnotationProxy ap = (AnnotationProxy)((Object)newValue);
                    this.doSetLocation(ap.getProperties());
                } else if (newValue instanceof KrollDict) {
                    this.doSetLocation((KrollDict)newValue);
                }
            }
        } else if (key.equals("mapType")) {
            if (newValue == null) {
                this.doSetMapType(1);
            } else {
                this.doSetMapType(TiConvert.toInt((Object)newValue));
            }
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void doSetLocation(KrollDict d) {
        LocalMapView view = this.getView();
        if (d.containsKey((Object)"longitude") && d.containsKey((Object)"latitude")) {
            GeoPoint gp = new GeoPoint(this.scaleToGoogle(d.getDouble("latitude")), this.scaleToGoogle(d.getDouble("longitude")));
            boolean anim = false;
            if (d.containsKey((Object)"animate")) {
                anim = TiConvert.toBoolean((KrollDict)d, (String)"animate");
            }
            if (anim) {
                view.getController().animateTo(gp);
            } else {
                view.getController().setCenter(gp);
            }
        }
        if (this.regionFit && d.containsKey((Object)"longitudeDelta") && d.containsKey((Object)"latitudeDelta")) {
            view.getController().zoomToSpan(this.scaleToGoogle(d.getDouble("latitudeDelta")), this.scaleToGoogle(d.getDouble("longitudeDelta")));
        } else {
            Log.w((String)LCAT, (String)"span must have longitudeDelta and latitudeDelta");
        }
    }

    public void doSetMapType(int type) {
        if (this.view != null) {
            switch (type) {
                case 1: {
                    this.view.setSatellite(false);
                    this.view.setTraffic(false);
                    this.view.setStreetView(false);
                    break;
                }
                case 2: {
                    this.view.setSatellite(true);
                    this.view.setTraffic(false);
                    this.view.setStreetView(false);
                    break;
                }
                case 3: {
                    this.view.setSatellite(false);
                    this.view.setTraffic(false);
                    this.view.setStreetView(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetAnnotations(ArrayList<AnnotationProxy> annotations) {
        if (annotations != null) {
            List overlays;
            this.annotations = annotations;
            List list = overlays = this.view.getOverlays();
            synchronized (list) {
                if (overlays.contains((Object)this.overlay)) {
                    overlays.remove((Object)this.overlay);
                    this.overlay = null;
                }
                if (annotations.size() > 0) {
                    this.overlay = new TitaniumOverlay(this.makeMarker(-16776961), this);
                    this.overlay.setAnnotations(annotations);
                    overlays.add(this.overlay);
                    int numSelectedAnnotations = this.selectedAnnotations.size();
                    for (int i = 0; i < numSelectedAnnotations; ++i) {
                        SelectedAnnotation annotation = this.selectedAnnotations.get(i);
                        if (DBG) {
                            Log.d((String)LCAT, (String)("Executing internal call to selectAnnotation:" + annotation.title));
                        }
                        this.selectAnnotation(true, annotation.title, annotation.animate, annotation.center);
                    }
                }
                this.view.invalidate();
            }
        }
    }

    public void selectAnnotation(boolean select, String title, boolean animate, boolean center) {
        if (title != null) {
            Log.e((String)LCAT, (String)"calling obtainMessage");
            Bundle args = new Bundle();
            args.putBoolean("select", select);
            args.putString("title", title);
            args.putBoolean("animate", animate);
            args.putBoolean("center", center);
            Message message = this.handler.obtainMessage(309);
            message.setData(args);
            message.sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelectAnnotation(boolean select, String title, boolean animate, boolean center) {
        Log.e((String)LCAT, (String)("A:" + title + ":" + (Object)((Object)this.view) + ":" + this.annotations + ":" + (Object)((Object)this.overlay)));
        if (title != null && this.view != null && this.annotations != null && this.overlay != null) {
            int index = ((ViewProxy)this.proxy).findAnnotation(title);
            Log.e((String)LCAT, (String)("A2:" + index));
            if (index > -1 && this.overlay != null) {
                TitaniumOverlay titaniumOverlay = this.overlay;
                synchronized (titaniumOverlay) {
                    TiOverlayItem item = (TiOverlayItem)this.overlay.getItem(index);
                    if (select) {
                        if (this.itemView != null && index == this.itemView.getLastIndex() && this.itemView.getVisibility() != 0) {
                            this.showAnnotation(index, item);
                            return;
                        }
                        this.hideAnnotation();
                        if (center) {
                            MapController controller = this.view.getController();
                            if (animate) {
                                controller.animateTo(item.getPoint());
                            } else {
                                controller.setCenter(item.getPoint());
                            }
                        }
                        Log.e((String)LCAT, (String)("A3:" + index + ":" + (Object)((Object)item)));
                        this.showAnnotation(index, item);
                    } else {
                        this.hideAnnotation();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUserLocation(boolean userLocation) {
        if (this.view != null) {
            if (userLocation) {
                List overlays;
                if (this.myLocation == null) {
                    this.myLocation = new MyLocationOverlay(this.proxy.getContext(), (MapView)this.view);
                }
                List list = overlays = this.view.getOverlays();
                synchronized (list) {
                    if (!overlays.contains(this.myLocation)) {
                        overlays.add(this.myLocation);
                    }
                }
                this.myLocation.enableMyLocation();
            } else if (this.myLocation != null) {
                List overlays;
                List list = overlays = this.view.getOverlays();
                synchronized (list) {
                    if (overlays.contains(this.myLocation)) {
                        overlays.remove(this.myLocation);
                    }
                    this.myLocation.disableMyLocation();
                }
            }
        }
    }

    public void changeZoomLevel(int delta) {
        this.handler.obtainMessage(306, delta, 0).sendToTarget();
    }

    private Drawable makeMarker(int c) {
        OvalShape s = new OvalShape();
        s.resize(1.0f, 1.0f);
        ShapeDrawable d = new ShapeDrawable((Shape)s);
        d.setBounds(0, 0, 15, 15);
        d.getPaint().setColor(c);
        return d;
    }

    private Drawable makeMarker(String pinImage) {
        String url = this.proxy.getTiContext().resolveUrl(null, pinImage);
        TiBaseFile file = TiFileFactory.createTitaniumFile((TiContext)this.proxy.getTiContext(), (String[])new String[]{url}, (boolean)false);
        try {
            BitmapDrawable d = new BitmapDrawable(TiUIHelper.createBitmap((InputStream)file.getInputStream()));
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            return d;
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)("Error creating drawable from path: " + pinImage.toString()), (Throwable)e);
            return null;
        }
    }

    private double scaleFromGoogle(int value) {
        return (double)value / 1000000.0;
    }

    private int scaleToGoogle(double value) {
        return (int)(value * 1000000.0);
    }

    public static class SelectedAnnotation {
        String title;
        boolean animate;
        boolean center;

        public SelectedAnnotation(String title, boolean animate, boolean center) {
            this.title = title;
            this.animate = animate;
            this.center = center;
        }
    }

    class TitaniumOverlay
    extends ItemizedOverlay<TiOverlayItem> {
        ArrayList<AnnotationProxy> annotations;
        TitaniumOverlayListener listener;

        public TitaniumOverlay(Drawable defaultDrawable, TitaniumOverlayListener listener) {
            super(defaultDrawable);
            this.listener = listener;
        }

        public void setAnnotations(ArrayList<AnnotationProxy> annotations) {
            this.annotations = new ArrayList<AnnotationProxy>(annotations);
            this.populate();
        }

        protected TiOverlayItem createItem(int i) {
            TiOverlayItem item = null;
            AnnotationProxy p = this.annotations.get(i);
            KrollDict a = p.getProperties();
            if (a.containsKey((Object)"latitude") && a.containsKey((Object)"longitude")) {
                String title = a.optString("title", "");
                String subtitle = a.optString("subtitle", "");
                GeoPoint location = new GeoPoint(TiMapView.this.scaleToGoogle(a.getDouble("latitude")), TiMapView.this.scaleToGoogle(a.getDouble("longitude")));
                item = new TiOverlayItem(location, title, subtitle, p);
                if (a.containsKey((Object)"image") || a.containsKey((Object)"pinImage")) {
                    String imagePath = a.getString("image");
                    if (imagePath == null) {
                        imagePath = a.getString("pinImage");
                    }
                    Drawable marker = TiMapView.this.makeMarker(imagePath);
                    TitaniumOverlay.boundCenterBottom((Drawable)marker);
                    item.setMarker(marker);
                } else if (a.containsKey((Object)"pincolor")) {
                    Object value = a.get((Object)"pincolor");
                    try {
                        if (value instanceof String) {
                            int markerColor = TiConvert.toColor((String)((String)value));
                            item.setMarker(TiMapView.this.makeMarker(markerColor));
                        } else {
                            switch (a.getInt("pincolor")) {
                                case 1: {
                                    item.setMarker(TiMapView.this.makeMarker(-65536));
                                    break;
                                }
                                case 2: {
                                    item.setMarker(TiMapView.this.makeMarker(-16711936));
                                    break;
                                }
                                case 3: {
                                    item.setMarker(TiMapView.this.makeMarker(Color.argb((int)255, (int)192, (int)0, (int)192)));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TiMapView.LCAT, (String)("Unable to parse color [" + a.getString("pincolor") + "] for item [" + i + "]"));
                    }
                }
                if (a.containsKey((Object)"leftButton")) {
                    item.setLeftButton(TiMapView.this.proxy.getTiContext().resolveUrl(null, TiConvert.toString((KrollDict)a, (String)"leftButton")));
                }
                if (a.containsKey((Object)"rightButton")) {
                    item.setRightButton(TiMapView.this.proxy.getTiContext().resolveUrl(null, TiConvert.toString((KrollDict)a, (String)"rightButton")));
                }
            } else {
                Log.w((String)TiMapView.LCAT, (String)("Skipping annotation: No coordinates #" + i));
            }
            return item;
        }

        public int size() {
            return this.annotations == null ? 0 : this.annotations.size();
        }

        protected boolean onTap(int index) {
            boolean handled = super.onTap(index);
            if (!handled) {
                this.listener.onTap(index);
            }
            return handled;
        }
    }

    class LocalMapView
    extends MapView {
        private boolean scrollEnabled;
        private int lastLongitude;
        private int lastLatitude;
        private int lastLatitudeSpan;
        private int lastLongitudeSpan;

        public LocalMapView(Context context, String apiKey) {
            super(context, apiKey);
            this.scrollEnabled = false;
        }

        public void setScrollable(boolean enable) {
            this.scrollEnabled = enable;
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            if (!this.scrollEnabled && ev.getAction() == 2) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        public boolean dispatchTrackballEvent(MotionEvent ev) {
            if (!this.scrollEnabled && ev.getAction() == 2) {
                return true;
            }
            return super.dispatchTrackballEvent(ev);
        }

        public void computeScroll() {
            super.computeScroll();
            GeoPoint center = this.getMapCenter();
            if (this.lastLatitude != center.getLatitudeE6() || this.lastLongitude != center.getLongitudeE6() || this.lastLatitudeSpan != this.getLatitudeSpan() || this.lastLongitudeSpan != this.getLongitudeSpan()) {
                this.lastLatitude = center.getLatitudeE6();
                this.lastLongitude = center.getLongitudeE6();
                this.lastLatitudeSpan = this.getLatitudeSpan();
                this.lastLongitudeSpan = this.getLongitudeSpan();
                KrollDict d = new KrollDict();
                d.put((Object)"latitude", (Object)TiMapView.this.scaleFromGoogle(this.lastLatitude));
                d.put((Object)"longitude", (Object)TiMapView.this.scaleFromGoogle(this.lastLongitude));
                d.put((Object)"latitudeDelta", (Object)TiMapView.this.scaleFromGoogle(this.lastLatitudeSpan));
                d.put((Object)"longitudeDelta", (Object)TiMapView.this.scaleFromGoogle(this.lastLongitudeSpan));
                TiMapView.this.proxy.fireEvent("regionChanged", d);
            }
        }
    }
}

