/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.locale;

import android.telephony.PhoneNumberUtils;
import java.util.Locale;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiRHelper;

public class LocaleModule
extends KrollModule {
    private static final String LCAT = "LocaleModule";
    private static final boolean DBG = TiConfig.LOGD;

    public LocaleModule(TiContext tiContext) {
        super(tiContext);
    }

    public String getCurrentLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getCurrentCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getCurrentLocale() {
        return TiPlatformHelper.getLocale();
    }

    public String getCurrencyCode(String localeString) {
        if (localeString == null) {
            return null;
        }
        Locale locale = TiPlatformHelper.getLocale((String)localeString);
        return TiPlatformHelper.getCurrencyCode((Locale)locale);
    }

    public String getCurrencySymbol(String currencyCode) {
        return TiPlatformHelper.getCurrencySymbol((String)currencyCode);
    }

    public String getLocaleCurrencySymbol(String localeString) {
        if (localeString == null) {
            return null;
        }
        Locale locale = TiPlatformHelper.getLocale((String)localeString);
        return TiPlatformHelper.getCurrencySymbol((Locale)locale);
    }

    public String formatTelephoneNumber(String telephoneNumber) {
        return PhoneNumberUtils.formatNumber((String)telephoneNumber);
    }

    public void setLanguage(String language) {
        Log.w((String)LCAT, (String)"Locale.setLanguage not supported for Android.");
    }

    public String getString(KrollInvocation invocation, String key, @Kroll.argument(optional=true) String defaultValue) {
        try {
            int resid = TiRHelper.getResource((String)("string." + key));
            if (resid != 0) {
                return invocation.getTiContext().getActivity().getString(resid);
            }
            return defaultValue;
        }
        catch (TiRHelper.ResourceNotFoundException e) {
            if (DBG) {
                Log.d((String)LCAT, (String)("Resource string with key '" + key + "' not found.  Returning default value."));
            }
            return defaultValue;
        }
        catch (Exception e) {
            Log.e((String)LCAT, (String)("Error trying to get resource string with key '" + key + "':"), (Throwable)e);
            return defaultValue;
        }
    }
}

