/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.json;

import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.TiConvert;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONModule
extends KrollModule {
    public JSONModule(TiContext context) {
        super(context);
    }

    public String stringify(Object data) {
        if (data instanceof KrollDict) {
            return TiConvert.toJSON((KrollDict)((KrollDict)data)).toString();
        }
        if (data instanceof Object[]) {
            Object[] objects = (Object[])data;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < objects.length; ++i) {
                sb.append(this.stringify(objects[i]));
                if (i >= objects.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (data instanceof Number) {
            double whole;
            double d = ((Number)data).doubleValue();
            double d2 = whole = d < 0.0 ? Math.ceil(d) : Math.floor(d);
            if (d - whole == 0.0) {
                return "" + (int)d;
            }
            return "" + d;
        }
        if (data instanceof Boolean) {
            return TiConvert.toJSONString((Object)data);
        }
        return "\"" + TiConvert.toJSONString((Object)data) + "\"";
    }

    public Object parse(String json) throws JSONException {
        Object[] parsed = null;
        if (json == null || json.length() == 0) {
            return parsed;
        }
        String trimmed = json.trim();
        char firstChar = trimmed.charAt(0);
        if (firstChar == '{') {
            parsed = new KrollDict(new JSONObject(json));
        } else if (firstChar == '[') {
            JSONArray array = new JSONArray(json);
            Object[] result = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                result[i] = KrollDict.fromJSON((Object)array.get(i));
            }
            parsed = result;
        } else {
            parsed = new JSONTokener(json).nextValue();
        }
        return parsed;
    }
}

