/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.gesture;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import java.util.ArrayList;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.ContextSpecific;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiProperties;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiOrientationHelper;
import org.appcelerator.titanium.util.TiSensorHelper;

@ContextSpecific
public class GestureModule
extends KrollModule
implements SensorEventListener {
    private static final String LCAT = "GestureModule";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String EVENT_ORIENTATION_CHANGE = "orientationchange";
    private static final String EVENT_SHAKE = "shake";
    private boolean shakeRegistered = false;
    private long firstEventInShake;
    private long lastEventInShake;
    private boolean shakeInitialized = false;
    private boolean inShake = false;
    private double threshold;
    private double shakeFactor;
    private int postShakePeriod;
    private int inShakePeriod;
    private List<Object> orientationConfigListeners = new ArrayList<Object>();

    public GestureModule(TiContext tiContext) {
        super(tiContext);
        TiProperties props = TiApplication.getInstance().getAppProperties();
        this.shakeFactor = props.getDouble("ti.android.shake.factor", 1.3);
        this.postShakePeriod = props.getInt("ti.android.shake.quiet.milliseconds", 500);
        this.inShakePeriod = props.getInt("ti.android.shake.active.milliseconds", 1000);
        this.threshold = this.shakeFactor * this.shakeFactor * (double)9.80665f * (double)9.80665f;
        if (DBG) {
            Log.i((String)LCAT, (String)("Shake Factor: " + this.shakeFactor));
            Log.i((String)LCAT, (String)("Post Shake Period (ms): " + this.postShakePeriod));
            Log.i((String)LCAT, (String)("In Shake Period(ms): " + this.inShakePeriod));
            Log.i((String)LCAT, (String)("Threshold: " + this.threshold));
        }
    }

    public int addEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if (EVENT_ORIENTATION_CHANGE.equals(eventName)) {
            if (this.orientationConfigListeners.size() == 0) {
                TiBaseActivity.registerOrientationListener((TiBaseActivity.OrientationChangedListener)new TiBaseActivity.OrientationChangedListener(){

                    public void onOrientationChanged(int configOrientationMode) {
                        KrollDict data = new KrollDict();
                        data.put((Object)"orientation", (Object)TiOrientationHelper.convertConfigToTiOrientationMode((int)configOrientationMode));
                        GestureModule.this.fireEvent(GestureModule.EVENT_ORIENTATION_CHANGE, data);
                    }
                });
            }
            this.orientationConfigListeners.add(listener);
        } else if (EVENT_SHAKE.equals(eventName) && !this.shakeRegistered) {
            TiSensorHelper.registerListener((int)1, (SensorEventListener)this, (int)2);
            this.shakeRegistered = true;
        }
        return super.addEventListener(invocation, eventName, listener);
    }

    public void removeEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if (EVENT_ORIENTATION_CHANGE.equals(eventName)) {
            if (this.orientationConfigListeners.contains(listener)) {
                this.orientationConfigListeners.remove(listener);
                if (this.orientationConfigListeners.size() == 0) {
                    TiBaseActivity.deregisterOrientationListener();
                }
            } else {
                Log.e((String)LCAT, (String)"unable to remove orientation config listener, does not exist");
            }
        } else if (EVENT_SHAKE.equals(eventName) && this.shakeRegistered) {
            TiSensorHelper.unregisterListener((int)1, (SensorEventListener)this);
            this.shakeRegistered = false;
        }
        super.removeEventListener(invocation, eventName, listener);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        long currentEventInShake = System.currentTimeMillis();
        long difftime = currentEventInShake - this.lastEventInShake;
        float x = event.values[0];
        float y = event.values[1];
        float z = event.values[2];
        double force = Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0);
        if (this.threshold < force) {
            if (!this.inShake) {
                this.firstEventInShake = currentEventInShake;
                this.inShake = true;
            }
            this.lastEventInShake = currentEventInShake;
            Log.d((String)LCAT, (String)("ACC-Shake : threshold: " + this.threshold + " force: " + force + " delta : " + force + " x: " + x + " y: " + y + " z: " + z));
        } else if (this.shakeInitialized && this.inShake && difftime > (long)this.postShakePeriod) {
            this.inShake = false;
            if (this.lastEventInShake - this.firstEventInShake > (long)this.inShakePeriod) {
                KrollDict data = new KrollDict();
                data.put((Object)"type", (Object)EVENT_SHAKE);
                data.put((Object)"timestamp", (Object)this.lastEventInShake);
                data.put((Object)"x", (Object)Float.valueOf(x));
                data.put((Object)"y", (Object)Float.valueOf(y));
                data.put((Object)"z", (Object)Float.valueOf(z));
                this.fireEvent(EVENT_SHAKE, data);
                Log.d((String)LCAT, (String)("Firing shake event (x:" + x + " y:" + y + " z:" + z + ")"));
            }
        }
        if (!this.shakeInitialized) {
            this.shakeInitialized = true;
        }
    }

    public boolean isPortrait(KrollInvocation invocation) {
        return invocation.getActivity().getResources().getConfiguration().orientation == 1;
    }

    public boolean isLandscape(KrollInvocation invocation) {
        return invocation.getActivity().getResources().getConfiguration().orientation == 2;
    }

    public int getOrientation(KrollInvocation invocation) {
        return TiOrientationHelper.convertConfigToTiOrientationMode((int)invocation.getActivity().getResources().getConfiguration().orientation);
    }
}

