/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.geolocation;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Message;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.analytics.TiAnalyticsEvent;
import org.appcelerator.titanium.analytics.TiAnalyticsEventFactory;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiLocationHelper;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ti.modules.titanium.geolocation.GeolocationModule;

public class TiLocation
implements LocationListener {
    private static final String LCAT = "TiLocation";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String BASE_GEO_URL = "http://api.appcelerator.net/p/v1/geo?";
    private static final String DIRECTION_R = "r";
    private static final String DIRECTION_F = "f";
    private long lastEventTimestamp = 0L;
    private GeolocationModule geolocationModule;
    private Integer accuracy = null;
    private Integer frequency = null;
    private String preferredProvider;

    public TiLocation(GeolocationModule geolocationModule) {
        this.geolocationModule = geolocationModule;
    }

    private void refreshProperties() {
        Object frequencyProp = this.geolocationModule.getProperty("frequency");
        Object accuracyProp = this.geolocationModule.getProperty("accuracy");
        this.preferredProvider = TiConvert.toString((Object)this.geolocationModule.getProperty("preferredProvider"));
        Log.d((String)LCAT, (String)("preferredProvider property found [" + this.preferredProvider + "]"));
        if (frequencyProp != null) {
            this.frequency = new Integer(TiConvert.toInt((Object)frequencyProp));
            Log.d((String)LCAT, (String)("frequency property found [" + this.frequency + "]"));
        }
        if (accuracyProp != null) {
            this.accuracy = new Integer(TiConvert.toInt((Object)accuracyProp));
            Log.d((String)LCAT, (String)("accuracy property found [" + this.accuracy + "]"));
        }
    }

    public void registerListener() {
        this.refreshProperties();
        TiLocationHelper.registerListener((String)this.preferredProvider, (Integer)this.accuracy, (Integer)this.frequency, (LocationListener)this);
    }

    public void unregisterListener() {
        TiLocationHelper.unregisterListener((LocationListener)this);
    }

    private void updateProvider(String provider) {
        this.refreshProperties();
        TiLocationHelper.updateProvider((String)this.preferredProvider, (Integer)this.accuracy, (String)provider, (Integer)this.frequency, (LocationListener)this);
    }

    public void onLocationChanged(Location location) {
        LocationProvider provider = TiLocationHelper.getLocationManager().getProvider(location.getProvider());
        this.geolocationModule.fireEvent("location", this.locationToKrollDict(location, provider));
        this.doAnalytics(location);
        this.updateProvider(provider.getName());
    }

    public void onProviderDisabled(String provider) {
        Log.i((String)LCAT, (String)("Provider disabled:" + provider));
        this.geolocationModule.fireEvent("location", TiConvert.toErrorObject((int)2, (String)(provider + " disabled.")));
        this.updateProvider(provider);
    }

    public void onProviderEnabled(String provider) {
        Log.d((String)LCAT, (String)("Provider enabled:" + provider));
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        Log.d((String)LCAT, (String)("Status changed, provider:" + provider + " status:" + status));
        switch (status) {
            case 0: {
                this.geolocationModule.fireEvent("location", TiConvert.toErrorObject((int)2, (String)(provider + " is out of service.")));
                this.updateProvider(provider);
                break;
            }
            case 1: {
                this.geolocationModule.fireEvent("location", TiConvert.toErrorObject((int)2, (String)(provider + " is currently unavailable.")));
                this.updateProvider(provider);
                break;
            }
            case 2: {
                if (!DBG) break;
                Log.i((String)LCAT, (String)("[" + provider + "] is available"));
                break;
            }
            default: {
                Log.w((String)LCAT, (String)("Unknown status update from [" + provider + "], passed code [" + status + "]"));
            }
        }
    }

    private KrollDict locationToKrollDict(Location location, LocationProvider locationProvider) {
        KrollDict coordinates = new KrollDict();
        coordinates.put((Object)"latitude", (Object)location.getLatitude());
        coordinates.put((Object)"longitude", (Object)location.getLongitude());
        coordinates.put((Object)"altitude", (Object)location.getAltitude());
        coordinates.put((Object)"accuracy", (Object)Float.valueOf(location.getAccuracy()));
        coordinates.put((Object)"altitudeAccuracy", null);
        coordinates.put((Object)"heading", (Object)Float.valueOf(location.getBearing()));
        coordinates.put((Object)"speed", (Object)Float.valueOf(location.getSpeed()));
        coordinates.put((Object)"timestamp", (Object)location.getTime());
        KrollDict position = new KrollDict();
        position.put((Object)"success", (Object)true);
        position.put((Object)"coords", (Object)coordinates);
        if (locationProvider != null) {
            KrollDict provider = new KrollDict();
            provider.put((Object)"name", (Object)locationProvider.getName());
            provider.put((Object)"accuracy", (Object)locationProvider.getAccuracy());
            provider.put((Object)"power", (Object)locationProvider.getPowerRequirement());
            position.put((Object)"provider", (Object)provider);
        }
        return position;
    }

    private void doAnalytics(Location location) {
        TiAnalyticsEvent event;
        if (location.getTime() - this.lastEventTimestamp > 60000L && (event = TiAnalyticsEventFactory.createAppGeoEvent((Location)location)) != null) {
            TiApplication.getInstance().postAnalyticsEvent(event);
            this.lastEventTimestamp = location.getTime();
        }
    }

    public boolean getLocationServicesEnabled(KrollInvocation invocation) {
        return TiLocationHelper.isLocationEnabled();
    }

    public void getCurrentPosition(KrollInvocation invocation, KrollCallback listener) {
        if (listener != null) {
            String provider = TiLocationHelper.fetchProvider((String)this.preferredProvider, (Integer)this.accuracy);
            if (provider != null) {
                LocationManager locationManager = TiLocationHelper.getLocationManager();
                Location location = locationManager.getLastKnownLocation(provider);
                if (location != null) {
                    listener.callAsync(this.locationToKrollDict(location, locationManager.getProvider(provider)));
                    this.doAnalytics(location);
                } else {
                    Log.i((String)LCAT, (String)"unable to get current position, location is null");
                    listener.callAsync(TiConvert.toErrorObject((int)2, (String)"location is currently unavailable."));
                }
            } else {
                Log.i((String)LCAT, (String)"unable to get current position, no providers are available");
                listener.callAsync(TiConvert.toErrorObject((int)2, (String)"no providers are available."));
            }
        }
    }

    private String buildGeoURL(String direction, String mid, String aguid, String sid, String query, String countryCode) {
        String url = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(BASE_GEO_URL).append("d=r").append("&mid=").append(mid).append("&aguid=").append(aguid).append("&sid=").append(sid).append("&q=").append(URLEncoder.encode(query, "utf-8"));
            url = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)LCAT, (String)("unable to encode query to utf-8 [" + e.getMessage() + "]"));
        }
        return url;
    }

    public AsyncTask<Object, Void, Integer> getLookUpTask() {
        AsyncTask<Object, Void, Integer> task = new AsyncTask<Object, Void, Integer>(){

            protected Integer doInBackground(Object ... args) {
                try {
                    String url = (String)args[0];
                    String direction = (String)args[1];
                    KrollCallback callback = (KrollCallback)args[2];
                    if (DBG) {
                        Log.d((String)TiLocation.LCAT, (String)("GEO URL [" + url + "]"));
                    }
                    HttpGet httpGet = new HttpGet(url);
                    BasicHttpParams httpParams = new BasicHttpParams();
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
                    DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
                    client.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                    BasicResponseHandler responseHandler = new BasicResponseHandler();
                    String response = (String)client.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
                    if (DBG) {
                        Log.i((String)TiLocation.LCAT, (String)("received Geo [" + response + "]"));
                    }
                    KrollDict event = null;
                    if (response != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(response);
                            if (jsonObject.getBoolean("success")) {
                                event = direction.equals(TiLocation.DIRECTION_R) ? TiLocation.this.buildReverseResponse(jsonObject) : TiLocation.this.buildForwardResponse(jsonObject);
                            } else {
                                event = new KrollDict();
                                KrollDict errorDict = new KrollDict();
                                String errorCode = jsonObject.getString("errorcode");
                                errorDict.put((Object)"message", (Object)("Unable to resolve message: Code (" + errorCode + ")"));
                                errorDict.put((Object)"code", (Object)errorCode);
                                event.put((Object)"error", (Object)errorDict);
                            }
                        }
                        catch (JSONException e) {
                            Log.e((String)TiLocation.LCAT, (String)("error converting geo response to JSONObject [" + e.getMessage() + "]"), (Throwable)e);
                        }
                    }
                    if (event != null) {
                        event.put((Object)"source", (Object)this);
                        callback.callAsync(event);
                    }
                }
                catch (Throwable t) {
                    Log.e((String)TiLocation.LCAT, (String)("error retrieving geocode information [" + t.getMessage() + "]"), (Throwable)t);
                }
                return -1;
            }
        };
        return task;
    }

    public void forwardGeocoder(String address, KrollCallback listener) {
        if (address != null) {
            String countryCode;
            String sid;
            String aguid;
            String mid = TiPlatformHelper.getMobileId();
            String url = this.buildGeoURL(DIRECTION_F, mid, aguid = this.geolocationModule.getTiContext().getTiApp().getAppInfo().getGUID(), sid = TiPlatformHelper.getSessionId(), address, countryCode = Locale.getDefault().getCountry());
            if (url != null) {
                Message msg = this.geolocationModule.getUIHandler().obtainMessage(1100);
                msg.getData().putString("direction", DIRECTION_F);
                msg.getData().putString("url", url);
                msg.obj = listener;
                msg.sendToTarget();
            }
        } else {
            Log.w((String)LCAT, (String)"address should not be null");
        }
    }

    public void reverseGeocoder(double latitude, double longitude, KrollCallback callback) {
        String mid = TiPlatformHelper.getMobileId();
        String aguid = this.geolocationModule.getTiContext().getTiApp().getAppInfo().getGUID();
        String sid = TiPlatformHelper.getSessionId();
        String countryCode = Locale.getDefault().getCountry();
        String url = this.buildGeoURL(DIRECTION_R, mid, aguid, sid, latitude + "," + longitude, countryCode);
        if (url != null) {
            Message msg = this.geolocationModule.getUIHandler().obtainMessage(1100);
            msg.getData().putString("direction", DIRECTION_R);
            msg.getData().putString("url", url);
            msg.obj = callback;
            msg.sendToTarget();
        }
    }

    private KrollDict placeToAddress(JSONObject place) {
        KrollDict address = new KrollDict();
        address.put((Object)"street1", (Object)place.optString("street", ""));
        address.put((Object)"street", (Object)place.optString("street", ""));
        address.put((Object)"city", (Object)place.optString("city", ""));
        address.put((Object)"region1", (Object)"");
        address.put((Object)"region2", (Object)"");
        address.put((Object)"postalCode", (Object)place.optString("zipcode", ""));
        address.put((Object)"country", (Object)place.optString("country", ""));
        address.put((Object)"countryCode", (Object)place.optString("country_code", ""));
        address.put((Object)"longitude", (Object)place.optString("longitude", ""));
        address.put((Object)"latitude", (Object)place.optString("latitude", ""));
        address.put((Object)"displayAddress", (Object)place.optString("address"));
        address.put((Object)"address", (Object)place.optString("address"));
        return address;
    }

    public KrollDict buildReverseResponse(JSONObject jsonObject) throws JSONException {
        KrollDict response = new KrollDict();
        response.put((Object)"success", (Object)true);
        JSONArray places = jsonObject.getJSONArray("places");
        int count = places.length();
        KrollDict[] newPlaces = new KrollDict[count];
        for (int i = 0; i < count; ++i) {
            newPlaces[i] = this.placeToAddress(places.getJSONObject(i));
        }
        response.put((Object)"places", (Object)newPlaces);
        return response;
    }

    public KrollDict buildForwardResponse(JSONObject jsonObject) throws JSONException {
        KrollDict response = new KrollDict();
        JSONArray places = jsonObject.getJSONArray("places");
        if (places.length() > 0) {
            response = this.placeToAddress(places.getJSONObject(0));
        }
        return response;
    }
}

