/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.geolocation;

import android.app.Activity;
import android.hardware.GeomagneticField;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.SystemClock;
import java.util.Calendar;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiLocationHelper;
import org.appcelerator.titanium.util.TiSensorHelper;
import ti.modules.titanium.geolocation.GeolocationModule;

public class TiCompass
implements SensorEventListener {
    private static final String LCAT = "TiCompass";
    private static final boolean DBG = TiConfig.LOGD;
    private GeolocationModule geolocationModule;
    private Calendar baseTime = Calendar.getInstance();
    private long sensorTimerStart = SystemClock.uptimeMillis();
    private long lastEventInUpdate;
    private float lastHeading = 0.0f;
    private GeomagneticField geomagneticField;

    public TiCompass(GeolocationModule geolocationModule) {
        this.geolocationModule = geolocationModule;
    }

    public void registerListener() {
        TiSensorHelper.registerListener((int)3, (SensorEventListener)this, (int)2);
    }

    public void unregisterListener() {
        TiSensorHelper.unregisterListener((int)3, (SensorEventListener)this);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        long eventTimestamp;
        if (event.sensor.getType() == 3 && (eventTimestamp = event.timestamp / 1000000L) - this.lastEventInUpdate > 250L) {
            long actualTimestamp = this.baseTime.getTimeInMillis() + (eventTimestamp - this.sensorTimerStart);
            this.lastEventInUpdate = eventTimestamp;
            Object filter = this.geolocationModule.getProperty("headingFilter");
            if (filter != null) {
                float headingFilter = TiConvert.toFloat((Object)filter);
                if (Math.abs(event.values[0] - this.lastHeading) < headingFilter) {
                    return;
                }
                this.lastHeading = event.values[0];
            }
            this.geolocationModule.fireEvent("heading", this.eventToKrollDict(event, actualTimestamp));
        }
    }

    private KrollDict eventToKrollDict(SensorEvent event, long timestamp) {
        float x = event.values[0];
        float y = event.values[1];
        float z = event.values[2];
        KrollDict heading = new KrollDict();
        heading.put((Object)"type", (Object)"heading");
        heading.put((Object)"timestamp", (Object)timestamp);
        heading.put((Object)"x", (Object)Float.valueOf(x));
        heading.put((Object)"y", (Object)Float.valueOf(y));
        heading.put((Object)"z", (Object)Float.valueOf(z));
        heading.put((Object)"magneticHeading", (Object)Float.valueOf(x));
        heading.put((Object)"accuracy", (Object)event.accuracy);
        if (DBG) {
            switch (event.accuracy) {
                case 0: {
                    Log.i((String)LCAT, (String)"Compass accuracy unreliable");
                    break;
                }
                case 1: {
                    Log.i((String)LCAT, (String)"Compass accuracy low");
                    break;
                }
                case 2: {
                    Log.i((String)LCAT, (String)"Compass accuracy medium");
                    break;
                }
                case 3: {
                    Log.i((String)LCAT, (String)"Compass accuracy high");
                    break;
                }
                default: {
                    Log.w((String)LCAT, (String)("Unknown compass accuracy value: " + event.accuracy));
                }
            }
        }
        if (this.geomagneticField != null) {
            float trueHeading = x - this.geomagneticField.getDeclination();
            if (trueHeading < 0.0f) {
                trueHeading = 360.0f - trueHeading;
            }
            heading.put((Object)"trueHeading", (Object)Float.valueOf(trueHeading));
        }
        KrollDict data = new KrollDict();
        data.put((Object)"heading", (Object)heading);
        return data;
    }

    public boolean getHasCompass(KrollInvocation invocation) {
        boolean compass = false;
        SensorManager sensorManager = TiSensorHelper.getSensorManager();
        compass = sensorManager != null ? sensorManager.getDefaultSensor(3) != null : TiSensorHelper.hasDefaultSensor((Activity)this.geolocationModule.getTiContext().getActivity(), (int)3);
        return compass;
    }

    public void getCurrentHeading(KrollInvocation invocation, final KrollCallback listener) {
        if (listener != null) {
            Location location;
            Criteria criteria;
            SensorEventListener oneShotHeadingListener = new SensorEventListener(){

                public void onAccuracyChanged(Sensor sensor, int accuracy) {
                }

                public void onSensorChanged(SensorEvent event) {
                    if (event.sensor.getType() == 3) {
                        long eventTimestamp = event.timestamp / 1000000L;
                        long actualTimestamp = TiCompass.this.baseTime.getTimeInMillis() + (eventTimestamp - TiCompass.this.sensorTimerStart);
                        listener.callAsync(TiCompass.this.eventToKrollDict(event, actualTimestamp));
                        TiSensorHelper.unregisterListener((int)3, (SensorEventListener)this);
                    }
                }
            };
            LocationManager locationManager = TiLocationHelper.getLocationManager();
            String provider = locationManager.getBestProvider(criteria = new Criteria(), true);
            if (provider != null && (location = locationManager.getLastKnownLocation(provider)) != null) {
                this.geomagneticField = new GeomagneticField((float)location.getLatitude(), (float)location.getLongitude(), (float)location.getAltitude(), System.currentTimeMillis());
            }
            locationManager = null;
            TiSensorHelper.registerListener((int)3, (SensorEventListener)oneShotHeadingListener, (int)2);
        }
    }
}

