/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.geolocation;

import android.os.AsyncTask;
import android.os.Message;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.ContextSpecific;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.geolocation.TiCompass;
import ti.modules.titanium.geolocation.TiLocation;

@ContextSpecific
public class GeolocationModule
extends KrollModule {
    public static final int ACCURACY_BEST = 0;
    public static final int ACCURACY_NEAREST_TEN_METERS = 1;
    public static final int ACCURACY_HUNDRED_METERS = 2;
    public static final int ACCURACY_KILOMETER = 3;
    public static final int ACCURACY_THREE_KILOMETERS = 4;
    public static final String PROVIDER_GPS = "gps";
    public static final String PROVIDER_NETWORK = "network";
    public static final long MAX_GEO_ANALYTICS_FREQUENCY = 60000L;
    public static final int MSG_FIRST_ID = 1000;
    public static final int MSG_LOOKUP = 1100;
    public static final int MSG_LAST_ID = 1999;
    private static final String LCAT = "GeolocationModule";
    private static final boolean DBG = TiConfig.LOGD;
    private TiCompass tiCompass = new TiCompass(this);
    private TiLocation tiLocation = new TiLocation(this);
    private boolean compassRegistered = false;
    private boolean locationRegistered = false;

    public GeolocationModule(TiContext tiContext) {
        super(tiContext);
    }

    public int addEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if ("heading".equals(eventName)) {
            if (!this.compassRegistered) {
                this.tiCompass.registerListener();
                this.compassRegistered = true;
            }
        } else if ("location".equals(eventName) && !this.locationRegistered) {
            this.tiLocation.registerListener();
            this.locationRegistered = true;
        }
        return super.addEventListener(invocation, eventName, listener);
    }

    public void removeEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if ("heading".equals(eventName)) {
            if (this.compassRegistered) {
                this.tiCompass.unregisterListener();
                this.compassRegistered = false;
            }
        } else if ("location".equals(eventName) && this.locationRegistered) {
            this.tiLocation.unregisterListener();
            this.locationRegistered = false;
        }
        super.removeEventListener(invocation, eventName, listener);
    }

    public boolean getLocationServicesEnabled(KrollInvocation invocation) {
        return this.tiLocation.getLocationServicesEnabled(invocation);
    }

    public boolean getHasCompass(KrollInvocation invocation) {
        return this.tiCompass.getHasCompass(invocation);
    }

    public void getCurrentHeading(KrollInvocation invocation, KrollCallback listener) {
        this.tiCompass.getCurrentHeading(invocation, listener);
    }

    public void getCurrentPosition(KrollInvocation invocation, KrollCallback listener) {
        this.tiLocation.getCurrentPosition(invocation, listener);
    }

    public void forwardGeocoder(String address, KrollCallback listener) {
        this.tiLocation.forwardGeocoder(address, listener);
    }

    public void reverseGeocoder(double latitude, double longitude, KrollCallback callback) {
        this.tiLocation.reverseGeocoder(latitude, longitude, callback);
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1100) {
            AsyncTask<Object, Void, Integer> task = this.tiLocation.getLookUpTask();
            task.execute(new Object[]{msg.getData().getString("url"), msg.getData().getString("direction"), msg.obj});
            return true;
        }
        return super.handleMessage(msg);
    }
}

