/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.filesystem;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.filesystem.FileProxy;
import ti.modules.titanium.filesystem.FileStreamProxy;

public class FilesystemModule
extends KrollModule {
    private static final String LCAT = "TiFilesystem";
    private static final boolean DBG = TiConfig.LOGD;
    public static int MODE_READ = 0;
    public static int MODE_WRITE = 1;
    public static int MODE_APPEND = 2;
    private static String[] RESOURCES_DIR = new String[]{"app://"};

    public FilesystemModule(TiContext tiContext) {
        super(tiContext);
    }

    public FileProxy createTempFile() {
        try {
            File f = File.createTempFile("tifile", "tmp");
            String[] parts = new String[]{f.getAbsolutePath()};
            return new FileProxy(this.getTiContext(), parts, false);
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)("Unable to create tmp file: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public FileProxy createTempDirectory() {
        String dir = String.valueOf(System.currentTimeMillis());
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmpdir, dir);
        f.mkdirs();
        String[] parts = new String[]{f.getAbsolutePath()};
        return new FileProxy(this.getTiContext(), parts);
    }

    public boolean isExternalStoragePresent() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public FileProxy getFile(Object[] parts) {
        String[] sparts = TiConvert.toStringArray((Object[])parts);
        return new FileProxy(this.getTiContext(), sparts);
    }

    public FileProxy getApplicationDirectory() {
        return null;
    }

    public String getApplicationDataDirectory() {
        return "appdata-private://";
    }

    public String getResourcesDirectory() {
        return "app://";
    }

    public String getExternalStorageDirectory() {
        return "appdata://";
    }

    public String getSeparator() {
        return File.separator;
    }

    public String getLineEnding() {
        return System.getProperty("line.separator");
    }

    public FileStreamProxy openStream(int mode, Object[] parts) throws IOException {
        String[] sparts = TiConvert.toStringArray((Object[])parts);
        FileProxy fileProxy = new FileProxy(this.getTiContext(), sparts);
        fileProxy.tbf.open(mode, true);
        return new FileStreamProxy(fileProxy);
    }
}

