/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.io.TiStream;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiStreamHelper;
import ti.modules.titanium.BufferProxy;
import ti.modules.titanium.filesystem.FileProxy;

public class FileStreamProxy
extends KrollProxy
implements TiStream {
    private static final String LCAT = "FileStream";
    private static final boolean DBG = TiConfig.LOGD;
    private FileProxy fileProxy;
    private boolean isOpen = false;

    public FileStreamProxy(FileProxy fileProxy) {
        super(fileProxy.getTiContext());
        this.fileProxy = fileProxy;
        this.isOpen = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(Object[] args) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Unable to read from file, not open");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        try {
            return TiStreamHelper.read((InputStream)this.fileProxy.tbf.getExistingInputStream(), (BufferProxy)bufferProxy, (int)offset, (int)length);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Unable to read from file, IO error");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(Object[] args) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Unable to write to file, not open");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        try {
            return TiStreamHelper.write((OutputStream)this.fileProxy.tbf.getExistingOutputStream(), (BufferProxy)bufferProxy, (int)offset, (int)length);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Unable to write to file, IO error");
        }
    }

    public boolean isWritable() {
        return this.fileProxy.tbf.isOpen() && this.fileProxy.tbf.isWriteable();
    }

    public boolean isReadable() {
        return this.fileProxy.tbf.isOpen();
    }

    public void close() throws IOException {
        this.fileProxy.tbf.close();
        this.isOpen = false;
    }
}

