/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.filesystem;

import android.net.Uri;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFileProxy;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiFileHelper2;
import ti.modules.titanium.filesystem.FileStreamProxy;

public class FileProxy
extends TiFileProxy {
    private static final String LCAT = "FileProxy";
    protected String path;
    protected TiBaseFile tbf;

    public FileProxy(TiContext tiContext, String[] parts) {
        this(tiContext, parts, true);
    }

    public FileProxy(TiContext tiContext, String[] parts, boolean resolve) {
        super(tiContext);
        String scheme = "appdata-private://";
        String path = null;
        Uri uri = Uri.parse((String)parts[0]);
        if (uri.getScheme() != null) {
            scheme = uri.getScheme() + ":";
            ArrayList<String> pb = new ArrayList<String>();
            String s = parts[0].substring(scheme.length() + 2);
            if (s != null && s.length() > 0) {
                pb.add(s);
            }
            for (int i = 1; i < parts.length; ++i) {
                pb.add(parts[i]);
            }
            String[] newParts = pb.toArray(new String[pb.size()]);
            path = TiFileHelper2.joinSegments((String[])newParts);
            if (!path.startsWith("..") || !path.startsWith("/")) {
                path = "/" + path;
            }
            pb.clear();
        } else {
            path = TiFileHelper2.joinSegments((String[])parts);
        }
        if (resolve) {
            path = this.getTiContext().resolveUrl(scheme, path);
        }
        this.tbf = TiFileFactory.createTitaniumFile((TiContext)tiContext, (String[])new String[]{path}, (boolean)false);
    }

    private FileProxy(TiContext tiContext, TiBaseFile tbf) {
        super(tiContext);
        this.tbf = tbf;
    }

    public static <T> String join(Collection<T> objs, String delimiter) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public TiBaseFile getBaseFile() {
        return this.tbf;
    }

    public boolean isFile() {
        return this.tbf.isFile();
    }

    public boolean isDirectory() {
        return this.tbf.isDirectory();
    }

    public boolean getReadonly() {
        return this.tbf.isReadonly();
    }

    public boolean getWritable() {
        return this.tbf.isWriteable();
    }

    public boolean copy(String destination) throws IOException {
        return this.tbf.copy(destination);
    }

    public boolean createDirectory(@Kroll.argument(optional=true) Object arg) {
        boolean recursive = true;
        if (arg != null) {
            recursive = TiConvert.toBoolean((Object)arg);
        }
        return this.tbf.createDirectory(recursive);
    }

    public boolean deleteDirectory(@Kroll.argument(optional=true) Object arg) {
        boolean recursive = false;
        if (arg != null) {
            recursive = TiConvert.toBoolean((Object)arg);
        }
        return this.tbf.deleteDirectory(recursive);
    }

    public boolean deleteFile() {
        return this.tbf.deleteFile();
    }

    public boolean exists() {
        return this.tbf.exists();
    }

    public String extension() {
        return this.tbf.extension();
    }

    public boolean getSymbolicLink() {
        return this.tbf.isSymbolicLink();
    }

    public boolean getExecutable() {
        return this.tbf.isExecutable();
    }

    public boolean getHidden() {
        return this.tbf.isHidden();
    }

    public String[] getDirectoryListing() {
        List dl = this.tbf.getDirectoryListing();
        return dl != null ? dl.toArray(new String[0]) : null;
    }

    public FileProxy getParent() {
        TiBaseFile bf = this.tbf.getParent();
        return bf != null ? new FileProxy(this.getTiContext(), bf) : null;
    }

    public boolean move(String destination) throws IOException {
        return this.tbf.move(destination);
    }

    public String getName() {
        return this.tbf.name();
    }

    public String getNativePath() {
        return this.tbf.nativePath();
    }

    public TiBlob read() throws IOException {
        return this.tbf.read();
    }

    public String readLine() throws IOException {
        return this.tbf.readLine();
    }

    public boolean rename(String destination) {
        return this.tbf.rename(destination);
    }

    public TiBaseFile resolve() {
        return this.tbf.resolve();
    }

    public double getSize() {
        return this.tbf.size();
    }

    public double spaceAvailable() {
        return this.tbf.spaceAvailable();
    }

    public boolean write(Object[] args) {
        try {
            if (args != null && args.length > 0) {
                boolean append = false;
                if (args.length > 1 && args[1] instanceof Boolean) {
                    append = (Boolean)args[1];
                }
                if (args[0] instanceof TiBlob) {
                    this.tbf.write((TiBlob)args[0], append);
                } else if (args[0] instanceof String) {
                    this.tbf.write((String)args[0], append);
                } else if (args[0] instanceof FileProxy) {
                    this.tbf.write(((FileProxy)((Object)args[0])).read(), append);
                } else {
                    Log.i((String)LCAT, (String)"unable to write, unrecognized type");
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)"IOException encountered");
            return false;
        }
    }

    public void writeLine(String data) throws IOException {
        this.tbf.writeLine(data);
    }

    public double createTimestamp() {
        return this.tbf.createTimestamp();
    }

    public double modificationTimestamp() {
        return this.tbf.modificationTimestamp();
    }

    public FileStreamProxy open(int mode) throws IOException {
        if (!this.tbf.isOpen()) {
            this.tbf.open(mode, true);
        }
        return new FileStreamProxy(this);
    }
}

