/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.facebook;

import com.facebook.android.AsyncFacebookRunner;
import com.facebook.android.FacebookError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;

public class TiRequestListener
implements AsyncFacebookRunner.RequestListener {
    private boolean isGraphApiCall;
    private String callPath;
    private KrollCallback callback;

    public TiRequestListener(String callPath, boolean isGraphApiCall, KrollCallback callback) {
        this.callback = callback;
        this.callPath = callPath;
        this.isGraphApiCall = isGraphApiCall;
    }

    private KrollDict buildEventArgs(boolean success) {
        KrollDict d = new KrollDict();
        d.put((Object)"graph", (Object)this.isGraphApiCall);
        if (this.isGraphApiCall) {
            d.put((Object)"path", (Object)this.callPath);
        } else {
            d.put((Object)"method", (Object)this.callPath);
        }
        d.put((Object)"success", (Object)success);
        return d;
    }

    private KrollDict buildEventArgs(boolean success, Throwable t) {
        KrollDict d = this.buildEventArgs(success);
        d.put((Object)"error", (Object)t.getLocalizedMessage());
        return d;
    }

    private KrollDict buildEventArgs(boolean success, String result) {
        KrollDict d = this.buildEventArgs(success);
        d.put((Object)"result", (Object)result);
        return d;
    }

    private void complete(Throwable t) {
        Log.e((String)"FacebookModule", (String)("Request error for '" + this.callPath + "' call: " + t.getLocalizedMessage()), (Throwable)t);
        this.doCallback(this.buildEventArgs(false, t));
    }

    private void complete(String result) {
        this.doCallback(this.buildEventArgs(true, result));
    }

    private void doCallback(KrollDict args) {
        if (this.callback != null) {
            this.callback.callAsync(args);
        }
    }

    @Override
    public void onComplete(String result) {
        this.complete(result);
    }

    @Override
    public void onFacebookError(FacebookError e) {
        this.complete(e);
    }

    @Override
    public void onFileNotFoundException(FileNotFoundException e) {
        this.complete(e);
    }

    @Override
    public void onIOException(IOException e) {
        this.complete(e);
    }

    @Override
    public void onMalformedURLException(MalformedURLException e) {
        this.complete(e);
    }
}

