/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.facebook;

import android.os.Bundle;
import com.facebook.android.DialogError;
import com.facebook.android.Facebook;
import com.facebook.android.FacebookError;
import com.facebook.android.Util;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;

public class TiDialogListener
implements Facebook.DialogListener {
    private KrollCallback callback;
    private String dialogAction;

    public TiDialogListener(KrollCallback callback, String dialogAction) {
        this.callback = callback;
        this.dialogAction = dialogAction;
    }

    private KrollDict buildEventArgs(Status status) {
        KrollDict d = new KrollDict();
        d.put((Object)"success", (Object)(status == Status.SUCCESS ? 1 : 0));
        d.put((Object)"cancelled", (Object)(status == Status.CANCEL ? 1 : 0));
        return d;
    }

    private KrollDict buildEventArgs(Throwable t) {
        KrollDict d = this.buildEventArgs(Status.ERROR);
        d.put((Object)"error", (Object)t.getLocalizedMessage());
        return d;
    }

    private KrollDict buildEventArgs(String result) {
        KrollDict d = this.buildEventArgs(Status.SUCCESS);
        d.put((Object)"result", (Object)result);
        return d;
    }

    private void complete(Throwable t) {
        Log.e((String)"FacebookModule", (String)("Dialog error for '" + this.dialogAction + "' call: " + t.getLocalizedMessage()), (Throwable)t);
        this.doCallback(this.buildEventArgs(t));
    }

    private void complete(String result) {
        this.doCallback(this.buildEventArgs(result));
    }

    private void doCallback(KrollDict args) {
        if (this.callback != null) {
            this.callback.callAsync(args);
        }
    }

    @Override
    public void onComplete(Bundle values) {
        String stringVals = "";
        if (values != null && values.size() > 0) {
            stringVals = Util.encodeUrl(values);
        }
        this.complete(stringVals);
    }

    @Override
    public void onFacebookError(FacebookError e) {
        this.complete(e);
    }

    @Override
    public void onError(DialogError e) {
        this.complete(e);
    }

    @Override
    public void onCancel() {
        Log.d((String)"FacebookModule-Dialog", (String)"Dialog canceled");
        this.doCallback(this.buildEventArgs(Status.CANCEL));
    }

    private static enum Status {
        ERROR,
        CANCEL,
        SUCCESS;

    }
}

