/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import ti.modules.titanium.facebook.FacebookModule;

public class SessionStore {
    private static final String TOKEN = "FBAccessToken";
    private static final String EXPIRES = "FBSessionExpires";
    private static final String UID = "FBUserId";
    private static final String APPID = "FBAppId";
    private static final String KEY = "facebook-session";

    public static boolean save(FacebookModule fbmod, Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(KEY, 0).edit();
        editor.putString(TOKEN, fbmod.facebook.getAccessToken());
        editor.putLong(EXPIRES, fbmod.facebook.getAccessExpires());
        editor.putString(UID, fbmod.uid);
        editor.putString(APPID, fbmod.getAppid());
        return editor.commit();
    }

    public static boolean restore(FacebookModule fbmod, Context context) {
        SharedPreferences savedSession = context.getSharedPreferences(KEY, 0);
        fbmod.facebook.setAccessToken(savedSession.getString(TOKEN, null));
        fbmod.facebook.setAccessExpires(savedSession.getLong(EXPIRES, 0L));
        fbmod.uid = savedSession.getString(UID, null);
        fbmod.setAppid(savedSession.getString(APPID, null));
        return fbmod.facebook.isSessionValid();
    }

    public static void clear(Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(KEY, 0).edit();
        editor.clear();
        editor.commit();
    }

    public static String getSavedAppId(Context context) {
        SharedPreferences savedSession = context.getSharedPreferences(KEY, 0);
        return savedSession.getString(APPID, null);
    }
}

