/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.StateSet;
import android.view.View;
import android.widget.ImageButton;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.facebook.FacebookModule;
import ti.modules.titanium.facebook.TiFacebookModuleLoginButtonProxy;
import ti.modules.titanium.facebook.TiFacebookStateListener;

public class LoginButton
extends TiUIView
implements TiFacebookStateListener {
    private static final String LCAT = "TiLoginButton";
    private static final int FB_BLUE = -9599820;
    private FacebookModule facebook = null;
    private boolean wide;
    private int mLoginId = -1;
    private int mLoginWideId = -1;
    private int mLoginPressedId = -1;
    private int mLoginWidePressedId = -1;
    private int mLogoutId = -1;
    private int mLogoutPressedId = -1;

    public LoginButton(TiViewProxy proxy) {
        super(proxy);
        this.initFacebook();
        this.discoverResourceIds(proxy.getContext());
        ImageButton btn = new ImageButton(proxy.getContext()){

            protected void drawableStateChanged() {
                super.drawableStateChanged();
                int[] states = this.getDrawableState();
                if (StateSet.stateSetMatches((int[])new int[]{16842919}, (int[])states) || StateSet.stateSetMatches((int[])new int[]{16842908}, (int[])states)) {
                    LoginButton.this.updateButtonImage(true);
                } else {
                    LoginButton.this.updateButtonImage(false);
                }
            }
        };
        this.setNativeView((View)btn);
        btn.setBackgroundColor(0);
        this.updateButtonImage(false);
    }

    private void initFacebook() {
        this.facebook = ((TiFacebookModuleLoginButtonProxy)this.getProxy()).getFacebookModule();
    }

    protected void updateButtonImage(boolean pressed) {
        if (this.getProxy().getTiContext().isUIThread()) {
            this.handleUpdateButtonImage(pressed);
        } else {
            final boolean fPressed = pressed;
            this.getProxy().getTiContext().getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LoginButton.this.handleUpdateButtonImage(fPressed);
                }
            });
        }
    }

    private void handleUpdateButtonImage(boolean pressed) {
        String stateDescription;
        boolean loggedIn = this.facebook.loggedIn();
        int resid = 0;
        if (loggedIn) {
            if (pressed) {
                resid = this.mLogoutPressedId;
                stateDescription = "logged-in and button pressed";
            } else {
                resid = this.mLogoutId;
                stateDescription = "logged-in, button not pressed";
            }
        } else if (this.wide) {
            if (pressed) {
                resid = this.mLoginWidePressedId;
                stateDescription = "not logged-in, using wide button, button is pressed";
            } else {
                resid = this.mLoginWideId;
                stateDescription = "not logged-in, using wide button, button is not pressed";
            }
        } else if (pressed) {
            resid = this.mLoginPressedId;
            stateDescription = "not logged-in, using narrow button, button is pressed";
        } else {
            resid = this.mLoginId;
            stateDescription = "not logged-in, using narrow button, button is not pressed";
        }
        ImageButton btn = (ImageButton)this.getNativeView();
        if (btn == null) {
            return;
        }
        if (resid > 0) {
            btn.setBackgroundColor(0);
            btn.setImageResource(resid);
        } else {
            Log.w((String)LCAT, (String)("Facebook resource image could not be located!  State: " + stateDescription));
            btn.setBackgroundColor(-9599820);
        }
    }

    public void processProperties(KrollDict d) {
        String style;
        super.processProperties(d);
        this.facebook.addListener(this);
        if (d.containsKey((Object)"style") && (style = TiConvert.toString((KrollDict)d, (String)"style")).equals("wide")) {
            this.wide = true;
            this.updateButtonImage(false);
        }
    }

    @Override
    public void login() {
        this.updateButtonImage(false);
    }

    @Override
    public void logout() {
        this.updateButtonImage(false);
    }

    public void release() {
        super.release();
        if (this.facebook != null) {
            this.facebook.removeListener(this);
        }
    }

    protected void setOnClickListener(View view) {
        if (view == this.nativeView) {
            final ImageButton btn = (ImageButton)view;
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    Activity activity = null;
                    if (btn.getContext() instanceof Activity) {
                        activity = (Activity)btn.getContext();
                    } else {
                        Context context = LoginButton.this.getProxy().getContext();
                        if (context instanceof Activity) {
                            activity = (Activity)context;
                        }
                    }
                    if (activity == null && LoginButton.this.getProxy().getTiContext() != null) {
                        activity = LoginButton.this.getProxy().getTiContext().getRootActivity();
                    }
                    if (LoginButton.this.facebook.loggedIn()) {
                        LoginButton.this.facebook.executeLogout(activity);
                    } else {
                        LoginButton.this.facebook.executeAuthorize(activity);
                    }
                }
            });
        }
    }

    private void discoverResourceIds(Context context) {
        String packageName = context.getPackageName();
        Resources resources = context.getResources();
        this.mLoginId = resources.getIdentifier("facebook_login", "drawable", packageName);
        this.mLoginPressedId = resources.getIdentifier("facebook_login_down", "drawable", packageName);
        this.mLoginWideId = resources.getIdentifier("facebook_login_wide", "drawable", packageName);
        this.mLoginWidePressedId = resources.getIdentifier("facebook_login_wide_down", "drawable", packageName);
        this.mLogoutId = resources.getIdentifier("facebook_logout", "drawable", packageName);
        this.mLogoutPressedId = resources.getIdentifier("facebook_logout_down", "drawable", packageName);
    }
}

