/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.facebook.android.AsyncFacebookRunner;
import com.facebook.android.DialogError;
import com.facebook.android.Facebook;
import com.facebook.android.FacebookError;
import com.facebook.android.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.json.JSONException;
import org.json.JSONObject;
import ti.modules.titanium.facebook.SessionEvents;
import ti.modules.titanium.facebook.SessionListener;
import ti.modules.titanium.facebook.SessionStore;
import ti.modules.titanium.facebook.TiDialogListener;
import ti.modules.titanium.facebook.TiFacebookModuleLoginButtonProxy;
import ti.modules.titanium.facebook.TiFacebookStateListener;
import ti.modules.titanium.facebook.TiRequestListener;
import ti.modules.titanium.facebook.Utils;

public class FacebookModule
extends KrollModule {
    protected static final String LCAT = "FacebookModule";
    protected static final boolean DBG = TiConfig.LOGD;
    protected Facebook facebook = null;
    private boolean loggedIn = false;
    private ArrayList<TiFacebookStateListener> stateListeners = new ArrayList();
    private SessionListener sessionListener = null;
    private AsyncFacebookRunner fbrunner;
    private String appid = null;
    protected String uid = null;
    private String[] permissions = new String[0];
    private boolean forceDialogAuth = true;

    public FacebookModule(TiContext tiContext) {
        super(tiContext);
        this.sessionListener = new SessionListener(this);
        SessionEvents.addAuthListener(this.sessionListener);
        SessionEvents.addLogoutListener(this.sessionListener);
        this.debug("FacebookModule()");
        this.appid = SessionStore.getSavedAppId((Context)tiContext.getTiApp());
        if (this.appid != null) {
            this.debug("Attempting session restore for appid " + this.appid);
            this.facebook = new Facebook(this.appid);
            SessionStore.restore(this, (Context)tiContext.getTiApp());
            if (this.facebook.isSessionValid()) {
                this.debug("Session restore succeeded.  Now logged in.");
                this.loggedIn = true;
            } else {
                this.debug("Session restore failed.  Not logged in.");
                this.loggedIn = false;
            }
        }
    }

    public boolean loggedIn() {
        return this.isLoggedIn();
    }

    public String accessToken() {
        if (this.facebook != null) {
            return this.facebook.getAccessToken();
        }
        return null;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        if (this.appid != null && !this.appid.equals(appid) && this.facebook != null && this.facebook.isSessionValid()) {
            Log.w((String)LCAT, (String)"Appid was changed while session active.  Removing session info.");
            this.destroyFacebookSession();
            this.facebook = null;
        }
        this.appid = appid;
        if (this.facebook == null || !this.facebook.getAppId().equals(appid)) {
            this.facebook = new Facebook(appid);
        }
    }

    public String getUid() {
        return this.uid;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    public Date expirationDate() {
        if (this.facebook != null) {
            return TiConvert.toDate((Object)this.facebook.getAccessExpires());
        }
        return new Date(0L);
    }

    public boolean getForceDialogAuth() {
        return this.forceDialogAuth;
    }

    public void setForceDialogAuth(boolean value) {
        this.forceDialogAuth = value;
    }

    public TiFacebookModuleLoginButtonProxy createLoginButton(KrollInvocation invocation, @Kroll.argument(optional=true) KrollDict options) {
        TiFacebookModuleLoginButtonProxy login = new TiFacebookModuleLoginButtonProxy(invocation.getTiContext(), this);
        if (options != null) {
            login.extend(options);
        }
        return login;
    }

    public void authorize(KrollInvocation invocation) {
        this.debug("authorize; permissions.length == " + this.permissions.length);
        if (this.isLoggedIn()) {
            this.debug("Already logged in, ignoring authorize() request");
            return;
        }
        if (this.appid == null) {
            Log.w((String)LCAT, (String)"authorize() called without appid being set; throwing...");
            throw new IllegalStateException("missing appid");
        }
        SessionStore.clear((Context)this.context.getTiApp());
        if (this.facebook == null) {
            this.facebook = new Facebook(this.appid);
        }
        this.executeAuthorize(invocation.getActivity());
    }

    public void logout(KrollInvocation invocation) {
        boolean wasLoggedIn = this.isLoggedIn();
        this.destroyFacebookSession();
        if (this.facebook != null && wasLoggedIn) {
            SessionEvents.onLogoutBegin();
            this.executeLogout(invocation.getActivity());
        }
    }

    public void requestWithGraphPath(String path, KrollDict params, String httpMethod, KrollCallback callback) {
        if (this.facebook == null) {
            Log.w((String)LCAT, (String)"requestWithGraphPath called without Facebook being instantiated.  Have you set appid?");
            return;
        }
        AsyncFacebookRunner runner = this.getFBRunner();
        Bundle paramBundle = Utils.mapToBundle((Map<String, Object>)params);
        if (httpMethod == null || httpMethod.length() == 0) {
            httpMethod = "GET";
        }
        runner.request(path, paramBundle, httpMethod.toUpperCase(), new TiRequestListener(path, true, callback));
    }

    public void request(String method, KrollDict params, KrollCallback callback) {
        Bundle bundle;
        if (this.facebook == null) {
            Log.w((String)LCAT, (String)"request called without Facebook being instantiated.  Have you set appid?");
            return;
        }
        String httpMethod = "GET";
        if (params != null) {
            for (Object v : params.values()) {
                if (!(v instanceof TiBlob) && !(v instanceof TiBaseFile)) continue;
                httpMethod = "POST";
                break;
            }
        }
        if (!(bundle = Utils.mapToBundle((Map<String, Object>)params)).containsKey("method")) {
            bundle.putString("method", method);
        }
        this.getFBRunner().request(null, bundle, httpMethod, new TiRequestListener(method, false, callback));
    }

    public void dialog(KrollInvocation invocation, String action, KrollDict params, KrollCallback callback) {
        if (this.facebook == null) {
            Log.w((String)LCAT, (String)"dialog called without Facebook being instantiated.  Have you set appid?");
            return;
        }
        this.facebook.dialog((Context)invocation.getActivity(), action, Utils.mapToBundle((Map<String, Object>)params), new TiDialogListener(callback, action));
    }

    protected void completeLogin() {
        this.getFBRunner().request("me", new AsyncFacebookRunner.RequestListener(){

            @Override
            public void onMalformedURLException(MalformedURLException e) {
                FacebookModule.this.loginError(e);
            }

            @Override
            public void onIOException(IOException e) {
                FacebookModule.this.loginError(e);
            }

            @Override
            public void onFileNotFoundException(FileNotFoundException e) {
                FacebookModule.this.loginError(e);
            }

            @Override
            public void onFacebookError(FacebookError e) {
                FacebookModule.this.loginError(e);
            }

            @Override
            public void onComplete(String response) {
                try {
                    FacebookModule.this.debug("onComplete (getting 'me'): " + response);
                    JSONObject json = Util.parseJson(response);
                    FacebookModule.this.uid = json.getString("id");
                    FacebookModule.this.loggedIn = true;
                    SessionStore.save(FacebookModule.this, (Context)FacebookModule.this.context.getTiApp());
                    KrollDict data = new KrollDict();
                    data.put((Object)"cancelled", (Object)false);
                    data.put((Object)"success", (Object)true);
                    data.put((Object)"uid", (Object)FacebookModule.this.uid);
                    data.put((Object)"data", (Object)response);
                    FacebookModule.this.fireLoginChange();
                    FacebookModule.this.fireEvent("login", data);
                }
                catch (JSONException e) {
                    Log.e((String)FacebookModule.LCAT, (String)e.getMessage(), (Throwable)e);
                }
                catch (FacebookError e) {
                    Log.e((String)FacebookModule.LCAT, (String)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    protected void completeLogout() {
        this.destroyFacebookSession();
        this.fireLoginChange();
        this.fireEvent("logout", new KrollDict());
    }

    protected void debug(String message) {
        if (DBG) {
            Log.d((String)LCAT, (String)message);
        }
    }

    protected void addListener(TiFacebookStateListener listener) {
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    protected void removeListener(TiFacebookStateListener listener) {
        this.stateListeners.remove(listener);
    }

    protected void executeAuthorize(Activity activity) {
        int activityCode = -1;
        if (this.forceDialogAuth) {
            this.facebook.authorize(activity, this.permissions, activityCode, new LoginDialogListener());
        } else {
            TiActivitySupport activitySupport = (TiActivitySupport)activity;
            activityCode = activitySupport.getUniqueResultCode();
            TiActivityResultHandler resultHandler = new TiActivityResultHandler(){

                public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
                    if (DBG) {
                        Log.d((String)FacebookModule.LCAT, (String)("onResult from Facebook single sign-on attempt. resultCode: " + resultCode));
                    }
                    FacebookModule.this.facebook.authorizeCallback(requestCode, resultCode, data);
                }

                public void onError(Activity activity, int requestCode, Exception e) {
                    Log.e((String)FacebookModule.LCAT, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            };
            this.facebook.authorize(activity, activitySupport, this.permissions, activityCode, new LoginDialogListener(), resultHandler);
        }
    }

    protected void executeLogout(Activity activity) {
        this.getFBRunner().logout((Context)activity, new LogoutRequestListener());
    }

    private boolean isLoggedIn() {
        return this.loggedIn && this.facebook != null && this.facebook.isSessionValid();
    }

    private void loginError(Throwable t) {
        Log.e((String)LCAT, (String)t.getMessage(), (Throwable)t);
        this.loggedIn = false;
        KrollDict data = new KrollDict();
        data.put((Object)"cancelled", (Object)false);
        data.put((Object)"success", (Object)false);
        data.put((Object)"error", (Object)t.getMessage());
        this.fireEvent("login", data);
    }

    private void loginCancel() {
        this.debug("login canceled");
        this.loggedIn = false;
        KrollDict data = new KrollDict();
        data.put((Object)"cancelled", (Object)true);
        data.put((Object)"success", (Object)false);
        this.fireEvent("login", data);
    }

    private AsyncFacebookRunner getFBRunner() {
        if (this.fbrunner == null) {
            this.fbrunner = new AsyncFacebookRunner(this.facebook);
        }
        return this.fbrunner;
    }

    private void destroyFacebookSession() {
        SessionStore.clear((Context)this.context.getTiApp());
        this.uid = null;
        this.loggedIn = false;
    }

    private void fireLoginChange() {
        for (TiFacebookStateListener listener : this.stateListeners) {
            if (this.loggedIn()) {
                listener.login();
                continue;
            }
            listener.logout();
        }
    }

    public void onDestroy(Activity activity) {
        super.onDestroy(activity);
        if (this.sessionListener != null) {
            SessionEvents.removeAuthListener(this.sessionListener);
            SessionEvents.removeLogoutListener(this.sessionListener);
            this.sessionListener = null;
        }
    }

    private final class LogoutRequestListener
    implements AsyncFacebookRunner.RequestListener {
        private LogoutRequestListener() {
        }

        @Override
        public void onComplete(String response) {
            FacebookModule.this.debug("Logout request complete: " + response);
            SessionEvents.onLogoutFinish();
        }

        @Override
        public void onFacebookError(FacebookError e) {
            Log.e((String)FacebookModule.LCAT, (String)("Logout failure: " + e.getMessage()), (Throwable)e);
        }

        @Override
        public void onFileNotFoundException(FileNotFoundException e) {
            Log.e((String)FacebookModule.LCAT, (String)("Logout failure: " + e.getMessage()), (Throwable)e);
        }

        @Override
        public void onIOException(IOException e) {
            Log.e((String)FacebookModule.LCAT, (String)("Logout failure: " + e.getMessage()), (Throwable)e);
        }

        @Override
        public void onMalformedURLException(MalformedURLException e) {
            Log.e((String)FacebookModule.LCAT, (String)("Logout failure: " + e.getMessage()), (Throwable)e);
        }
    }

    private final class LoginDialogListener
    implements Facebook.DialogListener {
        private LoginDialogListener() {
        }

        @Override
        public void onComplete(Bundle values) {
            FacebookModule.this.debug("LoginDialogListener onComplete");
            SessionEvents.onLoginSuccess();
        }

        @Override
        public void onFacebookError(FacebookError error) {
            Log.e((String)FacebookModule.LCAT, (String)("LoginDialogListener onFacebookError: " + error.getMessage()), (Throwable)error);
            SessionEvents.onLoginError(error.getMessage());
        }

        @Override
        public void onError(DialogError error) {
            Log.e((String)FacebookModule.LCAT, (String)("LoginDialogListener onError: " + error.getMessage()), (Throwable)error);
            SessionEvents.onLoginError(error.getMessage());
        }

        @Override
        public void onCancel() {
            FacebookModule.this.loginCancel();
        }
    }
}

