/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.android;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.android.DialogError;
import com.facebook.android.Facebook;
import com.facebook.android.FacebookError;
import com.facebook.android.Util;

public class FbDialog
extends Dialog {
    static final int FB_BLUE = -9599820;
    static final float[] DIMENSIONS_LANDSCAPE = new float[]{460.0f, 260.0f};
    static final float[] DIMENSIONS_PORTRAIT = new float[]{280.0f, 420.0f};
    static final FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
    static final int MARGIN = 4;
    static final int PADDING = 2;
    static final String DISPLAY_STRING = "touch";
    static final String FB_ICON = "icon.png";
    private String mUrl;
    private Facebook.DialogListener mListener;
    private ProgressDialog mSpinner;
    private WebView mWebView;
    private LinearLayout mContent;
    private TextView mTitle;
    private int mIconId = -1;

    public FbDialog(Context context, String url, Facebook.DialogListener listener) {
        super(context);
        this.mUrl = url;
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSpinner = new ProgressDialog(this.getContext());
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage((CharSequence)"Loading...");
        this.mContent = new LinearLayout(this.getContext());
        this.mContent.setOrientation(1);
        this.setUpTitle();
        this.setUpWebView();
        Display display = this.getWindow().getWindowManager().getDefaultDisplay();
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        float[] dimensions = display.getWidth() < display.getHeight() ? DIMENSIONS_PORTRAIT : DIMENSIONS_LANDSCAPE;
        this.addContentView((View)this.mContent, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams((int)(dimensions[0] * scale + 0.5f), (int)(dimensions[1] * scale + 0.5f)));
    }

    private void setUpTitle() {
        this.requestWindowFeature(1);
        Drawable icon = null;
        if (this.mIconId == -1) {
            this.mIconId = this.getContext().getResources().getIdentifier("facebook_icon", "drawable", this.getContext().getPackageName());
        }
        if (this.mIconId > 0) {
            icon = this.getContext().getResources().getDrawable(this.mIconId);
        }
        this.mTitle = new TextView(this.getContext());
        this.mTitle.setText((CharSequence)"Facebook");
        this.mTitle.setTextColor(-1);
        this.mTitle.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTitle.setBackgroundColor(-9599820);
        this.mTitle.setPadding(6, 4, 4, 4);
        this.mTitle.setCompoundDrawablePadding(6);
        if (icon != null) {
            this.mTitle.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
            this.mContent.addView((View)this.mTitle);
        }
    }

    private void setUpWebView() {
        this.mWebView = new WebView(this.getContext());
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setWebViewClient((WebViewClient)new FbWebViewClient());
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.loadUrl(this.mUrl);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)FILL);
        this.mContent.addView((View)this.mWebView);
    }

    private class FbWebViewClient
    extends WebViewClient {
        private FbWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.d((String)"Facebook-WebView", (String)("Redirect URL: " + url));
            if (url.startsWith("fbconnect://success")) {
                Bundle values = Util.parseUrl(url);
                String error = values.getString("error");
                if (error == null) {
                    error = values.getString("error_type");
                }
                if (error == null) {
                    FbDialog.this.mListener.onComplete(values);
                } else if (error.equals("access_denied") || error.equals("OAuthAccessDeniedException")) {
                    FbDialog.this.mListener.onCancel();
                } else {
                    FbDialog.this.mListener.onFacebookError(new FacebookError(error));
                }
                FbDialog.this.dismiss();
                return true;
            }
            if (url.startsWith("fbconnect://cancel")) {
                FbDialog.this.mListener.onCancel();
                FbDialog.this.dismiss();
                return true;
            }
            if (url.contains(FbDialog.DISPLAY_STRING)) {
                return false;
            }
            FbDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            FbDialog.this.mListener.onError(new DialogError(description, errorCode, failingUrl));
            FbDialog.this.dismiss();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Log.d((String)"Facebook-WebView", (String)("Webview loading URL: " + url));
            super.onPageStarted(view, url, favicon);
            FbDialog.this.mSpinner.show();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            String title = FbDialog.this.mWebView.getTitle();
            if (title != null && title.length() > 0) {
                FbDialog.this.mTitle.setText((CharSequence)title);
            }
            FbDialog.this.mSpinner.dismiss();
        }
    }
}

