/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.android;

import android.content.Context;
import android.os.Bundle;
import com.facebook.android.Facebook;
import com.facebook.android.FacebookError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;

public class AsyncFacebookRunner {
    Facebook fb;

    public AsyncFacebookRunner(Facebook fb) {
        this.fb = fb;
    }

    public void logout(final Context context, final RequestListener listener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String response = AsyncFacebookRunner.this.fb.logout(context);
                    if (response.length() == 0 || response.equals("false")) {
                        listener.onFacebookError(new FacebookError("auth.expireSession failed"));
                        return;
                    }
                    listener.onComplete(response);
                }
                catch (FileNotFoundException e) {
                    listener.onFileNotFoundException(e);
                }
                catch (MalformedURLException e) {
                    listener.onMalformedURLException(e);
                }
                catch (IOException e) {
                    listener.onIOException(e);
                }
            }
        }.start();
    }

    public void request(Bundle parameters, RequestListener listener) {
        this.request(null, parameters, "GET", listener);
    }

    public void request(String graphPath, RequestListener listener) {
        this.request(graphPath, new Bundle(), "GET", listener);
    }

    public void request(String graphPath, Bundle parameters, RequestListener listener) {
        this.request(graphPath, parameters, "GET", listener);
    }

    public void request(final String graphPath, final Bundle parameters, final String httpMethod, final RequestListener listener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String resp = AsyncFacebookRunner.this.fb.request(graphPath, parameters, httpMethod);
                    listener.onComplete(resp);
                }
                catch (FileNotFoundException e) {
                    listener.onFileNotFoundException(e);
                }
                catch (MalformedURLException e) {
                    listener.onMalformedURLException(e);
                }
                catch (IOException e) {
                    listener.onIOException(e);
                }
            }
        }.start();
    }

    public static interface RequestListener {
        public void onComplete(String var1);

        public void onIOException(IOException var1);

        public void onFileNotFoundException(FileNotFoundException var1);

        public void onMalformedURLException(MalformedURLException var1);

        public void onFacebookError(FacebookError var1);
    }
}

