/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.database;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.database.SQLException;
import android.os.Build;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;

public class TiResultSetProxy
extends KrollProxy {
    private static final String LCAT = "TiResultSet";
    private static final boolean DBG = TiConfig.LOGD;
    private static Method isFloat = null;
    private static Method isLong = null;
    private static Method isNull = null;
    private static Class[] args;
    protected Cursor rs;
    protected String lastException;
    protected HashMap<String, Integer> columnNames;

    public TiResultSetProxy(TiContext tiContext, Cursor rs) {
        super(tiContext);
        this.rs = rs;
        String[] names = rs.getColumnNames();
        this.columnNames = new HashMap(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.columnNames.put(names[i].toLowerCase(), i);
        }
    }

    public void close() {
        if (this.rs != null && !this.rs.isClosed()) {
            if (DBG) {
                Log.d((String)LCAT, (String)"Closing database cursor");
            }
            this.rs.close();
        } else {
            Log.w((String)LCAT, (String)"Calling close on a closed cursor.");
        }
    }

    public Object field(Object[] args) {
        return this.internalGetField(args);
    }

    public Object getField(Object[] args) {
        return this.internalGetField(args);
    }

    private Object internalGetField(Object[] args) {
        int index = -1;
        int type = -1;
        if (args.length >= 1) {
            if (args[0] instanceof Number) {
                index = TiConvert.toInt((Object)args[0]);
            } else {
                new IllegalArgumentException("Expected int column index as first parameter was " + args[0].getClass().getSimpleName()).printStackTrace();
                throw new IllegalArgumentException("Expected int column index as first parameter was " + args[0].getClass().getSimpleName());
            }
        }
        if (args.length == 2) {
            if (args[1] instanceof Number) {
                type = TiConvert.toInt((Object)args[1]);
            } else {
                throw new IllegalArgumentException("Expected int field type as second parameter was " + args[1].getClass().getSimpleName());
            }
        }
        return this.internalGetField(index, type);
    }

    private Object internalGetField(int index, int type) {
        Object result = null;
        if (this.rs != null) {
            try {
                boolean fromString = true;
                if (isNull != null && this.rs instanceof AbstractWindowedCursor) {
                    AbstractWindowedCursor awc = (AbstractWindowedCursor)this.rs;
                    Object[] arguments = new Object[]{index};
                    try {
                        if (((Boolean)isFloat.invoke((Object)awc, arguments)).booleanValue()) {
                            result = awc.getDouble(index);
                            fromString = false;
                        } else if (((Boolean)isLong.invoke((Object)awc, arguments)).booleanValue()) {
                            result = awc.getLong(index);
                            fromString = false;
                        } else if (((Boolean)isNull.invoke((Object)awc, arguments)).booleanValue()) {
                            result = null;
                            fromString = false;
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)LCAT, (String)"Error querying type from cursor", (Throwable)e);
                    }
                }
                if (fromString) {
                    result = this.rs.getString(index);
                }
            }
            catch (SQLException e) {
                String msg = "No field at index " + index + ". msg=" + e.getMessage();
                Log.e((String)LCAT, (String)msg, (Throwable)e);
                throw e;
            }
            switch (type) {
                case 0: {
                    if (result instanceof String) break;
                    result = TiConvert.toString((Object)result);
                    break;
                }
                case 1: {
                    if (result instanceof Integer) break;
                    result = TiConvert.toInt((Object)result);
                    break;
                }
                case 2: {
                    if (result instanceof Float) break;
                    result = Float.valueOf(TiConvert.toFloat((Object)result));
                    break;
                }
                case 3: {
                    if (result instanceof Double) break;
                    result = TiConvert.toDouble((Object)result);
                }
            }
        }
        return result;
    }

    public Object fieldByName(Object[] args) {
        return this.internalGetFieldByName(args);
    }

    public Object getFieldByName(Object[] args) {
        return this.internalGetFieldByName(args);
    }

    private Object internalGetFieldByName(Object[] args) {
        String name = null;
        int type = -1;
        if (args.length >= 1) {
            if (args[0] instanceof String) {
                name = (String)args[0];
            } else {
                throw new IllegalArgumentException("Expected string column name as first parameter" + args[0].getClass().getSimpleName());
            }
        }
        if (args.length == 2) {
            if (args[1] instanceof Number) {
                type = TiConvert.toInt((Object)args[1]);
            } else {
                throw new IllegalArgumentException("Expected int field type as second parameter" + args[1].getClass().getSimpleName());
            }
        }
        return this.internalGetFieldByName(name, type);
    }

    private Object internalGetFieldByName(String fieldName, int type) {
        Object result = null;
        if (this.rs != null) {
            try {
                Integer ndx = this.columnNames.get(fieldName.toLowerCase());
                if (ndx != null) {
                    result = this.internalGetField(ndx, type);
                }
            }
            catch (SQLException e) {
                String msg = "Field name " + fieldName + " not found. msg=" + e.getMessage();
                Log.e((String)LCAT, (String)msg);
                throw e;
            }
        }
        return result;
    }

    public int getFieldCount() {
        if (this.rs != null) {
            try {
                return this.rs.getColumnCount();
            }
            catch (SQLException e) {
                Log.e((String)LCAT, (String)"No fields");
                throw e;
            }
        }
        return 0;
    }

    public String fieldName(int index) {
        return this.getFieldName(index);
    }

    public String getFieldName(int index) {
        if (this.rs != null) {
            try {
                return this.rs.getColumnName(index);
            }
            catch (SQLException e) {
                Log.e((String)LCAT, (String)("No column at index: " + index));
                throw e;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.rs != null) {
            return this.rs.getCount();
        }
        return 0;
    }

    public boolean isValidRow() {
        boolean valid = false;
        if (this.rs != null && !this.rs.isClosed() && !this.rs.isAfterLast()) {
            valid = true;
        }
        return valid;
    }

    public void next() {
        if (this.isValidRow()) {
            this.rs.moveToNext();
        } else {
            Log.w((String)LCAT, (String)"Ignoring next, row is already invalid.");
        }
    }

    static {
        if (Build.VERSION.SDK_INT > 4) {
            args = new Class[1];
            TiResultSetProxy.args[0] = Integer.TYPE;
            try {
                isFloat = AbstractWindowedCursor.class.getMethod("isFloat", args);
                isLong = AbstractWindowedCursor.class.getMethod("isLong", args);
                isNull = AbstractWindowedCursor.class.getMethod("isNull", args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

