/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.database;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.database.TiResultSetProxy;

public class TiDatabaseProxy
extends KrollProxy {
    private static final String LCAT = "TiDB";
    private static final boolean DBG = TiConfig.LOGD;
    protected SQLiteDatabase db;
    protected String name;
    boolean statementLogging;
    boolean readOnly;

    public TiDatabaseProxy(TiContext tiContext, String name, SQLiteDatabase db) {
        super(tiContext);
        this.name = name;
        this.db = db;
        this.statementLogging = false;
        this.readOnly = false;
    }

    public TiDatabaseProxy(TiContext tiContext, SQLiteDatabase db) {
        super(tiContext);
        this.name = db.getPath();
        this.db = db;
        this.statementLogging = false;
        this.readOnly = true;
    }

    public void close() {
        if (this.db.isOpen()) {
            if (DBG) {
                Log.d((String)LCAT, (String)("Closing database: " + this.name));
            }
            this.db.close();
        } else if (DBG) {
            Log.d((String)LCAT, (String)("Database is not open, ignoring close for " + this.name));
        }
    }

    public TiResultSetProxy execute(String sql, Object ... args) {
        if (this.statementLogging) {
            StringBuilder sb = new StringBuilder();
            sb.append("Executing SQL: ").append(sql).append("\n  Args: [ ");
            boolean needsComma = false;
            for (Object s : args) {
                if (needsComma) {
                    sb.append(", \"");
                } else {
                    sb.append(" \"");
                    needsComma = true;
                }
                sb.append(TiConvert.toString((Object)s)).append("\"");
            }
            sb.append(" ]");
            if (TiConfig.LOGV) {
                Log.v((String)LCAT, (String)sb.toString());
            }
        }
        TiResultSetProxy rs = null;
        Cursor c = null;
        Object[] newArgs = null;
        if (args != null) {
            newArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = TiConvert.toString((Object)args[i]);
            }
        }
        try {
            String lcSql = sql.toLowerCase().trim();
            if (lcSql.startsWith("select") || lcSql.startsWith("pragma")) {
                c = this.db.rawQuery(sql, (String[])newArgs);
                if (c != null) {
                    if (c.getColumnCount() > 0) {
                        rs = new TiResultSetProxy(this.getTiContext(), c);
                        if (rs.isValidRow()) {
                            rs.next();
                        }
                    } else {
                        c.close();
                        c = null;
                        rs = null;
                    }
                } else {
                    rs = new TiResultSetProxy(this.getTiContext(), null);
                }
            } else {
                this.db.execSQL(sql, newArgs);
            }
        }
        catch (SQLException e) {
            String msg = "Error executing sql: " + e.getMessage();
            Log.e((String)LCAT, (String)msg, (Throwable)e);
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
        return rs;
    }

    public String getName() {
        return this.name;
    }

    public int getLastInsertRowId() {
        return (int)DatabaseUtils.longForQuery((SQLiteDatabase)this.db, (String)"select last_insert_rowid()", null);
    }

    public int getRowsAffected() {
        return (int)DatabaseUtils.longForQuery((SQLiteDatabase)this.db, (String)"select changes()", null);
    }

    public void remove() {
        TiApplication ctx;
        if (this.readOnly) {
            Log.w((String)LCAT, (String)(this.name + " is a read-only database, cannot remove"));
            return;
        }
        if (this.db.isOpen()) {
            Log.w((String)LCAT, (String)("Attempt to remove open database. Closing then removing " + this.name));
            this.db.close();
        }
        if ((ctx = this.getTiContext().getTiApp()) != null) {
            ctx.deleteDatabase(this.name);
        } else {
            Log.w((String)LCAT, (String)("Unable to remove database, context has been reclaimed by GC: " + this.name));
        }
    }
}

