/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.database;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFileProxy;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.database.TiDatabaseProxy;

public class DatabaseModule
extends KrollModule {
    private static final String LCAT = "TiDatabase";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int FIELD_TYPE_UNKNOWN = -1;
    public static final int FIELD_TYPE_STRING = 0;
    public static final int FIELD_TYPE_INT = 1;
    public static final int FIELD_TYPE_FLOAT = 2;
    public static final int FIELD_TYPE_DOUBLE = 3;

    public DatabaseModule(TiContext tiContext) {
        super(tiContext);
    }

    public TiDatabaseProxy open(Object file) {
        TiDatabaseProxy dbp = null;
        try {
            if (file instanceof TiFileProxy) {
                TiFileProxy tiFile = (TiFileProxy)file;
                String absolutePath = tiFile.getBaseFile().getNativeFile().getAbsolutePath();
                Log.d((String)LCAT, (String)("Opening database from filesystem: " + absolutePath));
                SQLiteDatabase db = SQLiteDatabase.openDatabase((String)absolutePath, null, (int)17);
                dbp = new TiDatabaseProxy(this.getTiContext(), db);
            } else {
                String name = TiConvert.toString((Object)file);
                SQLiteDatabase db = this.getTiContext().getTiApp().openOrCreateDatabase(name, 0, null);
                dbp = new TiDatabaseProxy(this.getTiContext(), name, db);
            }
            if (DBG) {
                Log.d((String)LCAT, (String)("Opened database: " + dbp.getName()));
            }
        }
        catch (SQLException e) {
            String msg = "Error opening database: " + dbp.getName() + " msg=" + e.getMessage();
            Log.e((String)LCAT, (String)msg, (Throwable)e);
            throw e;
        }
        return dbp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiDatabaseProxy install(KrollInvocation invocation, String url, String name) throws IOException {
        try {
            TiContext tiContext = invocation.getTiContext();
            TiApplication ctx = this.getTiContext().getTiApp();
            for (String dbname : ctx.databaseList()) {
                if (!dbname.equals(name)) continue;
                return this.open(name);
            }
            File dbPath = ctx.getDatabasePath(name);
            if (DBG) {
                Log.d((String)LCAT, (String)("db path is = " + dbPath));
                Log.d((String)LCAT, (String)("db url is = " + url));
            }
            String path = tiContext.resolveUrl(null, url);
            TiBaseFile srcDb = TiFileFactory.createTitaniumFile((TiContext)this.getTiContext(), (String)path, (boolean)false);
            if (DBG) {
                Log.d((String)LCAT, (String)("new url is = " + url));
            }
            InputStream is = null;
            OutputStream os = null;
            byte[] buf = new byte[8096];
            int count = 0;
            try {
                is = new BufferedInputStream(srcDb.getInputStream());
                os = new BufferedOutputStream(new FileOutputStream(dbPath));
                while ((count = is.read(buf)) != -1) {
                    os.write(buf, 0, count);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ig) {}
                try {
                    os.close();
                }
                catch (Exception ig) {}
            }
            return this.open(name);
        }
        catch (SQLException e) {
            String msg = "Error installing database: " + name + " msg=" + e.getMessage();
            Log.e((String)LCAT, (String)msg, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            String msg = "Error installing database: " + name + " msg=" + e.getMessage();
            Log.e((String)LCAT, (String)msg, (Throwable)e);
            throw e;
        }
    }
}

