/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.contacts;

import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.Map;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import ti.modules.titanium.contacts.CommonContactsApi;

public class PersonProxy
extends KrollProxy {
    protected String lastName;
    protected String firstName;
    protected String fullName;
    protected String middleName;
    protected String firstPhonetic;
    protected String lastPhonetic;
    protected String middlePhonetic;
    protected String department;
    protected String jobTitle;
    protected String nickname;
    protected String note;
    protected String organization;
    protected String prefix;
    protected String suffix;
    protected String birthday;
    protected String created;
    protected String modified;
    protected int kind;
    protected KrollDict email;
    protected KrollDict phone;
    protected KrollDict address;
    protected long id;
    private TiBlob image = null;
    private boolean imageFetched;
    protected boolean hasImage = false;

    public PersonProxy(TiContext tiContext) {
        super(tiContext);
    }

    private boolean isPhotoFetchable() {
        return this.id > 0L && this.hasImage;
    }

    public TiBlob getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (!this.imageFetched && this.isPhotoFetchable()) {
            Bitmap photo = CommonContactsApi.getContactImage(this.getTiContext(), this.id);
            if (photo != null) {
                this.image = TiBlob.blobFromImage((TiContext)this.getTiContext(), (Bitmap)photo);
            }
            this.imageFetched = true;
        }
        return this.image;
    }

    public void setImage(TiBlob blob) {
        this.image = blob;
        this.hasImage = true;
        this.imageFetched = true;
    }

    private KrollDict contactMethodMapToDict(Map<String, ArrayList<String>> map) {
        KrollDict result = new KrollDict();
        for (String key : map.keySet()) {
            ArrayList<String> values = map.get(key);
            result.put((Object)key, (Object)values.toArray());
        }
        return result;
    }

    protected void setEmailFromMap(Map<String, ArrayList<String>> map) {
        this.email = this.contactMethodMapToDict(map);
    }

    protected void setPhoneFromMap(Map<String, ArrayList<String>> map) {
        this.phone = this.contactMethodMapToDict(map);
    }

    protected void setAddressFromMap(Map<String, ArrayList<String>> map) {
        this.address = new KrollDict();
        for (String key : map.keySet()) {
            ArrayList<String> values = map.get(key);
            KrollDict[] dictValues = new KrollDict[values.size()];
            for (int i = 0; i < dictValues.length; ++i) {
                dictValues[i] = new KrollDict();
                dictValues[i].put((Object)"Street", (Object)values.get(i));
            }
            this.address.put((Object)key, (Object)dictValues);
        }
    }
}

