/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.contacts;

import android.app.Activity;
import android.content.Intent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.ContextSpecific;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.contacts.CommonContactsApi;
import ti.modules.titanium.contacts.PersonProxy;

@ContextSpecific
public class ContactsModule
extends KrollModule
implements TiActivityResultHandler {
    private static final String LCAT = "TiContacts";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int CONTACTS_KIND_ORGANIZATION = 0;
    public static final int CONTACTS_KIND_PERSON = 1;
    public static final int CONTACTS_SORT_FIRST_NAME = 0;
    public static final int CONTACTS_SORT_LAST_NAME = 1;
    private final AtomicInteger requestCodeGen = new AtomicInteger();
    private final CommonContactsApi contactsApi;
    private Map<Integer, Map<String, KrollCallback>> requests;

    public ContactsModule(TiContext tiContext) {
        super(tiContext);
        this.contactsApi = CommonContactsApi.getInstance(tiContext);
    }

    public Object[] getAllPeople(@Kroll.argument(optional=true) KrollDict options) {
        Calendar start = Calendar.getInstance();
        int length = Integer.MAX_VALUE;
        if (options.containsKey((Object)"max")) {
            Double maxObj = (Double)options.get((Object)"max");
            length = maxObj.intValue();
        }
        PersonProxy[] persons = this.contactsApi.getAllPeople(length);
        Calendar end = Calendar.getInstance();
        long elapsed = end.getTimeInMillis() - start.getTimeInMillis();
        if (DBG) {
            Log.d((String)LCAT, (String)("getAllPersons elapsed: " + elapsed + " milliseconds"));
        }
        return persons;
    }

    public Object[] getPeopleWithName(String name) {
        return this.contactsApi.getPeopleWithName(name);
    }

    public PersonProxy getPersonByID(long id) {
        return this.contactsApi.getPersonById(id);
    }

    public void showContacts(KrollInvocation invocation, @Kroll.argument(optional=true) KrollDict d) {
        String[] callbacksToConsider;
        Activity launchingActivity = invocation.getTiContext().getActivity();
        if (launchingActivity == null) {
            launchingActivity = this.getTiContext().getActivity();
        }
        Intent intent = this.contactsApi.getIntentForContactsPicker();
        if (DBG) {
            Log.d((String)LCAT, (String)"Launching content picker activity");
        }
        int requestCode = this.requestCodeGen.getAndIncrement();
        if (this.requests == null) {
            this.requests = new HashMap<Integer, Map<String, KrollCallback>>();
        }
        HashMap<String, KrollCallback> callbacks = new HashMap<String, KrollCallback>();
        this.requests.put(new Integer(requestCode), callbacks);
        for (String callbackToConsider : callbacksToConsider = new String[]{"selectedPerson", "cancel"}) {
            Object test;
            if (d.containsKey((Object)callbackToConsider) && (test = d.get((Object)callbackToConsider)) instanceof KrollCallback) {
                callbacks.put(callbackToConsider, (KrollCallback)test);
            }
            if (!d.containsKey((Object)"proxy") || (test = d.get((Object)"proxy")) == null || !(test instanceof KrollProxy)) continue;
            launchingActivity = ((KrollProxy)test).getTiContext().getActivity();
        }
        TiActivitySupport activitySupport = (TiActivitySupport)launchingActivity;
        activitySupport.launchActivityForResult(intent, requestCode, (TiActivityResultHandler)this);
    }

    public void onError(Activity activity, int requestCode, Exception e) {
        Log.e((String)LCAT, (String)("Error from contact picker activity: " + e.getMessage()), (Throwable)e);
    }

    public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
        Integer rcode = new Integer(requestCode);
        if (this.requests.containsKey(rcode)) {
            Map<String, KrollCallback> request = this.requests.get(rcode);
            if (DBG) {
                Log.d((String)LCAT, (String)("Received result from contact picker.  Result code: " + resultCode));
            }
            if (resultCode == 0) {
                KrollCallback callback;
                if (request.containsKey("cancel") && (callback = request.get("cancel")) != null) {
                    callback.callAsync();
                }
            } else if (resultCode == -1) {
                KrollCallback callback;
                if (request.containsKey("selectedPerson") && (callback = request.get("selectedPerson")) != null) {
                    PersonProxy person = this.contactsApi.getPersonByUri(data.getData());
                    KrollDict result = new KrollDict();
                    result.put((Object)"person", (Object)person);
                    callback.callAsync(new Object[]{result});
                }
            } else {
                Log.w((String)LCAT, (String)("Result code from contact picker activity not understood: " + resultCode));
            }
            request.clear();
            this.requests.remove(rcode);
        }
    }
}

