/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.contacts;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.appcelerator.titanium.TiContext;
import ti.modules.titanium.contacts.CommonContactsApi;
import ti.modules.titanium.contacts.PersonProxy;

public class ContactsApiLevel5
extends CommonContactsApi {
    protected boolean loadedOk;
    private WeakReference<TiContext> weakContext;
    private static final String LCAT = "TiContacts5";
    private Method openContactPhotoInputStream;
    private static Class<?> Contacts;
    private static Uri ContactsUri;
    private static Uri DataUri;
    private static String[] DATA_PROJECTION;
    protected static int DATA_COLUMN_CONTACT_ID;
    protected static int DATA_COLUMN_MIMETYPE;
    protected static int DATA_COLUMN_PHOTO_ID;
    protected static int DATA_COLUMN_DISPLAY_NAME;
    protected static int DATA_COLUMN_DATA1;
    protected static int DATA_COLUMN_DATA2;
    protected static int DATA_COLUMN_DATA3;
    protected static int DATA_COLUMN_DATA4;
    protected static int DATA_COLUMN_DATA5;
    protected static int DATA_COLUMN_DATA6;
    protected static int DATA_COLUMN_DATA7;
    protected static int DATA_COLUMN_DATA8;
    protected static int DATA_COLUMN_DATA9;
    protected static int DATA_COLUMN_DATA10;
    protected static int DATA_COLUMN_NOTE;
    protected static int DATA_COLUMN_EMAIL_ADDR;
    protected static int DATA_COLUMN_EMAIL_TYPE;
    protected static int DATA_COLUMN_PHONE_NUMBER;
    protected static int DATA_COLUMN_PHONE_TYPE;
    protected static int DATA_COLUMN_NAME_FIRST;
    protected static int DATA_COLUMN_NAME_LAST;
    protected static int DATA_COLUMN_NAME_PREFIX;
    protected static int DATA_COLUMN_NAME_MIDDLE;
    protected static int DATA_COLUMN_NAME_SUFFIX;
    protected static int DATA_COLUMN_ADDRESS_FULL;
    protected static int DATA_COLUMN_ADDRESS_TYPE;
    protected static int DATA_COLUMN_ADDRESS_STREET;
    protected static int DATA_COLUMN_ADDRESS_POBOX;
    protected static int DATA_COLUMN_ADDRESS_NEIGHBORHOOD;
    protected static int DATA_COLUMN_ADDRESS_CITY;
    protected static int DATA_COLUMN_ADDRESS_STATE;
    protected static int DATA_COLUMN_ADDRESS_POSTCODE;
    protected static int DATA_COLUMN_ADDRESS_COUNTRY;
    protected static String KIND_NAME;
    protected static String KIND_EMAIL;
    protected static String KIND_NOTE;
    protected static String KIND_PHONE;
    protected static String KIND_ADDRESS;
    private static String[] PEOPLE_PROJECTION;
    protected static int PEOPLE_COL_ID;
    protected static int PEOPLE_COL_NAME;
    protected static int PEOPLE_COL_PHOTO_ID;
    private static String INConditionForKinds;

    protected ContactsApiLevel5(TiContext tiContext) {
        this.weakContext = new WeakReference<TiContext>(tiContext);
        this.loadedOk = true;
        try {
            DataUri = (Uri)Class.forName("android.provider.ContactsContract$Data").getField("CONTENT_URI").get(null);
            Contacts = Class.forName("android.provider.ContactsContract$Contacts");
            ContactsUri = (Uri)Contacts.getField("CONTENT_URI").get(null);
            this.openContactPhotoInputStream = Contacts.getMethod("openContactPhotoInputStream", ContentResolver.class, Uri.class);
        }
        catch (Throwable t) {
            Log.d((String)LCAT, (String)("Failed to load ContactsContract$Contacts " + t.getMessage()), (Throwable)t);
            this.loadedOk = false;
            return;
        }
    }

    @Override
    protected PersonProxy[] getAllPeople(int limit) {
        return this.getPeople(limit, null, null);
    }

    private PersonProxy[] getPeople(int limit, String additionalCondition, String[] additionalSelectionArgs) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getPeople, context is GC'd");
            return null;
        }
        LinkedHashMap<Long, CommonContactsApi.LightPerson> persons = new LinkedHashMap<Long, CommonContactsApi.LightPerson>();
        String condition = "mimetype IN " + INConditionForKinds + " AND in_visible_group=1";
        if (additionalCondition != null) {
            condition = condition + " AND " + additionalCondition;
        }
        Cursor cursor = tiContext.getActivity().managedQuery(DataUri, DATA_PROJECTION, condition, additionalSelectionArgs, "display_name COLLATE LOCALIZED asc, contact_id asc, mimetype asc, is_super_primary desc, is_primary desc");
        while (cursor.moveToNext() && persons.size() < limit) {
            CommonContactsApi.LightPerson person;
            long id = cursor.getLong(DATA_COLUMN_CONTACT_ID);
            if (persons.containsKey(id)) {
                person = persons.get(id);
            } else {
                person = new CommonContactsApi.LightPerson();
                person.addPersonInfoFromL5DataRow(cursor);
                persons.put(id, person);
            }
            person.addDataFromL5Cursor(cursor);
        }
        cursor.close();
        return this.proxifyPeople(persons, tiContext);
    }

    @Override
    protected Intent getIntentForContactsPicker() {
        return new Intent("android.intent.action.PICK", ContactsUri);
    }

    @Override
    protected PersonProxy[] getPeopleWithName(String name) {
        return this.getPeople(Integer.MAX_VALUE, "display_name like ? or display_name like ?", new String[]{name + '%', "% " + name + '%'});
    }

    @Override
    protected PersonProxy getPersonById(long id) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getPersonById, context is GC'd");
            return null;
        }
        CommonContactsApi.LightPerson person = null;
        Cursor cursor = tiContext.getActivity().managedQuery(ContentUris.withAppendedId((Uri)ContactsUri, (long)id), PEOPLE_PROJECTION, null, null, null);
        if (cursor.moveToFirst()) {
            person = new CommonContactsApi.LightPerson();
            person.addPersonInfoFromL5PersonRow(cursor);
        }
        cursor.close();
        if (person == null) {
            return null;
        }
        String condition = "mimetype IN " + INConditionForKinds + " AND contact_id = ?";
        cursor = tiContext.getActivity().managedQuery(DataUri, DATA_PROJECTION, condition, new String[]{String.valueOf(id)}, "mimetype asc, is_super_primary desc, is_primary desc");
        while (cursor.moveToNext()) {
            person.addDataFromL5Cursor(cursor);
        }
        cursor.close();
        return person.proxify(tiContext);
    }

    @Override
    protected PersonProxy getPersonByUri(Uri uri) {
        long id = ContentUris.parseId((Uri)uri);
        return this.getPersonById(id);
    }

    @Override
    protected Bitmap getContactImage(long id) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getContactImage, context is GC'd");
            return null;
        }
        Uri uri = ContentUris.withAppendedId((Uri)ContactsUri, (long)id);
        ContentResolver cr = tiContext.getActivity().getContentResolver();
        InputStream stream = null;
        try {
            stream = (InputStream)this.openContactPhotoInputStream.invoke(null, cr, uri);
        }
        catch (Throwable t) {
            Log.d((String)LCAT, (String)("Could not invoke openContactPhotoInputStream: " + t.getMessage()), (Throwable)t);
            return null;
        }
        if (stream == null) {
            return null;
        }
        Bitmap bm = BitmapFactory.decodeStream((InputStream)stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            Log.d((String)LCAT, (String)("Unable to close stream from openContactPhotoInputStream: " + e.getMessage()), (Throwable)e);
        }
        return bm;
    }

    static {
        DATA_PROJECTION = new String[]{"contact_id", "mimetype", "photo_id", "display_name", "data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10"};
        DATA_COLUMN_CONTACT_ID = 0;
        DATA_COLUMN_MIMETYPE = 1;
        DATA_COLUMN_PHOTO_ID = 2;
        DATA_COLUMN_DISPLAY_NAME = 3;
        DATA_COLUMN_DATA1 = 4;
        DATA_COLUMN_DATA2 = 5;
        DATA_COLUMN_DATA3 = 6;
        DATA_COLUMN_DATA4 = 7;
        DATA_COLUMN_DATA5 = 8;
        DATA_COLUMN_DATA6 = 9;
        DATA_COLUMN_DATA7 = 10;
        DATA_COLUMN_DATA8 = 11;
        DATA_COLUMN_DATA9 = 12;
        DATA_COLUMN_DATA10 = 13;
        DATA_COLUMN_NOTE = DATA_COLUMN_DATA1;
        DATA_COLUMN_EMAIL_ADDR = DATA_COLUMN_DATA1;
        DATA_COLUMN_EMAIL_TYPE = DATA_COLUMN_DATA2;
        DATA_COLUMN_PHONE_NUMBER = DATA_COLUMN_DATA1;
        DATA_COLUMN_PHONE_TYPE = DATA_COLUMN_DATA2;
        DATA_COLUMN_NAME_FIRST = DATA_COLUMN_DATA2;
        DATA_COLUMN_NAME_LAST = DATA_COLUMN_DATA3;
        DATA_COLUMN_NAME_PREFIX = DATA_COLUMN_DATA4;
        DATA_COLUMN_NAME_MIDDLE = DATA_COLUMN_DATA5;
        DATA_COLUMN_NAME_SUFFIX = DATA_COLUMN_DATA6;
        DATA_COLUMN_ADDRESS_FULL = DATA_COLUMN_DATA1;
        DATA_COLUMN_ADDRESS_TYPE = DATA_COLUMN_DATA2;
        DATA_COLUMN_ADDRESS_STREET = DATA_COLUMN_DATA4;
        DATA_COLUMN_ADDRESS_POBOX = DATA_COLUMN_DATA5;
        DATA_COLUMN_ADDRESS_NEIGHBORHOOD = DATA_COLUMN_DATA6;
        DATA_COLUMN_ADDRESS_CITY = DATA_COLUMN_DATA7;
        DATA_COLUMN_ADDRESS_STATE = DATA_COLUMN_DATA8;
        DATA_COLUMN_ADDRESS_POSTCODE = DATA_COLUMN_DATA9;
        DATA_COLUMN_ADDRESS_COUNTRY = DATA_COLUMN_DATA10;
        KIND_NAME = "vnd.android.cursor.item/name";
        KIND_EMAIL = "vnd.android.cursor.item/email_v2";
        KIND_NOTE = "vnd.android.cursor.item/note";
        KIND_PHONE = "vnd.android.cursor.item/phone_v2";
        KIND_ADDRESS = "vnd.android.cursor.item/postal-address_v2";
        PEOPLE_PROJECTION = new String[]{"_id", "display_name", "photo_id"};
        PEOPLE_COL_ID = 0;
        PEOPLE_COL_NAME = 1;
        PEOPLE_COL_PHOTO_ID = 2;
        INConditionForKinds = "('" + KIND_ADDRESS + "','" + KIND_EMAIL + "','" + KIND_NAME + "','" + KIND_NOTE + "','" + KIND_PHONE + "')";
    }
}

