/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.contacts;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.Contacts;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.util.Log;
import ti.modules.titanium.contacts.CommonContactsApi;
import ti.modules.titanium.contacts.PersonProxy;

public class ContactsApiLevel4
extends CommonContactsApi {
    private WeakReference<TiContext> weakContext;
    private static final String LCAT = "TiContacts4";
    private static String[] PEOPLE_PROJECTION = new String[]{"_id", "name", "notes"};
    protected static final int PEOPLE_COL_ID = 0;
    protected static final int PEOPLE_COL_NAME = 1;
    protected static final int PEOPLE_COL_NOTES = 2;
    private static final String[] CONTACT_METHOD_PROJECTION = new String[]{"person", "kind", "type", "data"};
    protected static final int CONTACT_METHOD_COL_PERSONID = 0;
    protected static final int CONTACT_METHOD_COL_KIND = 1;
    protected static final int CONTACT_METHOD_COL_TYPE = 2;
    protected static final int CONTACT_METHOD_COL_DATA = 3;
    private static final String[] PHONE_PROJECTION = new String[]{"person", "type", "number"};
    protected static final int PHONE_COL_PERSONID = 0;
    protected static final int PHONE_COL_TYPE = 1;
    protected static final int PHONE_COL_NUMBER = 2;
    private static final String[] PHOTOS_PROJECTION = new String[]{"person", "download_required"};
    protected static final int PHOTO_COL_PERSONID = 0;
    protected static final int PHOTO_COL_DOWNLOAD_REQUIRED = 1;

    protected ContactsApiLevel4(TiContext tiContext) {
        this.weakContext = new WeakReference<TiContext>(tiContext);
    }

    @Override
    protected PersonProxy[] getAllPeople(int limit) {
        CommonContactsApi.LightPerson lp;
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getAllPeople, context is GC'd");
            return null;
        }
        LinkedHashMap<Long, CommonContactsApi.LightPerson> persons = new LinkedHashMap<Long, CommonContactsApi.LightPerson>();
        Cursor cursor = tiContext.getActivity().managedQuery(Contacts.People.CONTENT_URI, PEOPLE_PROJECTION, null, null, "name COLLATE LOCALIZED");
        for (int count = 0; cursor.moveToNext() && count < limit; ++count) {
            CommonContactsApi.LightPerson lp2 = new CommonContactsApi.LightPerson();
            lp2.addPersonInfoFromL4Cursor(cursor);
            persons.put(lp2.id, lp2);
        }
        cursor.close();
        cursor = tiContext.getActivity().managedQuery(Contacts.ContactMethods.CONTENT_URI, CONTACT_METHOD_PROJECTION, null, null, null);
        while (cursor.moveToNext()) {
            long id = cursor.getLong(0);
            lp = (CommonContactsApi.LightPerson)persons.get(id);
            if (lp == null) continue;
            int kind = cursor.getInt(1);
            if (kind == 1) {
                lp.addEmailFromL4Cursor(cursor);
                continue;
            }
            if (kind != 2) continue;
            lp.addAddressFromL4Cursor(cursor);
        }
        cursor.close();
        cursor = tiContext.getActivity().managedQuery(Contacts.Phones.CONTENT_URI, PHONE_PROJECTION, null, null, null);
        while (cursor.moveToNext()) {
            long id = cursor.getLong(0);
            lp = (CommonContactsApi.LightPerson)persons.get(id);
            if (lp == null) continue;
            lp.addPhoneFromL4Cursor(cursor);
        }
        cursor.close();
        cursor = tiContext.getActivity().managedQuery(Contacts.Photos.CONTENT_URI, PHOTOS_PROJECTION, "data IS NOT NULL", null, null);
        while (cursor.moveToNext()) {
            long id = cursor.getLong(0);
            lp = persons.get(id);
            if (lp == null) continue;
            lp.addPhotoInfoFromL4Cursor(cursor);
        }
        cursor.close();
        PersonProxy[] proxies = this.proxifyPeople(persons, tiContext);
        persons.clear();
        persons = null;
        return proxies;
    }

    @Override
    protected PersonProxy[] getPeopleWithName(String name) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getAllPeople, context is GC'd");
            return null;
        }
        ArrayList<PersonProxy> all = new ArrayList<PersonProxy>();
        Cursor cursor = tiContext.getActivity().managedQuery(Contacts.People.CONTENT_URI, PEOPLE_PROJECTION, "name like ? OR name like ?", new String[]{name + '%', "% " + name + '%'}, null);
        while (cursor.moveToNext()) {
            all.add(this.getPersonFromCursor(cursor));
        }
        cursor.close();
        return all.toArray(new PersonProxy[all.size()]);
    }

    @Override
    protected PersonProxy getPersonById(long id) {
        Uri uri = ContentUris.withAppendedId((Uri)Contacts.People.CONTENT_URI, (long)id);
        return this.getPersonByUri(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PersonProxy getPersonByUri(Uri uri) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getPersonByUri, context is GC'd");
            return null;
        }
        TiRootActivity root = tiContext.getRootActivity();
        Cursor cursor = root.managedQuery(uri, PEOPLE_PROJECTION, null, null, null);
        PersonProxy person = null;
        try {
            cursor.moveToFirst();
            person = this.getPersonFromCursor(cursor);
        }
        catch (Throwable t) {
            Log.e((String)LCAT, (String)("Error fetching contact from cursor: " + t.getMessage()), (Throwable)t);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Throwable tt) {}
        }
        return person;
    }

    private PersonProxy getPersonFromCursor(Cursor cursor) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getPersonFromCursor, context is GC'd");
            return null;
        }
        if (cursor.isBeforeFirst()) {
            cursor.moveToFirst();
        }
        CommonContactsApi.LightPerson lp = new CommonContactsApi.LightPerson();
        lp.addPersonInfoFromL4Cursor(cursor);
        long personId = lp.id;
        Cursor emailsCursor = tiContext.getActivity().managedQuery(Contacts.ContactMethods.CONTENT_URI, CONTACT_METHOD_PROJECTION, "person = ? AND kind = ?", new String[]{Long.toString(personId), Integer.toString(1)}, null);
        while (emailsCursor.moveToNext()) {
            lp.addEmailFromL4Cursor(emailsCursor);
        }
        emailsCursor.close();
        Cursor phonesCursor = tiContext.getActivity().managedQuery(Contacts.Phones.CONTENT_URI, PHONE_PROJECTION, "person = ?", new String[]{Long.toString(personId)}, null);
        while (phonesCursor.moveToNext()) {
            lp.addPhoneFromL4Cursor(phonesCursor);
        }
        phonesCursor.close();
        Cursor addressesCursor = tiContext.getActivity().managedQuery(Contacts.ContactMethods.CONTENT_URI, CONTACT_METHOD_PROJECTION, "person = ? AND kind = ?", new String[]{Long.toString(personId), Integer.toString(2)}, null);
        while (addressesCursor.moveToNext()) {
            lp.addAddressFromL4Cursor(addressesCursor);
        }
        addressesCursor.close();
        Cursor photosCursor = tiContext.getActivity().managedQuery(Contacts.Photos.CONTENT_URI, PHOTOS_PROJECTION, "person = ? AND data IS NOT NULL", new String[]{Long.toString(personId)}, null);
        while (photosCursor.moveToNext()) {
            lp.addPhotoInfoFromL4Cursor(photosCursor);
        }
        photosCursor.close();
        return lp.proxify(tiContext);
    }

    @Override
    protected Intent getIntentForContactsPicker() {
        return new Intent("android.intent.action.PICK", Contacts.People.CONTENT_URI);
    }

    @Override
    protected Bitmap getContactImage(long id) {
        TiContext tiContext = (TiContext)this.weakContext.get();
        if (tiContext == null) {
            Log.d((String)LCAT, (String)"Could not getContactImage, context is GC'd");
            return null;
        }
        boolean NO_PLACEHOLDER_IMAGE = false;
        return Contacts.People.loadContactPhoto((Context)tiContext.getActivity(), (Uri)ContentUris.withAppendedId((Uri)Contacts.People.CONTENT_URI, (long)id), (int)0, null);
    }
}

