/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.contacts;

import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import ti.modules.titanium.contacts.ContactsApiLevel4;
import ti.modules.titanium.contacts.ContactsApiLevel5;
import ti.modules.titanium.contacts.PersonProxy;

public abstract class CommonContactsApi {
    private static final boolean TRY_NEWER_API = Build.VERSION.SDK_INT > 4;
    private static final String LCAT = "TiCommonContactsApi";

    protected static CommonContactsApi getInstance(TiContext tiContext) {
        boolean useNew = false;
        if (TRY_NEWER_API) {
            try {
                Class.forName("android.provider.ContactsContract");
                useNew = true;
            }
            catch (ClassNotFoundException e) {
                Log.d((String)LCAT, (String)("Unable to load newer contacts api: " + e.getMessage()), (Throwable)e);
                useNew = false;
            }
        }
        Log.d((String)LCAT, (String)("Using " + (useNew ? "newer " : "older ") + "contacts api.  Android SDK level: " + Build.VERSION.SDK_INT));
        if (useNew) {
            ContactsApiLevel5 c = new ContactsApiLevel5(tiContext);
            if (!c.loadedOk) {
                Log.d((String)LCAT, (String)"ContactsApiLevel5 did not load successfully.  Falling back to L4.");
                return new ContactsApiLevel4(tiContext);
            }
            return c;
        }
        return new ContactsApiLevel4(tiContext);
    }

    protected static Bitmap getContactImage(TiContext context, long contact_id) {
        CommonContactsApi api = CommonContactsApi.getInstance(context);
        return api.getContactImage(contact_id);
    }

    protected abstract PersonProxy getPersonById(long var1);

    protected abstract PersonProxy getPersonByUri(Uri var1);

    protected abstract PersonProxy[] getAllPeople(int var1);

    protected abstract PersonProxy[] getPeopleWithName(String var1);

    protected abstract Intent getIntentForContactsPicker();

    protected abstract Bitmap getContactImage(long var1);

    protected PersonProxy[] getAllPeople() {
        return this.getAllPeople(Integer.MAX_VALUE);
    }

    protected PersonProxy[] proxifyPeople(Map<Long, LightPerson> persons, TiContext tiContext) {
        PersonProxy[] proxies = new PersonProxy[persons.size()];
        int index = 0;
        for (LightPerson person : persons.values()) {
            proxies[index] = person.proxify(tiContext);
            ++index;
        }
        return proxies;
    }

    protected static String getEmailTextType(int type) {
        String key = "other";
        if (type == 1) {
            key = "home";
        } else if (type == 2) {
            key = "work";
        }
        return key;
    }

    protected static String getPhoneTextType(int type) {
        String key = "other";
        if (type == 5) {
            key = "homeFax";
        }
        if (type == 4) {
            key = "workFax";
        }
        if (type == 1) {
            key = "home";
        }
        if (type == 2) {
            key = "mobile";
        }
        if (type == 6) {
            key = "pager";
        }
        if (type == 3) {
            key = "work";
        }
        return key;
    }

    protected static String getPostalAddressTextType(int type) {
        String key = "other";
        if (type == 1) {
            key = "home";
        } else if (type == 2) {
            key = "work";
        }
        return key;
    }

    protected static class LightPerson {
        long id;
        String name;
        String notes;
        boolean hasImage = false;
        Map<String, ArrayList<String>> emails = new HashMap<String, ArrayList<String>>();
        Map<String, ArrayList<String>> phones = new HashMap<String, ArrayList<String>>();
        Map<String, ArrayList<String>> addresses = new HashMap<String, ArrayList<String>>();

        protected LightPerson() {
        }

        void addPersonInfoFromL4Cursor(Cursor cursor) {
            this.id = cursor.getLong(0);
            this.name = cursor.getString(1);
            this.notes = cursor.getString(2);
        }

        void addPersonInfoFromL5DataRow(Cursor cursor) {
            this.id = cursor.getLong(ContactsApiLevel5.DATA_COLUMN_CONTACT_ID);
            this.name = cursor.getString(ContactsApiLevel5.DATA_COLUMN_DISPLAY_NAME);
            this.hasImage = cursor.getInt(ContactsApiLevel5.DATA_COLUMN_PHOTO_ID) > 0;
        }

        void addPersonInfoFromL5PersonRow(Cursor cursor) {
            this.id = cursor.getLong(ContactsApiLevel5.PEOPLE_COL_ID);
            this.name = cursor.getString(ContactsApiLevel5.PEOPLE_COL_NAME);
            this.hasImage = cursor.getInt(ContactsApiLevel5.PEOPLE_COL_PHOTO_ID) > 0;
        }

        void addDataFromL5Cursor(Cursor cursor) {
            String kind = cursor.getString(ContactsApiLevel5.DATA_COLUMN_MIMETYPE);
            if (kind.equals(ContactsApiLevel5.KIND_ADDRESS)) {
                this.loadAddressFromL5DataRow(cursor);
            } else if (kind.equals(ContactsApiLevel5.KIND_EMAIL)) {
                this.loadEmailFromL5DataRow(cursor);
            } else if (!kind.equals(ContactsApiLevel5.KIND_NAME)) {
                if (kind.equals(ContactsApiLevel5.KIND_NOTE)) {
                    this.loadNoteFromL5DataRow(cursor);
                } else if (kind.equals(ContactsApiLevel5.KIND_PHONE)) {
                    this.loadPhoneFromL5DataRow(cursor);
                }
            }
        }

        void loadPhoneFromL5DataRow(Cursor phonesCursor) {
            ArrayList<Object> collection;
            String phoneNumber = phonesCursor.getString(ContactsApiLevel5.DATA_COLUMN_PHONE_NUMBER);
            int type = phonesCursor.getInt(ContactsApiLevel5.DATA_COLUMN_PHONE_TYPE);
            String key = CommonContactsApi.getPhoneTextType(type);
            if (this.phones.containsKey(key)) {
                collection = this.phones.get(key);
            } else {
                collection = new ArrayList();
                this.phones.put(key, collection);
            }
            collection.add(phoneNumber);
        }

        void loadNoteFromL5DataRow(Cursor cursor) {
            this.notes = cursor.getString(ContactsApiLevel5.DATA_COLUMN_NOTE);
        }

        void loadEmailFromL5DataRow(Cursor emailsCursor) {
            ArrayList<Object> collection;
            String emailAddress = emailsCursor.getString(ContactsApiLevel5.DATA_COLUMN_EMAIL_ADDR);
            int type = emailsCursor.getInt(ContactsApiLevel5.DATA_COLUMN_EMAIL_TYPE);
            String key = CommonContactsApi.getEmailTextType(type);
            if (this.emails.containsKey(key)) {
                collection = this.emails.get(key);
            } else {
                collection = new ArrayList();
                this.emails.put(key, collection);
            }
            collection.add(emailAddress);
        }

        void loadAddressFromL5DataRow(Cursor cursor) {
            ArrayList<Object> collection;
            String fullAddress = cursor.getString(ContactsApiLevel5.DATA_COLUMN_ADDRESS_FULL);
            int type = cursor.getInt(ContactsApiLevel5.DATA_COLUMN_ADDRESS_TYPE);
            String key = CommonContactsApi.getPostalAddressTextType(type);
            if (this.addresses.containsKey(key)) {
                collection = this.addresses.get(key);
            } else {
                collection = new ArrayList();
                this.addresses.put(key, collection);
            }
            collection.add(fullAddress);
        }

        void addEmailFromL4Cursor(Cursor emailsCursor) {
            ArrayList<Object> collection;
            String emailAddress = emailsCursor.getString(3);
            int type = emailsCursor.getInt(2);
            String key = ContactsApiLevel4.getEmailTextType(type);
            if (this.emails.containsKey(key)) {
                collection = this.emails.get(key);
            } else {
                collection = new ArrayList();
                this.emails.put(key, collection);
            }
            collection.add(emailAddress);
        }

        void addPhoneFromL4Cursor(Cursor phonesCursor) {
            ArrayList<Object> collection;
            String phoneNumber = phonesCursor.getString(2);
            int type = phonesCursor.getInt(1);
            String key = CommonContactsApi.getPhoneTextType(type);
            if (this.phones.containsKey(key)) {
                collection = this.phones.get(key);
            } else {
                collection = new ArrayList();
                this.phones.put(key, collection);
            }
            collection.add(phoneNumber);
        }

        void addAddressFromL4Cursor(Cursor addressesCursor) {
            ArrayList<Object> collection;
            String fullAddress = addressesCursor.getString(3);
            int type = addressesCursor.getInt(2);
            String key = CommonContactsApi.getPostalAddressTextType(type);
            if (this.addresses.containsKey(key)) {
                collection = this.addresses.get(key);
            } else {
                collection = new ArrayList();
                this.addresses.put(key, collection);
            }
            collection.add(fullAddress);
        }

        void addPhotoInfoFromL4Cursor(Cursor photosCursor) {
            this.hasImage = true;
        }

        PersonProxy proxify(TiContext tiContext) {
            PersonProxy proxy = new PersonProxy(tiContext);
            proxy.fullName = this.name;
            proxy.note = this.notes;
            proxy.setEmailFromMap(this.emails);
            proxy.setPhoneFromMap(this.phones);
            proxy.setAddressFromMap(this.addresses);
            proxy.kind = 1;
            proxy.id = this.id;
            proxy.hasImage = this.hasImage;
            return proxy;
        }
    }
}

