/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android.calendar;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Date;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.android.calendar.AlertProxy;
import ti.modules.titanium.android.calendar.CalendarProxy;
import ti.modules.titanium.android.calendar.ReminderProxy;

public class EventProxy
extends KrollProxy {
    public static final String TAG = "TiEvent";
    public static final int STATUS_TENTATIVE = 0;
    public static final int STATUS_CONFIRMED = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int VISIBILITY_DEFAULT = 0;
    public static final int VISIBILITY_CONFIDENTIAL = 1;
    public static final int VISIBILITY_PRIVATE = 2;
    public static final int VISIBILITY_PUBLIC = 3;
    protected String id;
    protected String title;
    protected String description;
    protected String location;
    protected Date begin;
    protected Date end;
    protected boolean allDay;
    protected boolean hasAlarm = true;
    protected boolean hasExtendedProperties = true;
    protected int status;
    protected int visibility;
    protected KrollDict extendedProperties = new KrollDict();
    protected String recurrenceRule;
    protected String recurrenceDate;
    protected String recurrenceExceptionRule;
    protected String recurrenceExceptionDate;
    protected Date lastDate;

    public EventProxy(TiContext context) {
        super(context);
    }

    public static String getEventsUri() {
        return CalendarProxy.getBaseCalendarUri() + "/events";
    }

    public static String getInstancesWhenUri() {
        return CalendarProxy.getBaseCalendarUri() + "/instances/when";
    }

    public static String getExtendedPropertiesUri() {
        return CalendarProxy.getBaseCalendarUri() + "/extendedproperties";
    }

    public static ArrayList<EventProxy> queryEvents(TiContext context, String query, String[] queryArgs) {
        return EventProxy.queryEvents(context, Uri.parse((String)EventProxy.getEventsUri()), query, queryArgs, "dtstart ASC");
    }

    public static ArrayList<EventProxy> queryEventsBetweenDates(TiContext context, long date1, long date2, String query, String[] queryArgs) {
        ArrayList<EventProxy> events = new ArrayList<EventProxy>();
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        Uri.Builder builder = Uri.parse((String)EventProxy.getInstancesWhenUri()).buildUpon();
        ContentUris.appendId((Uri.Builder)builder, (long)date1);
        ContentUris.appendId((Uri.Builder)builder, (long)date2);
        Cursor eventCursor = contentResolver.query(builder.build(), new String[]{"event_id", "title", "description", "eventLocation", "begin", "end", "allDay", "hasAlarm", "eventStatus", "visibility"}, query, queryArgs, "startDay ASC, startMinute ASC");
        while (eventCursor.moveToNext()) {
            EventProxy event = new EventProxy(context);
            event.id = eventCursor.getString(0);
            event.title = eventCursor.getString(1);
            event.description = eventCursor.getString(2);
            event.location = eventCursor.getString(3);
            event.begin = new Date(eventCursor.getLong(4));
            event.end = new Date(eventCursor.getLong(5));
            event.allDay = !eventCursor.getString(6).equals("0");
            event.hasAlarm = !eventCursor.getString(7).equals("0");
            event.status = eventCursor.getInt(8);
            event.visibility = eventCursor.getInt(9);
            events.add(event);
        }
        eventCursor.close();
        return events;
    }

    public static ArrayList<EventProxy> queryEvents(TiContext context, Uri uri, String query, String[] queryArgs, String orderBy) {
        ArrayList<EventProxy> events = new ArrayList<EventProxy>();
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        Cursor eventCursor = contentResolver.query(uri, new String[]{"_id", "title", "description", "eventLocation", "dtstart", "dtend", "allDay", "hasAlarm", "eventStatus", "visibility", "hasExtendedProperties"}, query, queryArgs, orderBy);
        while (eventCursor.moveToNext()) {
            EventProxy event = new EventProxy(context);
            event.id = eventCursor.getString(0);
            event.title = eventCursor.getString(1);
            event.description = eventCursor.getString(2);
            event.location = eventCursor.getString(3);
            event.begin = new Date(eventCursor.getLong(4));
            event.end = new Date(eventCursor.getLong(5));
            event.allDay = !eventCursor.getString(6).equals("0");
            event.hasAlarm = !eventCursor.getString(7).equals("0");
            event.status = eventCursor.getInt(8);
            event.visibility = eventCursor.getInt(9);
            event.hasExtendedProperties = !eventCursor.getString(10).equals("0");
            events.add(event);
        }
        eventCursor.close();
        return events;
    }

    public static EventProxy createEvent(TiContext context, CalendarProxy calendar, KrollDict data) {
        String eventId;
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        EventProxy event = new EventProxy(context);
        ContentValues eventValues = new ContentValues();
        eventValues.put("hasAlarm", Integer.valueOf(1));
        eventValues.put("hasExtendedProperties", Integer.valueOf(1));
        if (!data.containsKey((Object)"title")) {
            Log.e((String)TAG, (String)"No title found for event, so it wasn't created");
            return null;
        }
        event.title = TiConvert.toString((KrollDict)data, (String)"title");
        eventValues.put("title", event.title);
        eventValues.put("calendar_id", calendar.getId());
        if (data.containsKey((Object)"description")) {
            event.description = TiConvert.toString((KrollDict)data, (String)"description");
            eventValues.put("description", event.description);
        }
        if (data.containsKey((Object)"begin")) {
            event.begin = TiConvert.toDate((KrollDict)data, (String)"begin");
            if (event.begin != null) {
                eventValues.put("dtstart", Long.valueOf(event.begin.getTime()));
            }
        }
        if (data.containsKey((Object)"end")) {
            event.end = TiConvert.toDate((KrollDict)data, (String)"end");
            if (event.end != null) {
                eventValues.put("dtend", Long.valueOf(event.end.getTime()));
            }
        }
        if (data.containsKey((Object)"allDay")) {
            event.allDay = TiConvert.toBoolean((KrollDict)data, (String)"allDay");
            eventValues.put("allDay", Integer.valueOf(event.allDay ? 1 : 0));
        }
        if (data.containsKey((Object)"hasExtendedProperties")) {
            event.hasExtendedProperties = TiConvert.toBoolean((KrollDict)data, (String)"hasExtendedProperties");
            eventValues.put("hasExtendedProperties", Integer.valueOf(event.hasExtendedProperties ? 1 : 0));
        }
        if (data.containsKey((Object)"hasAlarm")) {
            event.hasAlarm = TiConvert.toBoolean((KrollDict)data, (String)"hasAlarm");
            eventValues.put("hasAlarm", Integer.valueOf(event.hasAlarm ? 1 : 0));
        }
        Uri eventUri = contentResolver.insert(Uri.parse((String)(CalendarProxy.getBaseCalendarUri() + "/events")), eventValues);
        Log.d((String)"TiEvents", (String)("created event with uri: " + eventUri));
        event.id = eventId = eventUri.getLastPathSegment();
        return event;
    }

    public static ArrayList<EventProxy> queryEventsBetweenDates(TiContext context, long date1, long date2, CalendarProxy calendar) {
        return EventProxy.queryEventsBetweenDates(context, date1, date2, "Calendars._id=" + calendar.getId(), null);
    }

    public ReminderProxy[] getReminders() {
        ArrayList<ReminderProxy> reminders = ReminderProxy.getRemindersForEvent(this.getTiContext(), this);
        return reminders.toArray(new ReminderProxy[reminders.size()]);
    }

    public ReminderProxy createReminder(KrollDict data) {
        int minutes = TiConvert.toInt((KrollDict)data, (String)"minutes");
        int method = 0;
        if (data.containsKey((Object)"method")) {
            method = TiConvert.toInt((KrollDict)data, (String)"method");
        }
        return ReminderProxy.createReminder(this.getTiContext(), this, minutes, method);
    }

    public AlertProxy[] getAlerts() {
        ArrayList<AlertProxy> alerts = AlertProxy.getAlertsForEvent(this.getTiContext(), this);
        return alerts.toArray(new AlertProxy[alerts.size()]);
    }

    public AlertProxy createAlert(KrollDict data) {
        int minutes = TiConvert.toInt((KrollDict)data, (String)"minutes");
        return AlertProxy.createAlert(this.getTiContext(), this, minutes);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean getAllDay() {
        return this.allDay;
    }

    public boolean getHasAlarm() {
        return this.hasAlarm;
    }

    public boolean getHasExtendedProperties() {
        return this.hasExtendedProperties;
    }

    public int getStatus() {
        return this.status;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    public String getRecurrenceDate() {
        return this.recurrenceDate;
    }

    public String getRecurrenceExceptionRule() {
        return this.recurrenceExceptionRule;
    }

    public String getRecurrenceExceptionDate() {
        return this.recurrenceExceptionDate;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public KrollDict getExtendedProperties() {
        KrollDict extendedProperties = new KrollDict();
        ContentResolver contentResolver = this.getTiContext().getActivity().getContentResolver();
        Cursor extPropsCursor = contentResolver.query(Uri.parse((String)EventProxy.getExtendedPropertiesUri()), new String[]{"name", "value"}, "event_id = ?", new String[]{this.getId()}, null);
        while (extPropsCursor.moveToNext()) {
            String name = extPropsCursor.getString(0);
            String value = extPropsCursor.getString(1);
            extendedProperties.put((Object)name, (Object)value);
        }
        extPropsCursor.close();
        return extendedProperties;
    }

    public String getExtendedProperty(String name) {
        ContentResolver contentResolver = this.getTiContext().getActivity().getContentResolver();
        Cursor extPropsCursor = contentResolver.query(Uri.parse((String)EventProxy.getExtendedPropertiesUri()), new String[]{"value"}, "event_id = ? and name = ?", new String[]{this.getId(), name}, null);
        if (extPropsCursor != null && extPropsCursor.getCount() > 0) {
            extPropsCursor.moveToNext();
            String value = extPropsCursor.getString(0);
            extPropsCursor.close();
            return value;
        }
        return null;
    }

    public void setExtendedProperty(String name, String value) {
        if (!this.hasExtendedProperties) {
            this.hasExtendedProperties = true;
        }
        Log.d((String)TAG, (String)("set extended property: " + name + " = " + value));
        ContentResolver contentResolver = this.getTiContext().getActivity().getContentResolver();
        Uri extPropsUri = Uri.parse((String)EventProxy.getExtendedPropertiesUri());
        Cursor results = contentResolver.query(extPropsUri, new String[]{"name"}, "name = ? AND event_id = ?", new String[]{name, this.getId()}, null);
        ContentValues values = new ContentValues();
        values.put("name", name);
        values.put("value", value);
        int count = results.getCount();
        results.close();
        if (count == 1) {
            contentResolver.delete(extPropsUri, "name = ? and event_id = ?", new String[]{name, this.getId()});
        }
        values.put("event_id", this.getId());
        contentResolver.insert(extPropsUri, values);
    }
}

