/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android.calendar;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import ti.modules.titanium.android.calendar.EventProxy;

public class CalendarProxy
extends KrollProxy {
    protected String id;
    protected String name;
    protected boolean selected;
    protected boolean hidden;

    public CalendarProxy(TiContext context, String id, String name, boolean selected, boolean hidden) {
        super(context);
        this.id = id;
        this.name = name;
        this.selected = selected;
        this.hidden = hidden;
    }

    public static String getBaseCalendarUri() {
        if (Build.VERSION.SDK_INT >= 8) {
            return "content://com.android.calendar";
        }
        return "content://calendar";
    }

    public static ArrayList<CalendarProxy> queryCalendars(TiContext context, String query, String[] queryArgs) {
        ArrayList<CalendarProxy> calendars = new ArrayList<CalendarProxy>();
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        Cursor cursor = contentResolver.query(Uri.parse((String)(CalendarProxy.getBaseCalendarUri() + "/calendars")), new String[]{"_id", "displayName", "selected", "hidden"}, query, queryArgs, null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String id = cursor.getString(0);
                String name = cursor.getString(1);
                boolean selected = !cursor.getString(2).equals("0");
                boolean hidden = !cursor.getString(3).equals("0");
                calendars.add(new CalendarProxy(context, id, name, selected, hidden));
            }
        }
        return calendars;
    }

    public EventProxy[] getEventsInYear(int year) {
        Calendar jan1 = Calendar.getInstance();
        jan1.clear();
        jan1.set(year, 0, 1);
        long date1 = jan1.getTimeInMillis();
        long date2 = date1 + 31449600000L;
        ArrayList<EventProxy> events = EventProxy.queryEventsBetweenDates(this.getTiContext(), date1, date2, this);
        return events.toArray(new EventProxy[events.size()]);
    }

    public EventProxy[] getEventsInMonth(int year, int month) {
        Calendar firstOfTheMonth = Calendar.getInstance();
        firstOfTheMonth.clear();
        firstOfTheMonth.set(year, month, 1);
        Calendar lastOfTheMonth = Calendar.getInstance();
        lastOfTheMonth.clear();
        lastOfTheMonth.set(year, month, 1, 23, 59, 59);
        int lastDay = lastOfTheMonth.getActualMaximum(5);
        lastOfTheMonth.set(5, lastDay);
        long date1 = firstOfTheMonth.getTimeInMillis();
        long date2 = lastOfTheMonth.getTimeInMillis();
        ArrayList<EventProxy> events = EventProxy.queryEventsBetweenDates(this.getTiContext(), date1, date2, this);
        return events.toArray(new EventProxy[events.size()]);
    }

    public EventProxy[] getEventsInDate(int year, int month, int day) {
        Calendar beginningOfDay = Calendar.getInstance();
        beginningOfDay.clear();
        beginningOfDay.set(year, month, day, 0, 0, 0);
        Calendar endOfDay = Calendar.getInstance();
        endOfDay.clear();
        endOfDay.set(year, month, day, 23, 59, 59);
        long date1 = beginningOfDay.getTimeInMillis();
        long date2 = endOfDay.getTimeInMillis();
        ArrayList<EventProxy> events = EventProxy.queryEventsBetweenDates(this.getTiContext(), date1, date2, this);
        return events.toArray(new EventProxy[events.size()]);
    }

    public EventProxy[] getEventsBetweenDates(Date date1, Date date2) {
        ArrayList<EventProxy> events = EventProxy.queryEventsBetweenDates(this.getTiContext(), date1.getTime(), date2.getTime(), this);
        return events.toArray(new EventProxy[events.size()]);
    }

    public EventProxy getEventById(int id) {
        ArrayList<EventProxy> events = EventProxy.queryEvents(this.getTiContext(), "_id = ?", new String[]{"" + id});
        if (events.size() > 0) {
            return events.get(0);
        }
        return null;
    }

    public EventProxy createEvent(KrollDict data) {
        return EventProxy.createEvent(this.getTiContext(), this, data);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public boolean getHidden() {
        return this.hidden;
    }
}

