/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android.calendar;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import ti.modules.titanium.android.calendar.AlarmReceiver;
import ti.modules.titanium.android.calendar.CalendarProxy;
import ti.modules.titanium.android.calendar.EventProxy;

public class AlertProxy
extends KrollProxy {
    public static final int STATE_SCHEDULED = 0;
    public static final int STATE_FIRED = 1;
    public static final int STATE_DISMISSED = 2;
    protected String id;
    protected String eventId;
    protected Date begin;
    protected Date end;
    protected Date alarmTime;
    protected int state;
    protected int minutes;
    protected static final String EVENT_REMINDER_ACTION = "android.intent.action.EVENT_REMINDER";

    public AlertProxy(TiContext context) {
        super(context);
    }

    public static String getAlertsUri() {
        return CalendarProxy.getBaseCalendarUri() + "/calendar_alerts";
    }

    public static String getAlertsInstanceUri() {
        return CalendarProxy.getBaseCalendarUri() + "/calendar_alerts/by_instance";
    }

    public static ArrayList<AlertProxy> queryAlerts(TiContext context, String query, String[] queryArgs, String orderBy) {
        ArrayList<AlertProxy> alerts = new ArrayList<AlertProxy>();
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        Cursor cursor = contentResolver.query(Uri.parse((String)AlertProxy.getAlertsUri()), new String[]{"_id", "event_id", "begin", "end", "alarmTime", "state", "minutes"}, query, queryArgs, orderBy);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                AlertProxy alert = new AlertProxy(context);
                alert.id = cursor.getString(0);
                alert.eventId = cursor.getString(1);
                alert.begin = new Date(cursor.getLong(2));
                alert.end = new Date(cursor.getLong(3));
                alert.alarmTime = new Date(cursor.getLong(4));
                alert.state = cursor.getInt(5);
                alert.minutes = cursor.getInt(6);
                alerts.add(alert);
            }
            cursor.close();
        }
        return alerts;
    }

    public static ArrayList<AlertProxy> getAlertsForEvent(TiContext context, EventProxy event) {
        return AlertProxy.queryAlerts(context, "event_id = ?", new String[]{event.getId()}, "alarmTime ASC,begin ASC,title ASC");
    }

    public static AlertProxy createAlert(TiContext context, EventProxy event, int minutes) {
        ContentResolver contentResolver = context.getActivity().getContentResolver();
        ContentValues values = new ContentValues();
        Calendar alarmTime = Calendar.getInstance();
        alarmTime.setTime(event.getBegin());
        alarmTime.add(12, -minutes);
        values.put("event_id", event.getId());
        values.put("begin", Long.valueOf(event.getBegin().getTime()));
        values.put("end", Long.valueOf(event.getEnd().getTime()));
        values.put("alarmTime", Long.valueOf(alarmTime.getTimeInMillis()));
        values.put("state", Integer.valueOf(0));
        values.put("minutes", Integer.valueOf(minutes));
        values.put("creationTime", Long.valueOf(System.currentTimeMillis()));
        values.put("receivedTime", Integer.valueOf(0));
        values.put("notifyTime", Integer.valueOf(0));
        Uri alertUri = contentResolver.insert(Uri.parse((String)AlertProxy.getAlertsUri()), values);
        String alertId = alertUri.getLastPathSegment();
        AlertProxy alert = new AlertProxy(context);
        alert.id = alertId;
        alert.begin = event.getBegin();
        alert.end = event.getEnd();
        alert.alarmTime = alarmTime.getTime();
        alert.state = 0;
        alert.minutes = minutes;
        alert.registerAlertIntent(context);
        return alert;
    }

    protected void registerAlertIntent(TiContext context) {
        Intent intent = new Intent((Context)context.getActivity(), AlarmReceiver.class);
        PendingIntent sender = PendingIntent.getBroadcast((Context)context.getActivity(), (int)0, (Intent)intent, (int)0x10000000);
        AlarmManager manager = (AlarmManager)this.getTiContext().getActivity().getSystemService("alarm");
        manager.set(0, System.currentTimeMillis(), sender);
    }

    public String getId() {
        return this.id;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public Date getAlarmTime() {
        return this.alarmTime;
    }

    public int getState() {
        return this.state;
    }

    public int getMinutes() {
        return this.minutes;
    }
}

