/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.app.properties;

import org.appcelerator.kroll.KrollDefaultValueProvider;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiProperties;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.json.JSONException;
import org.json.JSONObject;

public class PropertiesModule
extends KrollModule {
    private static final String LCAT = "PropertiesModule";
    private TiProperties appProperties;

    public PropertiesModule(TiContext tiContext) {
        super(tiContext);
        this.appProperties = tiContext.getTiApp().getAppProperties();
    }

    public Object getBool(String key, @Kroll.argument(optional=true, defaultValueProvider=DefaultValues.class) Boolean defaultValue) {
        if (!this.appProperties.hasProperty(key)) {
            return defaultValue;
        }
        boolean def = defaultValue == null ? false : defaultValue;
        return this.appProperties.getBool(key, def);
    }

    public Object getDouble(String key, @Kroll.argument(optional=true, defaultValueProvider=DefaultValues.class) Double defaultValue) {
        if (!this.appProperties.hasProperty(key)) {
            return defaultValue;
        }
        double def = defaultValue == null ? 0.0 : defaultValue;
        return this.appProperties.getDouble(key, def);
    }

    public Object getInt(String key, @Kroll.argument(optional=true, defaultValueProvider=DefaultValues.class) Integer defaultValue) {
        if (!this.appProperties.hasProperty(key)) {
            return defaultValue;
        }
        int def = defaultValue == null ? 0 : defaultValue;
        return this.appProperties.getInt(key, def);
    }

    public Object getString(String key, @Kroll.argument(optional=true, defaultValueProvider=DefaultValues.class) String defaultValue) {
        return this.appProperties.getString(key, defaultValue);
    }

    public Object getList(KrollInvocation invocation, String key, @Kroll.argument(optional=true, defaultValueProvider=DefaultValues.class) Object[] defaultValue) {
        String[] values = new String[]{};
        if (this.appProperties.hasListProperty(key)) {
            values = this.appProperties.getList(key, values);
        } else {
            if (defaultValue == null) {
                return null;
            }
            values = TiConvert.toStringArray((Object[])defaultValue);
        }
        Object[] list = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value.startsWith("{") && value.endsWith("}")) {
                try {
                    list[i] = new KrollDict(new JSONObject(value));
                }
                catch (JSONException e) {
                    Log.e((String)LCAT, (String)("Error converting JSON string to KrollDict, property:" + key), (Throwable)e);
                }
                continue;
            }
            list[i] = value;
        }
        return list;
    }

    public boolean hasProperty(String key) {
        return this.appProperties.hasProperty(key);
    }

    public String[] listProperties() {
        return this.appProperties.listProperties();
    }

    public void removeProperty(String key) {
        this.appProperties.removeProperty(key);
    }

    public void setBool(String key, boolean value) {
        this.appProperties.setBool(key, value);
    }

    public void setDouble(String key, double value) {
        this.appProperties.setDouble(key, value);
    }

    public void setInt(String key, int value) {
        this.appProperties.setInt(key, value);
    }

    public void setList(String key, Object[] value) {
        Log.i((String)LCAT, (String)("setList passed with [" + key + "] and a list of [" + value.length + "] items."));
        String[] valueList = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            Object v = value[i];
            valueList[i] = v instanceof KrollDict ? TiConvert.toJSON((KrollDict)((KrollDict)v)).toString() : (v instanceof Object[] ? TiConvert.toJSONArray((Object[])((Object[])v)).toString() : v.toString());
        }
        this.appProperties.setList(key, valueList);
    }

    public void setString(String key, String value) {
        this.appProperties.setString(key, value);
    }

    public static class DefaultValues
    implements KrollDefaultValueProvider {
        protected static DefaultValues _instance = new DefaultValues();

        public Object getDefaultValue(Class<?> clazz) {
            return null;
        }

        public static DefaultValues getInstance() {
            return _instance;
        }
    }
}

