/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.api;

import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiLogger;

public class APIModule
extends KrollModule {
    private static final String LCAT = "TiAPI";
    public static final int TRACE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int NOTICE = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int CRITICAL = 7;
    public static final int FATAL = 8;
    private TiLogger logger = new TiLogger(){

        public void log(int level, String message) {
            APIModule.this.internalLog(level, message);
        }
    };

    public TiLogger getLogger() {
        return this.logger;
    }

    public void setLogger(TiLogger logger) {
        this.logger = logger;
    }

    public APIModule(TiContext tiContext) {
        super(tiContext);
    }

    private String toString(Object msg) {
        if (msg == null) {
            return "null";
        }
        return msg.toString();
    }

    public void debug(Object msg) {
        this.logger.log(2, this.toString(msg));
    }

    public void info(Object msg) {
        this.logger.log(3, this.toString(msg));
    }

    public void warn(Object msg) {
        this.logger.log(5, this.toString(msg));
    }

    public void error(Object msg) {
        this.logger.log(6, this.toString(msg));
    }

    public void trace(Object msg) {
        this.logger.log(1, this.toString(msg));
    }

    public void notice(Object msg) {
        this.logger.log(4, this.toString(msg));
    }

    public void critical(Object msg) {
        this.logger.log(7, this.toString(msg));
    }

    public void fatal(Object msg) {
        this.logger.log(8, this.toString(msg));
    }

    public void log(String level, Object msg) {
        String ulevel = level.toUpperCase();
        int severity = 3;
        if ("TRACE".equals(ulevel)) {
            severity = 1;
        } else if ("DEBUG".equals(ulevel)) {
            severity = 2;
        } else if ("INFO".equals(ulevel)) {
            severity = 3;
        } else if ("NOTICE".equals(ulevel)) {
            severity = 4;
        } else if ("WARN".equals(ulevel)) {
            severity = 5;
        } else if ("ERROR".equals(ulevel)) {
            severity = 6;
        } else if ("CRITICAL".equals(ulevel)) {
            severity = 7;
        } else if ("FATAL".equals(ulevel)) {
            severity = 8;
        } else {
            msg = "[" + level + "] " + msg;
        }
        this.logger.log(severity, this.toString(msg));
    }

    public void internalLog(int severity, String msg) {
        if (severity == 1) {
            Log.v((String)LCAT, (String)msg);
        } else if (severity < 3) {
            Log.d((String)LCAT, (String)msg);
        } else if (severity < 5) {
            Log.i((String)LCAT, (String)msg);
        } else if (severity == 5) {
            Log.w((String)LCAT, (String)msg);
        } else {
            Log.e((String)LCAT, (String)msg);
        }
    }
}

