/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android.notificationmanager;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import java.util.Date;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.android.PendingIntentProxy;
import ti.modules.titanium.android.RemoteViewsProxy;

public class NotificationProxy
extends KrollProxy {
    private static final String LCAT = "TiNotification";
    private static boolean DBG = TiConfig.LOGD;
    protected Notification notification = new Notification(17301642, null, System.currentTimeMillis());

    public NotificationProxy(TiContext tiContext) {
        super(tiContext);
        this.notification.flags = 16;
    }

    public void handleCreationDict(KrollDict d) {
        super.handleCreationDict(d);
        if (d == null) {
            return;
        }
        if (d.containsKey((Object)"icon")) {
            this.setIcon(null, d.get((Object)"icon"));
        }
        if (d.containsKey((Object)"tickerText")) {
            this.setTickerText(TiConvert.toString((KrollDict)d, (String)"tickerText"));
        }
        if (d.containsKey((Object)"when")) {
            this.setWhen(d.get((Object)"when"));
        }
        if (d.containsKey((Object)"audioStreamType")) {
            this.setAudioStreamType(TiConvert.toInt((KrollDict)d, (String)"audioStreamType"));
        }
        if (d.containsKey((Object)"contentView")) {
            this.setContentView((RemoteViewsProxy)((Object)d.get((Object)"contentView")));
        }
        if (d.containsKey((Object)"contentIntent")) {
            this.setContentIntent((PendingIntentProxy)((Object)d.get((Object)"contentIntent")));
        }
        if (d.containsKey((Object)"defaults")) {
            this.setDefaults(TiConvert.toInt((KrollDict)d, (String)"defaults"));
        }
        if (d.containsKey((Object)"deleteIntent")) {
            this.setDeleteIntent((PendingIntentProxy)((Object)d.get((Object)"deleteIntent")));
        }
        if (d.containsKey((Object)"flags")) {
            this.setFlags(TiConvert.toInt((KrollDict)d, (String)"flags"));
        }
        if (d.containsKey((Object)"iconLevel")) {
            this.setIconLevel(TiConvert.toInt((KrollDict)d, (String)"iconLevel"));
        }
        if (d.containsKey((Object)"ledARGB")) {
            this.setLedARGB(TiConvert.toInt((KrollDict)d, (String)"ledARGB"));
        }
        if (d.containsKey((Object)"ledOffMS")) {
            this.setLedOffMS(TiConvert.toInt((KrollDict)d, (String)"ledOffMS"));
        }
        if (d.containsKey((Object)"ledOnMS")) {
            this.setLedOnMS(TiConvert.toInt((KrollDict)d, (String)"ledOnMS"));
        }
        if (d.containsKey((Object)"number")) {
            this.setNumber(TiConvert.toInt((KrollDict)d, (String)"number"));
        }
        if (d.containsKey((Object)"sound")) {
            this.setSound(null, TiConvert.toString((KrollDict)d, (String)"sound"));
        }
        if (d.containsKey((Object)"vibratePattern")) {
            this.setVibratePattern((Object[])d.get((Object)"vibratePattern"));
        }
        this.checkLatestEventInfoProperties(d);
    }

    public void setIcon(KrollInvocation invocation, Object icon) {
        if (icon instanceof Number) {
            this.notification.icon = ((Number)icon).intValue();
        } else {
            String iconUrl = TiConvert.toString((Object)icon);
            TiContext context = invocation == null ? this.getTiContext() : invocation.getTiContext();
            String iconFullUrl = context.resolveUrl(iconUrl);
            this.notification.icon = TiUIHelper.getResourceId((String)iconFullUrl);
            if (this.notification.icon == 0) {
                Log.w((String)LCAT, (String)("No image found for " + iconUrl));
            }
        }
    }

    public void setTickerText(String tickerText) {
        this.notification.tickerText = tickerText;
    }

    public void setWhen(Object when) {
        this.notification.when = when instanceof Date ? ((Date)when).getTime() : Double.valueOf(TiConvert.toDouble((Object)when)).longValue();
    }

    public void setAudioStreamType(int type) {
        this.notification.audioStreamType = type;
    }

    public void setContentView(RemoteViewsProxy contentView) {
        this.notification.contentView = contentView.getRemoteViews();
    }

    public void setContentIntent(PendingIntentProxy contentIntent) {
        this.notification.contentIntent = contentIntent.getPendingIntent();
    }

    public void setDefaults(int defaults) {
        this.notification.defaults = defaults;
    }

    public void setDeleteIntent(PendingIntentProxy deleteIntent) {
        this.notification.deleteIntent = deleteIntent.getPendingIntent();
    }

    public void setFlags(int flags) {
        this.notification.flags = flags;
    }

    public void setIconLevel(int iconLevel) {
        this.notification.iconLevel = iconLevel;
    }

    public void setLedARGB(int ledARGB) {
        this.notification.ledARGB = ledARGB;
    }

    public void setLedOffMS(int ledOffMS) {
        this.notification.ledOffMS = ledOffMS;
    }

    public void setLedOnMS(int ledOnMS) {
        this.notification.ledOnMS = ledOnMS;
    }

    public void setNumber(int number) {
        this.notification.number = number;
    }

    public void setSound(KrollInvocation invocation, String url) {
        TiContext context = invocation == null ? this.getTiContext() : invocation.getTiContext();
        this.notification.sound = Uri.parse((String)context.resolveUrl(url));
    }

    public void setVibratePattern(Object[] pattern) {
        if (pattern != null) {
            this.notification.vibrate = new long[pattern.length];
            for (int i = 0; i < pattern.length; ++i) {
                this.notification.vibrate[i] = Double.valueOf(TiConvert.toDouble((Object)pattern[i])).longValue();
            }
        }
    }

    protected void checkLatestEventInfoProperties(KrollDict d) {
        if (d.containsKeyAndNotNull("contentTitle") || d.containsKeyAndNotNull("contentText")) {
            Activity c;
            String contentTitle = "";
            String contentText = "";
            PendingIntent contentIntent = null;
            if (d.containsKeyAndNotNull("contentTitle")) {
                contentTitle = TiConvert.toString((KrollDict)d, (String)"contentTitle");
            }
            if (d.containsKeyAndNotNull("contentText")) {
                contentText = TiConvert.toString((KrollDict)d, (String)"contentText");
            }
            if (d.containsKey((Object)"contentIntent")) {
                PendingIntentProxy intentProxy = (PendingIntentProxy)((Object)d.get((Object)"contentIntent"));
                contentIntent = intentProxy.getPendingIntent();
            }
            if ((c = this.getTiContext().getActivity()) == null) {
                c = TiApplication.getInstance().getApplicationContext();
            }
            this.notification.setLatestEventInfo((Context)c, (CharSequence)contentTitle, (CharSequence)contentText, contentIntent);
        }
    }

    public void setLatestEventInfo(KrollInvocation invocation, String contentTitle, String contentText, PendingIntentProxy contentIntent) {
        Activity c = invocation.getActivity();
        if (c == null) {
            c = TiApplication.getInstance().getApplicationContext();
        }
        this.notification.setLatestEventInfo((Context)c, (CharSequence)contentTitle, (CharSequence)contentText, contentIntent.getPendingIntent());
    }

    public Notification getNotification() {
        return this.notification;
    }
}

