/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android;

import android.app.Service;
import android.content.Intent;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiBaseService;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.ServiceProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBindingHelper;
import org.appcelerator.titanium.util.TiConfig;

public class TiJSService
extends TiBaseService {
    protected String url = null;
    private static final String LCAT = "TiJSService";
    private static final boolean DBG = TiConfig.LOGD;

    public TiJSService(String url) {
        this.url = url;
    }

    private void finalizeUrl(Intent intent) {
        if (this.url == null) {
            if (intent != null && intent.getDataString() != null) {
                this.url = intent.getDataString();
            } else {
                throw new IllegalStateException("Service url required.");
            }
        }
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        this.finalizeUrl(intent);
        ServiceProxy proxy = this.createProxy(intent);
        this.start(proxy);
    }

    protected void executeServiceCode(ServiceProxy proxy) {
        final TiContext ftiContext = proxy.getTiContext();
        String fullUrl = this.url;
        if (!fullUrl.contains("://") && !fullUrl.startsWith("/") && proxy.getTiContext().getBaseUrl() != null) {
            fullUrl = ftiContext.getBaseUrl() + fullUrl;
        }
        if (DBG) {
            if (this.url != fullUrl) {
                Log.d((String)LCAT, (String)("Eval JS Service:" + this.url + " (" + fullUrl + ")"));
            } else {
                Log.d((String)LCAT, (String)("Eval JS Service:" + this.url));
            }
        }
        final String ffullUrl = fullUrl;
        final ServiceProxy fProxy = proxy;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    fProxy.fireEvent("resume", new KrollDict());
                    ftiContext.evalFile(ffullUrl);
                    fProxy.fireEvent("pause", new KrollDict());
                    fProxy.fireEvent("stop", new KrollDict());
                }
                catch (Throwable e) {
                    Log.e((String)TiJSService.LCAT, (String)("Failure evaluating service JS " + TiJSService.this.url + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }).start();
    }

    protected ServiceProxy createProxy(Intent intent) {
        this.finalizeUrl(intent);
        int lastSlash = this.url.lastIndexOf(47);
        String baseUrl = this.url.substring(0, lastSlash + 1);
        if (baseUrl.length() == 0) {
            baseUrl = null;
        }
        TiContext context = this.createTiContext(intent, baseUrl);
        ServiceProxy proxy = new ServiceProxy(context, (Service)this, intent, this.proxyCounter.incrementAndGet());
        TiBindingHelper.bindCurrentService((TiContext)context, (ServiceProxy)proxy);
        return proxy;
    }

    public void start(ServiceProxy proxy) {
        proxy.fireEvent("start", new KrollDict());
        this.executeServiceCode(proxy);
    }

    public int registerBoundTiContext(int serviceIntentId, TiContext tiContext) {
        if (this.url != null) {
            int lastSlash = this.url.lastIndexOf(47);
            String baseUrl = this.url.substring(0, lastSlash + 1);
            if (baseUrl.length() == 0) {
                baseUrl = null;
            }
            tiContext.setBaseUrl(baseUrl);
        }
        return super.registerBoundTiContext(serviceIntentId, tiContext);
    }
}

