/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.android;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.IntentProxy;
import org.appcelerator.titanium.proxy.ServiceProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBindingHelper;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.android.TiJSService;

public class TiJSIntervalService
extends TiJSService {
    private static final String LCAT = "TiJSIntervalService";
    private static final boolean DBG = TiConfig.LOGD;
    private List<IntervalServiceRunner> runners = null;

    public TiJSIntervalService(String url) {
        super(url);
    }

    @Override
    protected void executeServiceCode(ServiceProxy proxy) {
        String fullUrl;
        String EXTRA_NAME = "interval";
        IntentProxy intentProxy = proxy.getIntent();
        if (intentProxy == null || !intentProxy.hasExtra("interval")) {
            Log.w((String)LCAT, (String)"The intent is missing the extra value 'interval', therefore the code will be executed only once.");
            super.executeServiceCode(proxy);
            return;
        }
        Intent intent = intentProxy.getIntent();
        Bundle extras = intent.getExtras();
        Object intervalObj = extras.get("interval");
        long interval = -1L;
        if (intervalObj instanceof Number) {
            interval = ((Number)intervalObj).longValue();
        }
        if (interval < 0L) {
            Log.w((String)LCAT, (String)"The intent's extra 'interval' value is negative or non-numeric, therefore the code will be executed only once.");
            super.executeServiceCode(proxy);
            return;
        }
        if (this.runners == null) {
            this.runners = Collections.synchronizedList(new ArrayList());
        }
        if (!(fullUrl = this.url).contains("://") && !fullUrl.startsWith("/") && proxy.getTiContext().getBaseUrl() != null) {
            fullUrl = proxy.getTiContext().getBaseUrl() + fullUrl;
        }
        IntervalServiceRunner runner = new IntervalServiceRunner((Service)this, proxy, interval, fullUrl);
        this.runners.add(runner);
        runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntervalServiceRunner findRunnerOfContext(TiContext context) {
        if (this.runners != null) {
            List<IntervalServiceRunner> list = this.runners;
            synchronized (list) {
                for (IntervalServiceRunner runner : this.runners) {
                    if (runner.getTiContext() != context) continue;
                    return runner;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRunners() {
        try {
            if (this.runners != null) {
                List<IntervalServiceRunner> list = this.runners;
                synchronized (list) {
                    for (IntervalServiceRunner runner : this.runners) {
                        runner.stop();
                    }
                }
            }
            this.runners.clear();
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)("Thrown while clearing interval service runners: " + t.getMessage()), (Throwable)t);
        }
    }

    public void onDestroy() {
        this.destroyRunners();
        super.onDestroy();
    }

    protected void unbindContext(TiContext context) {
        IntervalServiceRunner runner = this.findRunnerOfContext(context);
        if (runner != null) {
            if (DBG) {
                Log.d((String)LCAT, (String)"Stopping IntervalServiceRunner because of unbind");
            }
            runner.stop();
        }
        this.runners.remove(runner);
    }

    private class IntervalServiceRunner {
        private long interval;
        private ServiceProxy proxy;
        private TiContext tiContext;
        private Timer timer = null;
        private TimerTask task = null;
        private String serviceSimpleName;
        private String url;
        private AtomicInteger counter = new AtomicInteger();

        IntervalServiceRunner(Service service, ServiceProxy proxy, long interval, String url) {
            this.proxy = proxy;
            this.tiContext = proxy.getTiContext();
            this.interval = interval;
            this.url = url;
            this.serviceSimpleName = service.getClass().getSimpleName();
        }

        TiContext getTiContext() {
            return this.tiContext;
        }

        private void destroyTimer() {
            try {
                if (this.task != null) {
                    if (DBG) {
                        Log.d((String)TiJSIntervalService.LCAT, (String)"Canceling TimerTask");
                    }
                    this.task.cancel();
                    this.task = null;
                }
                if (this.timer != null) {
                    if (DBG) {
                        Log.d((String)TiJSIntervalService.LCAT, (String)"Canceling Timer");
                    }
                    this.timer.cancel();
                    this.timer.purge();
                    this.timer = null;
                }
            }
            catch (Throwable t) {
                Log.w((String)TiJSIntervalService.LCAT, (String)("Thrown while destroying timer: " + t.getMessage()), (Throwable)t);
            }
        }

        void stop() {
            if (DBG) {
                Log.d((String)TiJSIntervalService.LCAT, (String)"stop runner");
            }
            if (this.proxy != null) {
                this.proxy.fireEvent("stop", new KrollDict());
            }
            this.destroyTimer();
        }

        void start() {
            if (DBG) {
                Log.d((String)TiJSIntervalService.LCAT, (String)"start runner");
            }
            this.task = new TimerTask(){

                @Override
                public void run() {
                    int iteration = IntervalServiceRunner.this.counter.incrementAndGet();
                    try {
                        TiBindingHelper.bindCurrentService((TiContext)IntervalServiceRunner.this.tiContext, (ServiceProxy)IntervalServiceRunner.this.proxy);
                        KrollDict event = new KrollDict();
                        event.put((Object)"iteration", (Object)iteration);
                        IntervalServiceRunner.this.proxy.fireEvent("resume", event);
                        IntervalServiceRunner.this.tiContext.evalFile(IntervalServiceRunner.this.url);
                        IntervalServiceRunner.this.proxy.fireEvent("pause", event);
                    }
                    catch (Throwable e) {
                        Log.e((String)TiJSIntervalService.LCAT, (String)("Failure evaluating service JS " + IntervalServiceRunner.this.url + ": " + e.getMessage()), (Throwable)e);
                    }
                }
            };
            this.timer = new Timer(this.serviceSimpleName + "_Timer_" + this.proxy.getServiceInstanceId());
            this.timer.schedule(this.task, 0L, this.interval);
        }
    }
}

