/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.accelerometer;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiSensorHelper;

public class AccelerometerModule
extends KrollModule
implements SensorEventListener {
    private static final String LCAT = "TiAccelerometer";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String EVENT_UPDATE = "update";
    private boolean accelerometerRegistered = false;
    private long lastSensorEventTimestamp = 0L;

    public AccelerometerModule(TiContext tiContext) {
        super(tiContext);
    }

    public int addEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if (!this.accelerometerRegistered && EVENT_UPDATE.equals(eventName)) {
            TiSensorHelper.registerListener((int)1, (SensorEventListener)this, (int)2);
            this.accelerometerRegistered = true;
        }
        return super.addEventListener(invocation, eventName, listener);
    }

    public void removeEventListener(KrollInvocation invocation, String eventName, Object listener) {
        if (this.accelerometerRegistered && EVENT_UPDATE.equals(eventName)) {
            TiSensorHelper.unregisterListener((int)1, (SensorEventListener)this);
            this.accelerometerRegistered = false;
        }
        super.removeEventListener(invocation, eventName, listener);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.timestamp - this.lastSensorEventTimestamp > 100L) {
            this.lastSensorEventTimestamp = event.timestamp;
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            KrollDict data = new KrollDict();
            data.put((Object)"type", (Object)EVENT_UPDATE);
            data.put((Object)"timestamp", (Object)this.lastSensorEventTimestamp);
            data.put((Object)"x", (Object)Float.valueOf(x));
            data.put((Object)"y", (Object)Float.valueOf(y));
            data.put((Object)"z", (Object)Float.valueOf(z));
            this.fireEvent(EVENT_UPDATE, data);
        }
    }
}

