/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableObject;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SourceProvider;

public class Dim {
    public static final int STEP_OVER = 0;
    public static final int STEP_INTO = 1;
    public static final int STEP_OUT = 2;
    public static final int GO = 3;
    public static final int BREAK = 4;
    public static final int EXIT = 5;
    private static final int IPROXY_DEBUG = 0;
    private static final int IPROXY_LISTEN = 1;
    private static final int IPROXY_COMPILE_SCRIPT = 2;
    private static final int IPROXY_EVAL_SCRIPT = 3;
    private static final int IPROXY_STRING_IS_COMPILABLE = 4;
    private static final int IPROXY_OBJECT_TO_STRING = 5;
    private static final int IPROXY_OBJECT_PROPERTY = 6;
    private static final int IPROXY_OBJECT_IDS = 7;
    private GuiCallback callback;
    private boolean breakFlag;
    private ArrayList<Long> breakThreadIds = new ArrayList();
    private ScopeProvider scopeProvider;
    private SourceProvider sourceProvider;
    private int frameIndex = -1;
    private volatile ContextData interruptedContextData;
    private ContextFactory contextFactory;
    private Object monitor = new Object();
    private Object eventThreadMonitor = new Object();
    private volatile int returnValue = -1;
    private boolean insideInterruptLoop;
    private String evalRequest;
    private Scriptable evalScope;
    private Scriptable evalThisObj;
    private Object evalResult;
    private boolean breakOnExceptions;
    private ArrayList<String> exceptionBreakpoints = new ArrayList();
    private boolean breakOnEnter;
    private boolean breakOnReturn;
    private final Map<String, SourceInfo> urlToSourceInfo = Collections.synchronizedMap(new HashMap());
    private final Map<String, FunctionSource> functionNames = Collections.synchronizedMap(new HashMap());
    private final Map<DebuggableScript, FunctionSource> functionToSource = Collections.synchronizedMap(new HashMap());
    private DimIProxy listener;
    private Logger logger = null;

    public void setGuiCallback(GuiCallback callback) {
        this.callback = callback;
    }

    public void setBreak() {
        this.breakFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreakThread(long threadId) {
        ArrayList<Long> arrayList = this.breakThreadIds;
        synchronized (arrayList) {
            if (!this.breakThreadIds.contains(threadId)) {
                if (this.logger != null) {
                    this.logger.fine("break when thread enters again: " + threadId);
                }
                this.breakThreadIds.add(threadId);
            }
        }
        if (this.logger != null) {
            this.logger.fine("current break thread ids: " + this.breakThreadIds);
        }
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public void contextSwitch(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public void setBreakOnExceptions(boolean breakOnExceptions) {
        this.breakOnExceptions = breakOnExceptions;
    }

    public void setBreakOnEnter(boolean breakOnEnter) {
        this.breakOnEnter = breakOnEnter;
    }

    public void setBreakOnReturn(boolean breakOnReturn) {
        this.breakOnReturn = breakOnReturn;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void attachTo(ContextFactory factory) {
        this.detach();
        this.contextFactory = factory;
        this.listener = new DimIProxy(this, 1);
        factory.addListener(this.listener);
    }

    public void attachTo(Context context) {
        ContextData contextData = new ContextData();
        DimIProxy debugger = new DimIProxy(this, 0);
        context.setDebugger(debugger, contextData);
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
    }

    public void detach() {
        if (this.listener != null) {
            this.contextFactory.removeListener(this.listener);
            this.contextFactory = null;
            this.listener = null;
        }
    }

    public void dispose() {
        this.detach();
    }

    private FunctionSource getFunctionSource(DebuggableScript fnOrScript) {
        String source;
        String url;
        SourceInfo si;
        FunctionSource fsource = this.functionSource(fnOrScript);
        if (fsource == null && (si = this.sourceInfo(url = this.getNormalizedUrl(fnOrScript))) == null && !fnOrScript.isGeneratedScript() && (source = this.loadSource(url)) != null) {
            DebuggableScript parent;
            DebuggableScript top = fnOrScript;
            while ((parent = top.getParent()) != null) {
                top = parent;
            }
            this.registerTopScript(top, source);
            fsource = this.functionSource(fnOrScript);
        }
        return fsource;
    }

    private String loadSource(String sourceUrl) {
        String source = null;
        int hash = sourceUrl.indexOf(35);
        if (hash >= 0) {
            sourceUrl = sourceUrl.substring(0, hash);
        }
        try {
            InputStream is;
            block10: {
                if (sourceUrl.indexOf(58) < 0) {
                    block11: {
                        try {
                            String pathFromHome;
                            File f;
                            String home;
                            if (sourceUrl.startsWith("~/") && (home = SecurityUtilities.getSystemProperty("user.home")) != null && (f = new File(new File(home), pathFromHome = sourceUrl.substring(2))).exists()) {
                                is = new FileInputStream(f);
                                break block10;
                            }
                            File f2 = new File(sourceUrl);
                            if (!f2.exists()) break block11;
                            is = new FileInputStream(f2);
                            break block10;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    sourceUrl = sourceUrl.startsWith("//") ? "http:" + sourceUrl : (sourceUrl.startsWith("/") ? "http://127.0.0.1" + sourceUrl : "http://" + sourceUrl);
                }
                is = new URL(sourceUrl).openStream();
            }
            try {
                source = Kit.readReader(new InputStreamReader(is));
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to load source from " + sourceUrl + ": " + ex);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTopScript(DebuggableScript topScript, String source) {
        String providedSource;
        if (!topScript.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        String url = this.getNormalizedUrl(topScript);
        DebuggableScript[] functions = Dim.getAllFunctions(topScript);
        if (this.sourceProvider != null && (providedSource = this.sourceProvider.getSource(topScript)) != null) {
            source = providedSource;
        }
        SourceInfo sourceInfo = new SourceInfo(source, functions, url);
        Map<Object, Object> map = this.urlToSourceInfo;
        synchronized (map) {
            SourceInfo old = this.urlToSourceInfo.get(url);
            if (old != null) {
                sourceInfo.copyBreakpointsFrom(old);
            }
            this.urlToSourceInfo.put(url, sourceInfo);
            int i = 0;
            while (i != sourceInfo.functionSourcesTop()) {
                FunctionSource fsource = sourceInfo.functionSource(i);
                String name = fsource.name();
                if (name.length() != 0) {
                    this.functionNames.put(name, fsource);
                }
                ++i;
            }
        }
        map = this.functionToSource;
        synchronized (map) {
            int i = 0;
            while (i != functions.length) {
                FunctionSource fsource = sourceInfo.functionSource(i);
                this.functionToSource.put(functions[i], fsource);
                ++i;
            }
        }
        this.callback.updateSourceText(sourceInfo);
    }

    private FunctionSource functionSource(DebuggableScript fnOrScript) {
        return this.functionToSource.get(fnOrScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] functionNames() {
        Map<String, SourceInfo> map = this.urlToSourceInfo;
        synchronized (map) {
            return this.functionNames.keySet().toArray(new String[this.functionNames.size()]);
        }
    }

    public FunctionSource functionSourceByName(String functionName) {
        return this.functionNames.get(functionName);
    }

    public SourceInfo sourceInfo(String url) {
        return this.urlToSourceInfo.get(url);
    }

    private String getNormalizedUrl(DebuggableScript fnOrScript) {
        String url = fnOrScript.getSourceName();
        if (url == null) {
            url = "<stdin>";
        } else {
            int searchStart;
            int evalSeparator = 35;
            StringBuffer sb = null;
            int urlLength = url.length();
            int cursor = 0;
            while ((searchStart = url.indexOf(evalSeparator, cursor)) >= 0) {
                String replace = null;
                int i = searchStart + 1;
                while (i != urlLength) {
                    char c = url.charAt(i);
                    if ('0' > c || c > '9') break;
                    ++i;
                }
                if (i != searchStart + 1 && "(eval)".regionMatches(0, url, i, 6)) {
                    cursor = i + 6;
                    replace = "(eval)";
                }
                if (replace == null) break;
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(url.substring(0, searchStart));
                }
                sb.append(replace);
            }
            if (sb != null) {
                if (cursor != urlLength) {
                    sb.append(url.substring(cursor));
                }
                url = sb.toString();
            }
        }
        return url;
    }

    private static DebuggableScript[] getAllFunctions(DebuggableScript function) {
        ObjArray functions = new ObjArray();
        Dim.collectFunctions_r(function, functions);
        Object[] result = new DebuggableScript[functions.size()];
        functions.toArray(result);
        return result;
    }

    private static void collectFunctions_r(DebuggableScript function, ObjArray array) {
        array.add(function);
        int i = 0;
        while (i != function.getFunctionCount()) {
            Dim.collectFunctions_r(function.getFunction(i), array);
            ++i;
        }
    }

    public void clearAllBreakpoints() {
        for (SourceInfo si : this.urlToSourceInfo.values()) {
            si.removeAllBreakpoints();
        }
    }

    private void handleBreakpointHit(StackFrame frame, Context cx) {
        this.breakFlag = false;
        this.interrupted(cx, frame, null);
    }

    private void handleBreakpointConditionException(StackFrame frame, Context cx, Throwable ex) {
        this.breakFlag = false;
        ContextData cd = frame.contextData();
        cd.lastProcessedException = ex;
        this.interrupted(cx, frame, ex);
    }

    private void handleExceptionThrown(Context cx, Throwable ex, StackFrame frame) {
        ContextData cd = frame.contextData();
        if ((this.breakOnExceptions || this.shouldBreakOnException(ex)) && cd.lastProcessedException != ex) {
            this.interrupted(cx, frame, ex);
            cd.lastProcessedException = ex;
        }
    }

    public void addExceptionBreakpoint(String exceptionType) {
        this.exceptionBreakpoints.add(exceptionType);
    }

    public boolean shouldBreakOnException(Throwable exception) {
        Scriptable error;
        Object name;
        JavaScriptException jsException;
        Object value;
        return exception instanceof JavaScriptException && (value = (jsException = (JavaScriptException)exception).getValue()) instanceof Scriptable && this.exceptionBreakpoints.contains(name = (error = (Scriptable)value).getPrototype().get("name", error));
    }

    public void removeExceptionBreakpoint(String exceptionType) {
        this.exceptionBreakpoints.remove(exceptionType);
    }

    public ContextData currentContextData() {
        return this.interruptedContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnValue(int returnValue) {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = returnValue;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = 3;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(Scriptable scope, Scriptable thisObj, String expr) {
        Object result = Undefined.instance;
        if (expr == null) {
            return result;
        }
        ContextData contextData = this.currentContextData();
        if (contextData == null || contextData.eventThreadFlag) {
            Context cx = Context.getCurrentContext();
            result = Dim.do_eval(cx, scope, thisObj, expr);
        } else {
            Object object = this.monitor;
            synchronized (object) {
                if (this.insideInterruptLoop) {
                    this.evalRequest = expr;
                    this.evalScope = scope;
                    this.evalThisObj = thisObj;
                    this.monitor.notify();
                    do {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException exc) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    } while (this.evalRequest != null);
                    result = this.evalResult;
                }
            }
        }
        return result;
    }

    public Object eval(String expr) {
        String result = "undefined";
        ContextData contextData = this.currentContextData();
        if (contextData == null || this.frameIndex >= contextData.frameCount()) {
            return result;
        }
        StackFrame frame = contextData.getFrame(this.frameIndex);
        return this.eval(frame.scope, frame.thisObj, expr);
    }

    public void compileScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 2);
        action.url = url;
        action.text = text;
        action.withContext();
    }

    public void evalScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 3);
        action.url = url;
        action.text = text;
        action.withContext();
    }

    public String objectToString(Object object) {
        DimIProxy action = new DimIProxy(this, 5);
        action.object = object;
        action.withContext();
        return action.stringResult;
    }

    public boolean stringIsCompilableUnit(String str) {
        DimIProxy action = new DimIProxy(this, 4);
        action.text = str;
        action.withContext();
        return action.booleanResult;
    }

    public Object getObjectProperty(Object object, Object id) {
        DimIProxy action = new DimIProxy(this, 6);
        action.object = object;
        action.id = id;
        action.withContext();
        return action.objectResult;
    }

    public Object[] getObjectIds(Object object) {
        DimIProxy action = new DimIProxy(this, 7);
        action.object = object;
        action.withContext();
        return action.objectArrayResult;
    }

    private Object getObjectPropertyImpl(Context cx, Object object, Object id) {
        Object result;
        Scriptable scriptable = (Scriptable)object;
        if (id instanceof String) {
            String name = (String)id;
            if (name.equals("this")) {
                result = scriptable;
            } else if (name.equals("__proto__")) {
                result = scriptable.getPrototype();
            } else if (name.equals("__parent__")) {
                result = scriptable.getParentScope();
            } else {
                result = ScriptableObject.getProperty(scriptable, name);
                if (result == ScriptableObject.NOT_FOUND) {
                    result = Undefined.instance;
                }
            }
        } else {
            int index = (Integer)id;
            result = ScriptableObject.getProperty(scriptable, index);
            if (result == ScriptableObject.NOT_FOUND) {
                result = Undefined.instance;
            }
        }
        return result;
    }

    private Object[] getObjectIdsImpl(Context cx, Object object) {
        if (!(object instanceof Scriptable) || object == Undefined.instance) {
            return Context.emptyArgs;
        }
        Scriptable scriptable = (Scriptable)object;
        Object[] ids = scriptable instanceof DebuggableObject ? ((DebuggableObject)((Object)scriptable)).getAllIds() : scriptable.getIds();
        Scriptable proto = scriptable.getPrototype();
        Scriptable parent = scriptable.getParentScope();
        int extra = 0;
        if (proto != null) {
            ++extra;
        }
        if (parent != null) {
            ++extra;
        }
        if (extra != 0) {
            Object[] tmp = new Object[extra + ids.length];
            System.arraycopy(ids, 0, tmp, extra, ids.length);
            ids = tmp;
            extra = 0;
            if (proto != null) {
                ids[extra++] = "__proto__";
            }
            if (parent != null) {
                ids[extra++] = "__parent__";
            }
        }
        return ids;
    }

    /*
     * Exception decompiling
     */
    private void interrupted(Context cx, StackFrame frame, Throwable scriptException) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object do_eval(Context cx, Scriptable scope, Scriptable thisObj, String expr) {
        Object result;
        Debugger saved_debugger = cx.getDebugger();
        Object saved_data = cx.getDebuggerContextData();
        int saved_level = cx.getOptimizationLevel();
        cx.setDebugger(null, null);
        cx.setOptimizationLevel(-1);
        cx.setGeneratingDebug(false);
        try {
            try {
                Callable script = (Callable)((Object)cx.compileString(expr, "", 0, null));
                result = script.call(cx, scope, thisObj, ScriptRuntime.emptyArgs);
            }
            catch (Exception exc) {
                result = exc;
                cx.setGeneratingDebug(true);
                cx.setOptimizationLevel(saved_level);
                cx.setDebugger(saved_debugger, saved_data);
            }
        }
        finally {
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(saved_level);
            cx.setDebugger(saved_debugger, saved_data);
        }
        return result;
    }

    public static class Condition {
        public int hitCount = 1;
        public int currentHit = 0;
        public String condition;
        public Type conditionType;
        public Script compiledCondition;
        public Object currentConditionValue;

        public Condition(String condition, Type type) {
            this.condition = condition;
            this.conditionType = type;
        }

        public boolean shouldBreak(Context context, Scriptable scope, Scriptable thisObj) {
            ++this.currentHit;
            if (this.currentHit < this.hitCount) {
                return false;
            }
            if (this.condition == null) {
                return true;
            }
            if (this.compiledCondition == null) {
                this.compiledCondition = context.compileString(this.condition, "<expr>", 1, null);
            }
            Function fn = (Function)((Object)this.compiledCondition);
            Object result = fn.call(context, scope, thisObj, ScriptRuntime.emptyArgs);
            if (this.conditionType == Type.OnValueChange) {
                if (result == null && this.currentConditionValue != null) {
                    this.currentConditionValue = null;
                    return true;
                }
                if (result != null && !result.equals(this.currentConditionValue)) {
                    this.currentConditionValue = result;
                    return true;
                }
            } else if (this.conditionType == Type.OnTrue) {
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                if (result != null) {
                    return Boolean.parseBoolean(result.toString());
                }
            }
            return false;
        }

        public static enum Type {
            OnTrue,
            OnValueChange;

        }
    }

    public static class ContextData {
        private ObjArray frameStack = new ObjArray();
        private boolean breakNextLine;
        private int stopAtFrameDepth = -1;
        private boolean eventThreadFlag;
        private Throwable lastProcessedException;

        public static ContextData get(Context cx) {
            return (ContextData)cx.getDebuggerContextData();
        }

        public int frameCount() {
            return this.frameStack.size();
        }

        public StackFrame getFrame(int frameNumber) {
            int num = this.frameStack.size() - frameNumber - 1;
            return (StackFrame)this.frameStack.get(num);
        }

        private void pushFrame(StackFrame frame) {
            this.frameStack.push(frame);
        }

        private void popFrame() {
            this.frameStack.pop();
        }

        static /* synthetic */ void access$9(ContextData contextData, boolean bl) {
            contextData.eventThreadFlag = bl;
        }
    }

    private static class DimIProxy
    implements ContextAction,
    ContextFactory.Listener,
    Debugger {
        private Dim dim;
        private int type;
        private String url;
        private String text;
        private Object object;
        private Object id;
        private boolean booleanResult;
        private String stringResult;
        private Object objectResult;
        private Object[] objectArrayResult;

        private DimIProxy(Dim dim, int type) {
            this.dim = dim;
            this.type = type;
        }

        @Override
        public Object run(Context cx) {
            switch (this.type) {
                case 2: {
                    cx.compileString(this.text, this.url, 1, null);
                    break;
                }
                case 3: {
                    Scriptable scope = null;
                    if (this.dim.scopeProvider != null) {
                        scope = this.dim.scopeProvider.getScope();
                    }
                    if (scope == null) {
                        scope = new ImporterTopLevel(cx);
                    }
                    cx.evaluateString(scope, this.text, this.url, 1, null);
                    break;
                }
                case 4: {
                    this.booleanResult = cx.stringIsCompilableUnit(this.text);
                    break;
                }
                case 5: {
                    if (this.object == Undefined.instance) {
                        this.stringResult = "undefined";
                        break;
                    }
                    if (this.object == null) {
                        this.stringResult = "null";
                        break;
                    }
                    if (this.object instanceof NativeCall) {
                        this.stringResult = "[object Call]";
                        break;
                    }
                    this.stringResult = Context.toString(this.object);
                    break;
                }
                case 6: {
                    this.objectResult = this.dim.getObjectPropertyImpl(cx, this.object, this.id);
                    break;
                }
                case 7: {
                    this.objectArrayResult = this.dim.getObjectIdsImpl(cx, this.object);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            return null;
        }

        private void withContext() {
            this.dim.contextFactory.call(this);
        }

        @Override
        public void contextCreated(Context cx) {
            if (this.type != 1) {
                Kit.codeBug();
            }
            ContextData contextData = new ContextData();
            DimIProxy debugger = new DimIProxy(this.dim, 0);
            cx.setDebugger(debugger, contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
        }

        @Override
        public void contextReleased(Context cx) {
            if (this.type != 1) {
                Kit.codeBug();
            }
        }

        @Override
        public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
            FunctionSource item;
            if (this.type != 0) {
                Kit.codeBug();
            }
            if ((item = this.dim.getFunctionSource(fnOrScript)) == null) {
                return null;
            }
            return new StackFrame(cx, this.dim, item);
        }

        @Override
        public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
            if (this.type != 0) {
                Kit.codeBug();
            }
            if (!fnOrScript.isTopLevel()) {
                return;
            }
            this.dim.registerTopScript(fnOrScript, source);
        }
    }

    public static class FunctionSource {
        private SourceInfo sourceInfo;
        private int firstLine;
        private String name;

        private FunctionSource(SourceInfo sourceInfo, int firstLine, String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.sourceInfo = sourceInfo;
            this.firstLine = firstLine;
            this.name = name;
        }

        public SourceInfo sourceInfo() {
            return this.sourceInfo;
        }

        public int firstLine() {
            return this.firstLine;
        }

        public String name() {
            return this.name;
        }
    }

    public static class SourceInfo {
        private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
        private String source;
        private String url;
        private boolean[] breakableLines;
        private boolean[] breakpoints;
        private Condition[] conditions;
        private FunctionSource[] functionSources;

        private SourceInfo(String source, DebuggableScript[] functions, String normilizedUrl) {
            this.source = source;
            this.url = normilizedUrl;
            int N = functions.length;
            int[][] lineArrays = new int[N][];
            int i = 0;
            while (i != N) {
                lineArrays[i] = functions[i].getLineNumbers();
                ++i;
            }
            int minAll = 0;
            int maxAll = -1;
            int[] firstLines = new int[N];
            int i2 = 0;
            while (i2 != N) {
                int[] lines = lineArrays[i2];
                if (lines == null || lines.length == 0) {
                    firstLines[i2] = -1;
                } else {
                    int max;
                    int min = max = lines[0];
                    int j = 1;
                    while (j != lines.length) {
                        int line = lines[j];
                        if (line < min) {
                            min = line;
                        } else if (line > max) {
                            max = line;
                        }
                        ++j;
                    }
                    firstLines[i2] = min;
                    if (minAll > maxAll) {
                        minAll = min;
                        maxAll = max;
                    } else {
                        if (min < minAll) {
                            minAll = min;
                        }
                        if (max > maxAll) {
                            maxAll = max;
                        }
                    }
                }
                ++i2;
            }
            if (minAll > maxAll) {
                this.breakableLines = EMPTY_BOOLEAN_ARRAY;
                this.breakpoints = EMPTY_BOOLEAN_ARRAY;
                this.conditions = new Condition[0];
            } else {
                if (minAll < 0) {
                    throw new IllegalStateException(String.valueOf(minAll));
                }
                int linesTop = maxAll + 1;
                this.breakableLines = new boolean[linesTop];
                this.breakpoints = new boolean[linesTop];
                this.conditions = new Condition[linesTop];
                int i3 = 0;
                while (i3 != N) {
                    int[] lines = lineArrays[i3];
                    if (lines != null && lines.length != 0) {
                        int j = 0;
                        while (j != lines.length) {
                            int line = lines[j];
                            this.breakableLines[line] = true;
                            ++j;
                        }
                    }
                    ++i3;
                }
            }
            this.functionSources = new FunctionSource[N];
            i2 = 0;
            while (i2 != N) {
                String name = functions[i2].getFunctionName();
                if (name == null) {
                    name = "";
                }
                this.functionSources[i2] = new FunctionSource(this, firstLines[i2], name);
                ++i2;
            }
        }

        public String source() {
            return this.source;
        }

        public String url() {
            return this.url;
        }

        public int functionSourcesTop() {
            return this.functionSources.length;
        }

        public FunctionSource functionSource(int i) {
            return this.functionSources[i];
        }

        private void copyBreakpointsFrom(SourceInfo old) {
            int end = old.breakpoints.length;
            if (end > this.breakpoints.length) {
                end = this.breakpoints.length;
            }
            int line = 0;
            while (line != end) {
                if (old.breakpoints[line]) {
                    this.breakpoints[line] = true;
                }
                this.conditions[line] = old.conditions[line];
                ++line;
            }
        }

        public boolean breakableLine(int line) {
            return line < this.breakableLines.length && this.breakableLines[line];
        }

        public boolean breakpoint(int line) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            return line < this.breakpoints.length && this.breakpoints[line];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean breakpoint(int line, boolean value) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                boolean changed;
                if (this.breakpoints[line] != value) {
                    this.breakpoints[line] = value;
                    changed = true;
                } else {
                    changed = false;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return changed;
            }
        }

        public Condition getCondition(int line) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            if (line < this.conditions.length) {
                return this.conditions[line];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCondition(int line, Condition condition) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            Condition[] conditionArray = this.conditions;
            synchronized (this.conditions) {
                this.conditions[line] = condition;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllBreakpoints() {
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                int line = 0;
                while (line != this.breakpoints.length) {
                    this.breakpoints[line] = false;
                    ++line;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static class StackFrame
    implements DebugFrame {
        private Dim dim;
        private ContextData contextData;
        private Scriptable scope;
        private Scriptable thisObj;
        private Object[] args;
        private FunctionSource fsource;
        private boolean[] breakpoints;
        private int lineNumber;

        private StackFrame(Context cx, Dim dim, FunctionSource fsource) {
            this.dim = dim;
            this.contextData = ContextData.get(cx);
            this.fsource = fsource;
            this.breakpoints = fsource.sourceInfo().breakpoints;
            this.lineNumber = fsource.firstLine();
        }

        @Override
        public void onEnter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.contextData.pushFrame(this);
            this.args = args;
            this.scope = scope;
            this.thisObj = thisObj;
            if (this.dim.breakOnEnter) {
                this.dim.handleBreakpointHit(this, cx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLineChange(Context cx, int lineno) {
            String url = this.fsource.sourceInfo().url();
            long threadId = Thread.currentThread().getId();
            if (this.dim.logger != null) {
                this.dim.logger.fine("onLineChange, thread id: " + threadId + ", url: " + url + ", cx: " + cx + ", lineno: " + lineno);
            }
            this.lineNumber = lineno;
            boolean checkCondition = true;
            if (!this.breakpoints[lineno] && !this.dim.breakFlag) {
                boolean lineBreak = this.contextData.breakNextLine;
                if (lineBreak && this.contextData.stopAtFrameDepth >= 0) {
                    boolean bl = lineBreak = this.contextData.frameCount() <= this.contextData.stopAtFrameDepth;
                }
                if (!lineBreak) {
                    ArrayList arrayList = this.dim.breakThreadIds;
                    synchronized (arrayList) {
                        if (!this.dim.breakThreadIds.contains(threadId)) {
                            return;
                        }
                        if (this.dim.logger != null) {
                            this.dim.logger.fine("breaking on url: " + url + ", context " + cx + ", removing from breakContexts");
                        }
                        this.dim.breakThreadIds.remove(threadId);
                    }
                }
                this.contextData.stopAtFrameDepth = -1;
                this.contextData.breakNextLine = false;
                checkCondition = false;
            } else if (this.dim.breakFlag) {
                checkCondition = false;
            }
            boolean hit = true;
            if (checkCondition) {
                Condition condition;
                if (this.dim.logger != null) {
                    this.dim.logger.fine("checking condition for breakpoint at line " + lineno + ", url: " + url);
                }
                if ((condition = this.fsource.sourceInfo().getCondition(lineno)) != null) {
                    try {
                        if (!condition.shouldBreak(cx, this.scope, this.thisObj)) {
                            if (this.dim.logger != null) {
                                this.dim.logger.fine("skipping breakpoint, condition failed");
                            }
                            hit = false;
                        }
                    }
                    catch (Exception e) {
                        if (this.dim.logger != null) {
                            this.dim.logger.fine("caught exception while evaluating condition, breaking and reporting: " + e);
                        }
                        this.dim.handleBreakpointConditionException(this, cx, e);
                        return;
                    }
                }
            }
            if (hit) {
                if (this.dim.logger != null) {
                    this.dim.logger.fine("handlin breakpoint hit for url: " + url + ", context: " + cx);
                }
                this.dim.handleBreakpointHit(this, cx);
            }
        }

        @Override
        public void onExceptionThrown(Context cx, Throwable exception) {
            this.dim.handleExceptionThrown(cx, exception, this);
        }

        @Override
        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            this.args = null;
            if (this.dim.breakOnReturn && !byThrow) {
                this.dim.handleBreakpointHit(this, cx);
            }
            this.contextData.popFrame();
        }

        @Override
        public void onDebuggerStatement(Context cx) {
            this.dim.handleBreakpointHit(this, cx);
        }

        public SourceInfo sourceInfo() {
            return this.fsource.sourceInfo();
        }

        public ContextData contextData() {
            return this.contextData;
        }

        public Object scope() {
            return this.scope;
        }

        public Object thisObj() {
            return this.thisObj;
        }

        public Object[] args() {
            return this.args;
        }

        public String getUrl() {
            return this.fsource.sourceInfo().url();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

