/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests.json;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.json.JsonParser;

public class JsonParserTest {
    private JsonParser parser;
    private Context cx;

    @Before
    public void setUp() {
        this.cx = Context.enter();
        this.parser = new JsonParser(this.cx, this.cx.initStandardObjects());
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseIllegalWhitespaceChars() throws Exception {
        this.parser.parseValue(" \u000b 1");
    }

    @Test
    public void shouldParseJsonNull() throws Exception {
        Assert.assertEquals(null, (Object)this.parser.parseValue("null"));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseJavaNull() throws Exception {
        this.parser.parseValue(null);
    }

    @Test
    public void shouldParseJsonBoolean() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.parser.parseValue("true"));
        Assert.assertEquals((Object)false, (Object)this.parser.parseValue("false"));
    }

    @Test
    public void shouldParseJsonNumbers() throws Exception {
        Assert.assertEquals((Object)1, (Object)this.parser.parseValue("1"));
        Assert.assertEquals((Object)-1, (Object)this.parser.parseValue("-1"));
        Assert.assertEquals((Object)1.5, (Object)this.parser.parseValue("1.5"));
        Assert.assertEquals((Object)1.5E13, (Object)this.parser.parseValue("1.5e13"));
        Assert.assertEquals((Object)1.0E16, (Object)this.parser.parseValue("9999999999999999"));
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.parser.parseValue("1.5e99999999"));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseDoubleNegativeNumbers() throws Exception {
        this.parser.parseValue("--5");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseNumbersWithDecimalExponent() throws Exception {
        this.parser.parseValue("5e5.5");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseNumbersBeginningWithZero() throws Exception {
        this.parser.parseValue("05");
    }

    @Test
    public void shouldParseJsonString() throws Exception {
        Assert.assertEquals((Object)"hello", (Object)this.parser.parseValue("\"hello\""));
        Assert.assertEquals((Object)"Sch\u00f6ne Gr\u00fc\u00dfe", (Object)this.parser.parseValue("\"Sch\\u00f6ne Gr\\u00fc\\u00dfe\""));
        Assert.assertEquals((Object)"", (Object)this.parser.parseValue(this.str('\"', '\"')));
        Assert.assertEquals((Object)" ", (Object)this.parser.parseValue(this.str('\"', ' ', '\"')));
        Assert.assertEquals((Object)"\r", (Object)this.parser.parseValue(this.str('\"', '\\', 'r', '\"')));
        Assert.assertEquals((Object)"\n", (Object)this.parser.parseValue(this.str('\"', '\\', 'n', '\"')));
        Assert.assertEquals((Object)"\t", (Object)this.parser.parseValue(this.str('\"', '\\', 't', '\"')));
        Assert.assertEquals((Object)"\\", (Object)this.parser.parseValue(this.str('\"', '\\', '\\', '\"')));
        Assert.assertEquals((Object)"/", (Object)this.parser.parseValue(this.str('\"', '/', '\"')));
        Assert.assertEquals((Object)"/", (Object)this.parser.parseValue(this.str('\"', '\\', '/', '\"')));
        Assert.assertEquals((Object)"\"", (Object)this.parser.parseValue(this.str('\"', '\\', '\"', '\"')));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseEmptyJavaString() throws Exception {
        this.parser.parseValue("");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseSingleDoubleQuote() throws Exception {
        this.parser.parseValue(this.str('\"'));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseStringContainingSingleBackslash() throws Exception {
        this.parser.parseValue(this.str('\"', '\\', '\"'));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseStringIllegalStringChars() throws Exception {
        this.parser.parseValue(this.str('\"', '\n', '\"'));
    }

    @Test
    public void shouldParseEmptyJsonArray() throws Exception {
        Assert.assertEquals((long)0L, (long)((NativeArray)this.parser.parseValue("[]")).getLength());
    }

    @Test
    public void shouldParseHeterogeneousJsonArray() throws Exception {
        NativeArray actual = (NativeArray)this.parser.parseValue("[ \"hello\" , 3, null, [false] ]");
        Assert.assertEquals((Object)"hello", (Object)actual.get(0, (Scriptable)actual));
        Assert.assertEquals((Object)3, (Object)actual.get(1, (Scriptable)actual));
        Assert.assertEquals(null, (Object)actual.get(2, (Scriptable)actual));
        NativeArray innerArr = (NativeArray)actual.get(3, (Scriptable)actual);
        Assert.assertEquals((Object)false, (Object)innerArr.get(0, (Scriptable)innerArr));
        Assert.assertEquals((long)4L, (long)actual.getLength());
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseArrayWithInvalidElements() throws Exception {
        this.parser.parseValue("[wtf]");
    }

    @Test
    public void shouldParseJsonObject() throws Exception {
        String json = "{\"bool\" : false, \"str\"  : \"xyz\", \"obj\"  : {\"a\":1} }";
        NativeObject actual = (NativeObject)this.parser.parseValue(json);
        Assert.assertEquals((Object)false, (Object)actual.get("bool", (Scriptable)actual));
        Assert.assertEquals((Object)"xyz", (Object)actual.get("str", (Scriptable)actual));
        NativeObject innerObj = (NativeObject)actual.get("obj", (Scriptable)actual);
        Assert.assertEquals((Object)1, (Object)innerObj.get("a", (Scriptable)innerObj));
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseJsonObjectsWithInvalidFormat() throws Exception {
        this.parser.parseValue("{\"only\", \"keys\"}");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseMoreThanOneToplevelValue() throws Exception {
        this.parser.parseValue("1 2");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseStringTruncatedUnicode() throws Exception {
        this.parser.parseValue("\"\\u00f\"");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseStringControlChars1() throws Exception {
        this.parser.parseValue("\"\u0000\"");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldFailToParseStringControlChars2() throws Exception {
        this.parser.parseValue("\"\u001f\"");
    }

    @Test
    public void shouldAllowTrailingWhitespace() throws Exception {
        this.parser.parseValue("1 ");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldThrowParseExceptionWhenIncompleteObject() throws Exception {
        this.parser.parseValue("{\"a\" ");
    }

    @Test(expected=JsonParser.ParseException.class)
    public void shouldThrowParseExceptionWhenIncompleteArray() throws Exception {
        this.parser.parseValue("[1 ");
    }

    private String str(char ... chars) {
        return new String(chars);
    }
}

